@extends('layouts.app')

@section('content')
<div class="container">
    <h3>إضافة عطلة جديدة</h3>

    <form action="{{ route('holidays.store') }}" method="POST">
        @csrf
        @if($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="form-label">الشهر</label>
                <select name="month" class="form-control">
                    @php $oldMonth = old('month', now()->month); @endphp
                    @for($m=1;$m<=12;$m++)
                        <option value="{{ $m }}" {{ $oldMonth == $m ? 'selected' : '' }}>{{ sprintf('%02d', $m) }}</option>
                    @endfor
                </select>
            </div>
            <div class="col-md-6 mb-3">
                <label class="form-label">اليوم</label>
                <select name="day" class="form-control">
                    @php $oldDay = old('day', now()->day); @endphp
                    @for($d=1;$d<=31;$d++)
                        <option value="{{ $d }}" {{ $oldDay == $d ? 'selected' : '' }}>{{ sprintf('%02d', $d) }}</option>
                    @endfor
                </select>
            </div>
        </div>
        <div class="mb-3">
            <label class="form-label">الاسم (اختياري)</label>
            <input type="text" name="name" class="form-control" value="{{ old('name') }}">
        </div>
        <div class="mb-3">
            <label class="form-label">سنة العطلات (اختياري)</label>
            <select name="holiday_year_id" class="form-control">
                <option value="">-- بدون سنة --</option>
                @foreach($years ?? [] as $y)
                    <option value="{{ $y->id }}" {{ old('holiday_year_id') == $y->id ? 'selected' : '' }}>{{ $y->year }} {{ $y->name ? ' - '.$y->name : '' }}</option>
                @endforeach
            </select>
        </div>
        <div class="form-check mb-3">
            <input type="hidden" name="is_paid" value="0">
            <input type="checkbox" name="is_paid" value="1" class="form-check-input" id="is_paid" {{ old('is_paid', true) ? 'checked' : '' }}>
            <label class="form-check-label" for="is_paid">مدفوعة</label>
        </div>
        <button class="btn btn-primary">حفظ</button>
    </form>
</div>
@endsection
