@extends('layouts.app')

@section('content')
<div class="container">
    <h3>{{ __('app.holidays') }} {{ $holidayYear->year }}</h3>
    <a href="{{ route('holiday-years.index') }}" class="btn btn-secondary mb-3">{{ __('app.back') }}</a>

    <div class="mb-4">
        <h5>{{ __('app.add') }} {{ __('app.holidays') }}</h5>
        <form action="{{ route('holidays.store') }}" method="POST">
            @csrf
            <input type="hidden" name="holiday_year_id" value="{{ $holidayYear->id }}">
            <div class="row">
                <div class="col-md-6 mb-2">
                    <label class="form-label">{{ __('app.month') }}</label>
                    <select name="month" class="form-control">
                        @for($m=1;$m<=12;$m++)
                            <option value="{{ $m }}" {{ old('month') == $m ? 'selected' : '' }}>{{ sprintf('%02d', $m) }}</option>
                        @endfor
                    </select>
                </div>
                <div class="col-md-6 mb-2">
                    <label class="form-label">{{ __('app.day') }}</label>
                    <select name="day" class="form-control">
                        @for($d=1;$d<=31;$d++)
                            <option value="{{ $d }}" {{ old('day') == $d ? 'selected' : '' }}>{{ sprintf('%02d', $d) }}</option>
                        @endfor
                    </select>
                </div>
            </div>
            <div class="mb-2">
                <label class="form-label">{{ __('app.name') }} ({{ __('app.optional') }})</label>
                <input type="text" name="name" class="form-control">
            </div>
            <div class="form-check mb-2">
                <input type="hidden" name="is_paid" value="0">
                <input type="checkbox" name="is_paid" value="1" class="form-check-input" id="is_paid">
                <label class="form-check-label" for="is_paid">{{ __('app.paid') }}</label>
            </div>
            <button class="btn btn-primary">{{ __('app.add') }}</button>
        </form>
    </div>

    <table class="table">
        <thead>
            <tr>
                <th>{{ __('app.date') }}</th>
                <th>{{ __('app.name') }}</th>
                <th>{{ __('app.paid') ?? 'Paid' }}</th>
                <th>{{ __('app.actions') }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach($holidays as $h)
                <tr>
                    <td>{{ $h->date->format('Y-m-d') }}</td>
                    <td>{{ $h->name }}</td>
                    <td>{{ $h->is_paid ? __('app.yes') : __('app.no') }}</td>
                    <td>
                        <a href="{{ route('holidays.edit', $h) }}" class="btn btn-sm btn-secondary">{{ __('app.edit') }}</a>
                        <form action="{{ route('holidays.destroy', $h) }}" method="POST" style="display:inline-block">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-sm btn-danger">{{ __('app.delete') }}</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
