@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h3 class="mb-0">{{ __('app.holiday_years') }}</h3>
                @php
                    $current = now();
                    $cy = $current->year;
                    $prevYear = $cy - 1;
                    $nextYear = $cy + 1;
                    $prevMonth = $current->copy()->subMonth();
                    $nextMonth = $current->copy()->addMonth();
                @endphp

                <div class="d-flex gap-2">
                    <div class="btn-group" role="group" aria-label="Year navigation">
                        <a href="{{ route('holidays.index') }}?year={{ $prevYear }}" class="btn btn-outline-secondary" title="عرض سنة {{ $prevYear }}">
                            <i class="fas fa-angle-left"></i> {{ $prevYear }}
                        </a>
                        <a href="{{ route('holidays.index') }}?year={{ $cy }}" class="btn btn-outline-info" title="{{ __('app.holidays') }} {{ $cy }}">
                            <i class="fas fa-calendar me-1"></i> {{ __('app.holidays') }} {{ $cy }}
                        </a>
                        <a href="{{ route('holidays.index') }}?year={{ $nextYear }}" class="btn btn-outline-secondary" title="عرض سنة {{ $nextYear }}">
                            {{ $nextYear }} <i class="fas fa-angle-right"></i>
                        </a>
                    </div>

                    <div class="btn-group" role="group" aria-label="Month navigation">
                        <a href="{{ route('holidays.index') }}?year={{ $prevMonth->year }}&month={{ $prevMonth->month }}" class="btn btn-outline-secondary" title="{{ $prevMonth->translatedFormat('F Y') }}">
                            <i class="fas fa-angle-left"></i> {{ $prevMonth->translatedFormat('M Y') }}
                        </a>
                        <a href="{{ route('holidays.index') }}?year={{ $cy }}&month={{ $current->month }}" class="btn btn-outline-primary" title="{{ __('app.holidays') }} {{ $current->translatedFormat('F Y') }}">
                            <i class="fas fa-calendar-day me-1"></i> {{ __('app.holidays') }} {{ $current->translatedFormat('F Y') }}
                        </a>
                        <a href="{{ route('holidays.index') }}?year={{ $nextMonth->year }}&month={{ $nextMonth->month }}" class="btn btn-outline-secondary" title="{{ $nextMonth->translatedFormat('F Y') }}">
                            {{ $nextMonth->translatedFormat('M Y') }} <i class="fas fa-angle-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card mb-3">
                <div class="card-body">
                    <form action="{{ route('holiday-years.store') }}" method="POST" class="row gx-2 gy-2 align-items-end">
                        @csrf
                        <div class="col-5">
                            <label class="form-label">{{ __('app.year') }}</label>
                            <input type="number" name="year" class="form-control" placeholder="{{ __('app.example') }}: 2026" required>
                        </div>
                        <div class="col-5">
                            <label class="form-label">{{ __('app.name') }} ({{ __('app.optional') }})</label>
                            <input type="text" name="name" class="form-control" placeholder="{{ __('app.description') ?? 'Description' }}">
                        </div>
                        <div class="col-2">
                            <button class="btn btn-primary w-100">{{ __('app.add') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-6 text-md-end mb-3">
            <form action="{{ route('holiday-years.generate') }}" method="POST" class="d-inline">
                @csrf
                <input type="hidden" name="start_year" value="{{ now()->year }}">
                <input type="hidden" name="end_year" value="2100">
                <button class="btn btn-outline-success">{{ __('app.create_years_until', ['year' => 2100]) }}</button>
            </form>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <div class="card">
        <div class="card-body p-0">
            <table class="table table-striped mb-0">
                <thead class="table-light">
                    <tr>
                        <th style="width:120px">{{ __('app.year') }}</th>
                        <th>{{ __('app.name') }}</th>
                        <th style="width:260px">{{ __('app.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($years as $y)
                        <tr>
                            <td class="align-middle">{{ $y->year }}</td>
                            <td class="align-middle">{{ $y->name }}</td>
                            <td class="align-middle">
                                @if($y->id)
                                    <a href="{{ route('holiday-years.show', $y) }}" class="btn btn-sm btn-info">{{ __('app.view') }}</a>
                                    <a href="{{ route('holiday-years.edit', $y) }}" class="btn btn-sm btn-secondary">{{ __('app.edit') }}</a>
                                    <form action="{{ route('holiday-years.destroy', $y) }}" method="POST" style="display:inline-block" onsubmit="return confirm('{{ addslashes(__('app.confirm_delete_item')) }}')">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn btn-sm btn-danger">{{ __('app.delete') }}</button>
                                    </form>
                                @else
                                    <form action="{{ route('holiday-years.store') }}" method="POST" style="display:inline-block">
                                        @csrf
                                        <input type="hidden" name="year" value="{{ $y->year }}">
                                        <button class="btn btn-sm btn-outline-primary">{{ __('app.create') }}</button>
                                    </form>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
