@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <h3 class="mb-3">{{ __('app.edit') }} {{ __('app.holiday_years') }}</h3>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('holiday-years.update', $holidayYear) }}" method="POST" class="row gx-2 gy-2 align-items-end">
                @csrf
                @method('PATCH')

                <div class="col-md-4">
                    <label class="form-label">{{ __('app.year') }}</label>
                    <input type="number" name="year" class="form-control" value="{{ old('year', $holidayYear->year) }}" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label">{{ __('app.name') }} ({{ __('app.optional') }})</label>
                    <input type="text" name="name" class="form-control" value="{{ old('name', $holidayYear->name) }}">
                </div>

                <div class="col-md-2">
                    <button class="btn btn-primary w-100">{{ __('app.save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
