@extends('layouts.app')

@section('content')
<div class="container">
    <h3>{{ __('app.create') }} {{ __('app.holiday_years') }}</h3>

    <form action="{{ route('holiday-years.store') }}" method="POST">
        @csrf
        @if($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="mb-3">
            <label class="form-label">{{ __('app.year') }} ({{ __('app.example') }}: 2026)</label>
            <input type="number" name="year" class="form-control" value="{{ old('year') }}" required>
        </div>
        <div class="mb-3">
            <label class="form-label">{{ __('app.name') }} ({{ __('app.optional') }})</label>
            <input type="text" name="name" class="form-control" value="{{ old('name') }}">
        </div>
        <button class="btn btn-primary">{{ __('app.save') }}</button>
    </form>
</div>
@endsection
