{{-- resources/views/employees/show.blade.php --}}
@extends('layouts.app')



@section('content')

<div class="container-fluid">

<!-- 🚀 حاوية الأزرار المثبتة -->
<div class="sticky-jump-buttons" style="position: sticky; top: 10px; z-index: 1000; background-color: white;">
    <!-- 🎯 عنوان تفاعلي لأزرار القفز السريع -->
    <div class="text-center mb-3 mt-2">
        <div class="d-inline-flex flex-column align-items-center">
            <span class="h5 fw-bold text-primary" style="font-family: 'Tajawal', 'Cairo', sans-serif; letter-spacing: -0.5px;">
                {{ __('employees.show.jump_description') }}
            </span>
            <!-- سهم متحرك لأسفل -->
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-primary mt-1 bounce-animate">
                <path d="M12 5v14M5 12l7 7 7-7"/>
            </svg>
        </div>
    </div>

    <!-- 🚀 أزرار القسم - معدّلة لتكون أصغر وأضيق ومقربة من بعضها ومحولة لليسار -->
    <div class="row g-0 justify-content-start">
        <div class="col-md-3 col-sm-6 px-1">
            <a href="#personal-info" class="btn btn-primary btn-sm w-75 py-1 jump-link">{{ __('employees.show.buttons.personal_info') }}</a>
        </div>
        <div class="col-md-3 col-sm-6 px-1">
            <a href="#salary-components" class="btn btn-primary btn-sm w-75 py-1 jump-link">{{ __('employees.show.buttons.salary_components') }}</a>
        </div>
        <div class="col-md-3 col-sm-6 px-1">
            <a href="#leave-accrual" class="btn btn-primary btn-sm w-75 py-1 jump-link">{{ __('employees.show.buttons.leave_accrual') }}</a>
        </div>
        <div class="col-md-3 col-sm-6 px-1">
            <a href="#attendance-records" class="btn btn-primary btn-sm w-75 py-1 jump-link">{{ __('employees.show.buttons.attendance') }}</a>
        </div>
        <div class="col-md-3 col-sm-6 px-1">
            <a href="#leave-requests" class="btn btn-primary btn-sm w-75 py-1 jump-link">{{ __('employees.show.buttons.leave_requests') }}</a>
        </div>
        <div class="col-md-3 col-sm-6 px-1">
            <a href="#loan-records" class="btn btn-primary btn-sm w-75 py-1 jump-link">{{ __('employees.show.buttons.loans') }}</a>
        </div>
        <div class="col-md-3 col-sm-6 px-1">
            <a href="#deduction-records" class="btn btn-primary btn-sm w-75 py-1 jump-link">{{ __('employees.show.buttons.deductions') }}</a>
        </div>
        <div class="col-md-3 col-sm-6 px-1">
            <a href="#payroll-summary" class="btn btn-primary btn-sm w-75 py-1 jump-link">{{ __('employees.show.buttons.payroll_summary') }}</a>
        </div>
        <div class="col-md-3 col-sm-6 px-1">
            <a href="#paid-salary" class="btn btn-primary btn-sm w-75 py-1 jump-link">{{ __('employees.show.buttons.paid_salaries') }}</a>
        </div>
    </div>
</div>

    <!-- Employee Info Card -->
    <a id="personal-info" class="anchor"></a>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-column flex-md-row align-items-center gap-4">
                        <div class="avatar-lg">
                            <img src="{{ $employee->photo ? asset('storage/' . $employee->photo) : asset('images/default-avatar.png') }}" alt="Profile Picture" class="img-fluid rounded-circle">
                        </div>
                        <div class="flex-grow-1 text-center text-md-start">
                            <h4 class="card-title mb-1">{{ $employee->name }}</h4>
                            <p class="text-muted mb-2">{{ $employee->position->name ?? __('employees.show.profile.position_placeholder') }}</p>
                            <p class="text-muted">{{ $employee->department->name ?? __('employees.show.profile.department_placeholder') }}</p>
                            <div class="d-flex flex-wrap gap-2 justify-content-center justify-content-md-start">
                                <span class="badge bg-primary">{{ __('employees.show.profile.badges.id') }}: {{ $employee->employee_id }}</span>
                                <span class="badge bg-info">{{ $employee->email }}</span>
                                <span class="badge bg-success">{{ $employee->phone ?? __('employees.show.profile.position_placeholder') }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-12">
            <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                @can('edit employee')
                    <a href="{{ route('employees.edit', $employee) }}" class="btn btn-warning">
                        <i class="fas fa-edit"></i> {{ __('employees.show.actions.edit') }}
                    </a>
                @endcan
                @can('delete employee')
                    <form action="{{ route('employees.destroy', $employee) }}" method="POST" onsubmit="return confirm('{{ __('employees.show.actions.delete_confirm') }}')" style="display:inline;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-trash"></i> ??? {{ __('employees.show.actions.delete') }}
                        </button>
                    </form>
                @endcan
                <a href="{{ route('employees.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> {{ __('employees.show.actions.back') }}
                </a>
            </div>
        </div>
    </div>

    <!-- Personal Information -->
    <a id="personal-info" class="anchor"></a>
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">{{ __('employees.show.sections.personal_info') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">{{ __('employees.show.personal.birth_date') }}:</label>
                                <p class="mb-0">{{ $employee->birth_date ? $employee->birth_date->format('Y-m-d') : __('employees.table.not_specified') }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">{{ __('employees.show.personal.age') }}:</label>
                                <p class="mb-0">
                                    {{ $employee->age ? $employee->age . ' ' . __('employees.show.personal.age_unit') : __('employees.table.not_specified') }}
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">{{ __('employees.show.personal.national_id') }}:</label>
                                <p class="mb-0">{{ $employee->national_id ?? __('employees.table.not_specified') }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">{{ __('employees.show.personal.qualification') }}:</label>
                                <p class="mb-0">{{ $employee->qualification ?? __('employees.table.not_specified') }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">{{ __('employees.show.personal.address') }}:</label>
                                <p class="mb-0">{{ $employee->address ?? __('employees.table.not_specified') }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">{{ __('employees.show.personal.status') }}:</label>
                                <p class="mb-0">
                                    @php
                                        $statusLabel = __('employees.show.personal.status_labels.' . ($employee->status ?? 'unknown'));
                                        $statusClass = match ($employee->status) {
                                            'active' => 'bg-success',
                                            'inactive' => 'bg-secondary',
                                            'pending' => 'bg-warning',
                                            default => 'bg-dark',
                                        };
                                    @endphp
                                    <span class="badge {{ $statusClass }}">{{ $statusLabel }}</span>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Salary Components -->
    <a id="salary-components" class="anchor"></a>
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">{{ __('employees.show.sections.salary_components') }}</h5>
                </div>
                <div class="card-body">
                    @php
                        $allComponents = $employee->addition_components;
                        $totalSalary = $employee->getTotalSalaryWithComponentsAttribute();
                    @endphp
                    @if($allComponents && $allComponents->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>{{ __('employees.show.salary.name') }}</th>
                                        <th>{{ __('employees.show.salary.value') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($allComponents as $comp)
                                        <tr>
                                            <td>{{ $comp['name'] }}</td>
                                            <td>{{ number_format($comp['value'], 2) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-center text-muted">{{ __('employees.show.salary.no_components') }}</p>
                    @endif
                    <!-- ✅ تم حذف الكود المكرر وترك الحساب الصحيح فقط -->
                    <div class="mt-3">
                        <strong>{{ __('employees.show.salary.total') }}</strong> {{ number_format($totalSalary, 2) }} {{ get_currency_code() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

                {{-- Salary history (effective-dated compensation) --}}
                @include('employees.partials.salary_histories', ['employee' => $employee, 'histories' => $employee->salaryHistories()->orderBy('effective_from', 'desc')->get()])

                <!-- Leave Accrual Details -->
                <a id="leave-accrual" class="anchor"></a>
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">{{ __('employees.show.leave_accrual.title') }}</h5>
                    <a href="{{ route('employees.printLeaveAccrual', $employee) }}" class="btn btn-success btn-sm" target="_blank">
                        <i class="fas fa-print"></i> {{ __('employees.show.leave_accrual.print') }}
                    </a>
                </div>
                <div class="card-body">
                    @php
                        $leaveMonthlyDetails = $employee->calculateLeaveDeductionDetailsNew(now()->year, now()->month);
                    @endphp
                    @if(!$employee->isAccrualEnabled())
                        <div class="alert alert-info" role="alert">
                            <i class="fas fa-info-circle"></i>
                            <strong>{{ __('employees.show.leave_accrual.accrual_disabled') ?? 'تراكم الإجازات معطل' }}</strong>
                            <p class="mb-0 mt-2">{{ __('employees.show.leave_accrual.accrual_disabled_message') ?? 'هذا الموظف لا يراكم الإجازات الشهرية والسنوية. يجب تفعيل خاصية التراكم من بيانات الموظف.' }}</p>
                        </div>
                    @elseif($leaveMonthlyDetails && count($leaveMonthlyDetails) > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th colspan="9" class="bg-light text-center"><strong>{{ __('employees.show.leave_accrual.labels.monthly') }}</strong></th>
                                        <th colspan="6" class="bg-light text-center"><strong>{{ __('employees.show.leave_accrual.labels.annual') }}</strong></th>
                                    </tr>
                                    <tr>
                                        <th>{{ __('employees.show.leave_accrual.columns.year') }}</th>
                                        <th>{{ __('employees.show.leave_accrual.columns.month') }}</th>
                                        <!-- Monthly leave -->
                                        <th>{{ __('employees.show.leave_accrual.columns.granted') }} <small class="d-block text-muted">(شهري)</small></th>
                                        <th>{{ __('employees.show.leave_accrual.columns.used') }} <small class="d-block text-muted">(شهري)</small></th>
                                        <th>{{ __('employees.show.leave_accrual.columns.balance_before') }} <small class="d-block text-muted">(شهري)</small></th>
                                        <th>{{ __('employees.show.leave_accrual.columns.balance_after') }} <small class="d-block text-muted">(شهري)</small></th>
                                        <th>{{ __('employees.show.leave_accrual.columns.excess') }} <small class="d-block text-muted">(شهري)</small></th>
                                        <th>{{ __('employees.show.leave_accrual.columns.amount', ['currency' => get_currency_code()]) }} <small class="d-block text-muted">(شهري)</small></th>
                                        <th>الإجمالي<br><small class="text-muted">{{ get_currency_code() }}</small></th>
                                        <!-- Annual leave -->
                                        <th>{{ __('employees.show.leave_accrual.columns.used') }} <small class="d-block text-muted">(سنوي)</small></th>
                                        <th>{{ __('employees.show.leave_accrual.columns.balance_before') }} <small class="d-block text-muted">(سنوي)</small></th>
                                        <th>{{ __('employees.show.leave_accrual.columns.balance_after') }} <small class="d-block text-muted">(سنوي)</small></th>
                                        <th>{{ __('employees.show.leave_accrual.columns.excess') }} <small class="d-block text-muted">(سنوي)</small></th>
                                        <th>{{ __('employees.show.leave_accrual.columns.amount', ['currency' => get_currency_code()]) }} <small class="d-block text-muted">(سنوي)</small></th>
                                        <th>{{ __('employees.show.leave_accrual.columns.annual_entitlement') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($leaveMonthlyDetails as $detail)
                                        <tr>
                                            <td>{{ $detail['year'] }}</td>
                                            <td>{{ $detail['month_name'] ?? \Carbon\Carbon::create()->month($detail['month'])->translatedFormat('F') }}</td>
                                            <!-- Monthly Leave Data -->
                                            <td class="text-center">{{ number_format($detail['granted_monthly'] ?? 0, 2) }}</td>
                                            <td class="text-center">{{ number_format($detail['used_monthly'] ?? 0, 2) }}</td>
                                            <td class="text-center">{{ number_format($detail['balance_before_monthly'] ?? 0, 2) }}</td>
                                            <td class="text-center">{{ number_format($detail['balance_after_monthly'] ?? 0, 2) }}</td>
                                            <td class="text-center text-warning">{{ number_format($detail['excess_monthly'] ?? 0, 2) }}</td>
                                            <td class="text-danger fw-bold">{{ format_currency($detail['deduction_amount_monthly'] ?? 0) }}</td>
                                            <td class="text-danger fw-bold">{{ format_currency($detail['leave_deduction_amount'] ?? 0) }}</td>
                                            <!-- Annual Leave Data -->
                                            <td class="text-center">{{ number_format($detail['used_annual'] ?? 0, 2) }}</td>
                                            <td class="text-center">{{ number_format($detail['balance_before_annual'] ?? 0, 2) }}</td>
                                            <td class="text-center">{{ number_format($detail['balance_after_annual'] ?? 0, 2) }}</td>
                                            <td class="text-center text-warning">{{ number_format($detail['excess_annual'] ?? 0, 2) }}</td>
                                            <td class="text-danger fw-bold">{{ format_currency($detail['deduction_amount_annual'] ?? 0) }}</td>
                                            <td>{{ number_format($employee->annual_entitlement ?? ($employee->monthly_leave_days_allowed * 12), 2) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- ✅ ملخص الخصومات للسنة الحالية -->
                        @php
                            $currentYear = now()->year;
                            $currentYearMonthlyDeductions = $leaveMonthlyDetails
                                ->filter(fn($d) => $d['year'] == $currentYear)
                                ->sum('deduction_amount_monthly');
                            $currentYearAnnualDeductions = $leaveMonthlyDetails
                                ->filter(fn($d) => $d['year'] == $currentYear)
                                ->sum('deduction_amount_annual');
                            $totalCurrentYearDeductions = $currentYearMonthlyDeductions + $currentYearAnnualDeductions;
                        @endphp
                        <div class="alert alert-danger mt-3" role="alert">
                            <h6 class="alert-heading">ملخص الخصومات للسنة الحالية ({{ $currentYear }})</h6>
                            <hr>
                            <div class="row">
                                <div class="col-md-6">
                                    <p class="mb-2"><strong>إجمالي خصومات الإجازات الشهرية:</strong></p>
                                    <p class="fs-5 fw-bold text-danger">{{ format_currency($currentYearMonthlyDeductions) }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p class="mb-2"><strong>إجمالي خصومات الإجازات السنوية:</strong></p>
                                    <p class="fs-5 fw-bold text-danger">{{ format_currency($currentYearAnnualDeductions) }}</p>
                                </div>
                            </div>
                            <hr>
                            <p class="mb-0"><strong>إجمالي الخصومات (شهري + سنوي):</strong></p>
                            <p class="fs-4 fw-bold text-danger">{{ format_currency($totalCurrentYearDeductions) }}</p>
                        </div>
                    @else
                        <div class="alert alert-warning" role="alert">
                            <i class="fas fa-exclamation-triangle"></i>
                            <strong>{{ __('employees.show.leave_accrual.no_data') ?? 'لا توجد بيانات' }}</strong>
                            <p class="mb-0 mt-2">لم يتم العثور على بيانات تراكمية للإجازات. تأكد من أن الموظف لديه فترة عمل كافية وأن التراكم مُفعّل.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Attendance Records -->
    <a id="attendance-records" class="anchor"></a>
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">{{ __('employees.show.attendance.title') }}</h5>
                    <div class="d-flex gap-2">
                        <div class="col-md-3">
                            <select class="form-control form-select" id="attendanceMonthFilter">
                                <option value="">{{ __('employees.show.filters.all_months') }}</option>
                                @for ($m = 1; $m <= 12; $m++)
                                    <option value="{{ $m }}" {{ request('attendance_month') == $m ? 'selected' : '' }}>
                                        {{ \Carbon\Carbon::create()->month($m)->translatedFormat('F') }}
                                    </option>
                                @endfor
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-control form-select" id="attendanceYearFilter">
                                <option value="">{{ __('employees.show.filters.all_years') }}</option>
                                @for ($y = now()->year; $y >= now()->year - 5; $y--)
                                    <option value="{{ $y }}" {{ request('attendance_year') == $y ? 'selected' : '' }}>
                                        {{ $y }}
                                    </option>
                                @endfor
                            </select>
                        </div>
                        <button class="btn btn-success btn-sm" id="applyAttendanceFilters">
                            <i class="fas fa-filter"></i> {{ __('employees.show.filters.apply') }}
                        </button>
                        <a href="{{ route('employees.printAttendances', $employee) }}" class="btn btn-success btn-sm" target="_blank">
                            <i class="fas fa-print"></i> {{ __('employees.show.filters.print_record') }}
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-centered table-hover table-striped" id="payrollSummaryTable">
                            <thead class="thead-light">
                                    <tr>
                                    <th>{{ __('employees.show.attendance.columns.date') }}</th>
                                    <th>{{ __('employees.show.attendance.columns.check_in') }}</th>
                                        <th>{{ __('employees.show.attendance.columns.check_out') }}</th>
                                        <th>{{ __('employees.show.attendance.columns.duration') }}</th>
                                        <th>{{ __('payroll.labels.overtime_hours') }}</th>
                                        <th>{{ __('payroll.labels.overtime_amount') }}</th>
                                        <th>{{ __('payroll.labels.underworked_hours') }}</th>
                                        <th>{{ __('payroll.labels.underworked_amount') }}</th>
                                    <th>{{ __('employees.show.attendance.columns.status') }}</th>
                                    <th>{{ __('employees.show.attendance.columns.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($attendances as $attendance)
                                    <tr data-id="{{ $attendance->id }}"
                                            data-status="{{ $attendance->status }}"
                                            data-date="{{ $attendance->date->format('Y-m-d') }}">
                                            <td>{{ $attendance->date->format('Y-m-d') }}</td>
                                            <td>{{ $attendance->check_in ?? '—' }}</td>
                                            <td>{{ $attendance->check_out ?? '—' }}</td>
                                            <td>{{ $attendance->duration ?? '—' }}</td>
                                            <td>{{ number_format($attendance->getOvertimeHours(), 2) }}</td>
                                            <td>{{ number_format((($employee->overtime_paid ?? true) ? ($attendance->getOvertimeHours() * ($employee->overtime_hourly_rate ?? 0)) : 0), 2) }} {{ get_currency_code() }}</td>
                                            <td>{{ number_format($attendance->getUnderworkedHours(), 2) }}</td>
                                            <td class="text-danger">{{ number_format($attendance->getUnderworkedValue(), 2) }} {{ get_currency_code() }}</td>
                                            <td>
                                                @php
                                                    $displayStatus = $attendance->status;
                                                @endphp
                                                <span class="badge
                                                    @if(in_array($displayStatus, ['present','present_on_official_holiday','present_on_weekly_off'])) bg-success
                                                    @elseif($displayStatus === 'absent') bg-danger
                                                    @elseif($displayStatus === 'late') bg-warning
                                                    @elseif($displayStatus === 'leave') bg-info
                                                    @else bg-secondary @endif">
                                                    @if($displayStatus === 'present_on_official_holiday')
                                                        {{ __('calendar.statuses.present_on_official_holiday') }}
                                                    @elseif($displayStatus === 'present_on_weekly_off')
                                                        {{ __('calendar.statuses.present_on_weekly_off') }}
                                                    @else
                                                        {{ __('app.attendance_status.' . $attendance->status) }}
                                                    @endif
                                                </span>
                                            </td>
                                            <td>
                                                <a href="{{ route('attendance.show', $attendance->id) }}" class="btn btn-info btn-sm">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">{{ __('employees.show.attendance.no_records') }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Leave Requests -->
    <a id="leave-requests" class="anchor"></a>
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">{{ __('employees.show.leaves.title') }}</h5>
                    <div class="d-flex gap-2">
                        <div class="col-md-3">
                            <select class="form-control form-select" id="leaveMonthFilter">
                                <option value="">{{ __('employees.show.filters.all_months') }}</option>
                                @for ($m = 1; $m <= 12; $m++)
                                    <option value="{{ $m }}" {{ request('leave_month') == $m ? 'selected' : '' }}>
                                        {{ \Carbon\Carbon::create()->month($m)->translatedFormat('F') }}
                                    </option>
                                @endfor
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-control form-select" id="leaveYearFilter">
                                <option value="">{{ __('employees.show.filters.all_years') }}</option>
                                @for ($y = now()->year; $y >= now()->year - 5; $y--)
                                    <option value="{{ $y }}" {{ request('leave_year') == $y ? 'selected' : '' }}>
                                        {{ $y }}
                                    </option>
                                @endfor
                            </select>
                        </div>
                        <button class="btn btn-success btn-sm" id="applyLeaveFilters">
                            <i class="fas fa-filter"></i> {{ __('employees.show.filters.apply') }}
                        </button>
                        <a href="{{ route('employees.printLeaves', $employee) }}" class="btn btn-success btn-sm" target="_blank">
                            <i class="fas fa-print"></i> {{ __('employees.show.filters.print_record') }}
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-centered table-hover" id="leavesTable">
                            <thead class="thead-light">
                                <tr>
                                    <th>{{ __('employees.show.leaves.columns.id') }}</th>
                                    <th>{{ __('employees.show.leaves.columns.type') }}</th>
                                    <th>{{ __('employees.show.leaves.columns.start') }}</th>
                                    <th>{{ __('employees.show.leaves.columns.end') }}</th>
                                    <th>{{ __('employees.show.leaves.columns.days') }}</th>
                                    <th>{{ __('employees.show.leaves.columns.reason') }}</th>
                                    <th>{{ __('employees.show.leaves.columns.status') }}</th>
                                    <th>{{ __('employees.show.leaves.columns.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($leaves as $leave)
                                    <tr data-id="{{ $leave->id }}"
                                        data-status="{{ $leave->status }}"
                                        data-type="{{ $leave->leave_type }}"
                                        data-start="{{ $leave->start_date->format('Y-m-d') }}"
                                        data-end="{{ $leave->end_date->format('Y-m-d') }}">
                                        <td>{{ $leave->id }}</td>
                                        <td>{{ __('app.leave_types.' . $leave->leave_type) }}</td>
                                        <td>{{ $leave->start_date->format('Y-m-d') }}</td>
                                        <td>{{ $leave->end_date->format('Y-m-d') }}</td>
                                        <td>{{ $leave->days_count }}</td>
                                        <td>{{ Str::limit($leave->reason, 30) }}</td>
                                        <td>
                                            <span class="badge bg-dark text-white">
                                                {{ __('employees.show.leaves.statuses.' . $leave->status) }}
                                            </span>
                                        </td>
                                        <td>
                                            @can('view leave')
                                                <a href="{{ route('leaves.show', $leave) }}" class="btn btn-info btn-sm">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            @endcan
                                            @can('edit leave')
                                                <a href="{{ route('leaves.edit', $leave) }}" class="btn btn-warning btn-sm">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            @endcan
                                            @can('delete leave')
                                                <form action="{{ route('leaves.destroy', $leave) }}" method="POST" onsubmit="return confirm('{{ __('employees.show.leaves.delete_confirm') }}')" style="display:inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm">
                                                        <i class="fas fa-trash"></i> ???
                                                    </button>
                                                </form>
                                            @endcan
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">{{ __('employees.show.leaves.no_records') }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Loan Records -->
    <a id="loan-records" class="anchor"></a>
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">{{ __('employees.show.loans.title') }}</h5>
                    <div class="d-flex gap-2">
                        <div class="col-md-3">
                            <select class="form-control form-select" id="loanMonthFilter">
                                <option value="">{{ __('employees.show.filters.all_months') }}</option>
                                @for ($m = 1; $m <= 12; $m++)
                                    <option value="{{ $m }}" {{ request('loan_month') == $m ? 'selected' : '' }}>
                                        {{ \Carbon\Carbon::create()->month($m)->translatedFormat('F') }}
                                    </option>
                                @endfor
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-control form-select" id="loanYearFilter">
                                <option value="">{{ __('employees.show.filters.all_years') }}</option>
                                @for ($y = now()->year; $y >= now()->year - 5; $y--)
                                    <option value="{{ $y }}" {{ request('loan_year') == $y ? 'selected' : '' }}>
                                        {{ $y }}
                                    </option>
                                @endfor
                            </select>
                        </div>
                        <button class="btn btn-success btn-sm" id="applyLoanFilters">
                            <i class="fas fa-filter"></i> {{ __('employees.show.filters.apply') }}
                        </button>
                        <a href="{{ route('employees.printLoans', $employee) }}" class="btn btn-success btn-sm" target="_blank">
                            <i class="fas fa-print"></i> {{ __('employees.show.filters.print_record') }}
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-centered table-hover" id="loansTable">
                            <thead class="thead-light">
                                <tr>
                                    <th>{{ __('employees.show.loans.columns.id') }}</th>
                                    <th>{{ __('employees.show.loans.columns.amount') }}</th>
                                    <th>{{ __('employees.show.loans.columns.interest') }}</th>
                                    <th>{{ __('employees.show.loans.columns.total') }}</th>
                                    <th>{{ __('employees.show.loans.columns.installments') }}</th>
                                    <th>{{ __('employees.show.loans.columns.monthly') }}</th>
                                    <th>{{ __('employees.show.loans.columns.date') }}</th>
                                    <th>{{ __('employees.show.loans.columns.status') }}</th>
                                    <th>{{ __('employees.show.loans.columns.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($loans as $loan)
                                    <tr data-id="{{ $loan->id }}"
                                        data-status="{{ $loan->status }}"
                                        data-start="{{ $loan->created_at->format('Y-m-d H:i') }}"
                                        data-end="{{ $loan->updated_at->format('Y-m-d H:i') }}">
                                        <td>{{ $loan->id }}</td>
                                        <td>{{ number_format($loan->amount, 2) }} {{ get_currency_code() }}</td>
                                        <td>{{ number_format($loan->interest_rate, 2) }}%</td>
                                        <td>{{ number_format($loan->total_amount, 2) }} {{ get_currency_code() }}</td>
                                        <td>{{ $loan->installment_count }}</td>
                                        <td>{{ number_format($loan->installment_amount, 2) }} {{ get_currency_code() }}</td>
                                        <td>{{ $loan->created_at->format('Y-m-d H:i') }}</td>
                                        <td>
                                            @php
                                                $loanStatusClass = match ($loan->status) {
                                                    'pending' => 'badge-warning',
                                                    'approved' => 'badge-primary',
                                                    'active' => 'badge-success',
                                                    'rejected' => 'badge-danger',
                                                    'paid' => 'badge-info',
                                                    'cancelled' => 'badge-secondary',
                                                    default => 'badge-dark',
                                                };
                                            @endphp
                                            <span class="badge {{ $loanStatusClass }}">{{ __('employees.show.loans.statuses.' . ($loan->status ?? 'unknown')) }}</span>
                                        </td>
                                        <td>
                                            @can('view loan')
                                                <a href="{{ route('loans.show', $loan) }}" class="btn btn-info btn-sm">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            @endcan
                                            @can('edit loan')
                                                <a href="{{ route('loans.edit', $loan) }}" class="btn btn-warning btn-sm">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            @endcan
                                            @can('delete loan')
                                                <form action="{{ route('loans.destroy', $loan) }}" method="POST" onsubmit="return confirm('{{ __('employees.show.loans.delete_confirm') }}')" style="display:inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm">
                                                        <i class="fas fa-trash"></i> ???
                                                    </button>
                                                </form>
                                            @endcan
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">{{ __('employees.show.loans.no_records') }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Deduction Records -->
    <a id="deduction-records" class="anchor"></a>
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">{{ __('employees.show.deductions.title') }}</h5>
                    <div class="d-flex gap-2">
                        <div class="col-md-3">
                            <select class="form-control form-select" id="deductionMonthFilter">
                                <option value="">{{ __('employees.show.filters.all_months') }}</option>
                                @for ($m = 1; $m <= 12; $m++)
                                    <option value="{{ $m }}" {{ request('deduction_month') == $m ? 'selected' : '' }}>
                                        {{ \Carbon\Carbon::create()->month($m)->translatedFormat('F') }}
                                    </option>
                                @endfor
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-control form-select" id="deductionYearFilter">
                                <option value="">{{ __('employees.show.filters.all_years') }}</option>
                                @for ($y = now()->year; $y >= now()->year - 5; $y--)
                                    <option value="{{ $y }}" {{ request('deduction_year') == $y ? 'selected' : '' }}>
                                        {{ $y }}
                                    </option>
                                @endfor
                            </select>
                        </div>
                        <button class="btn btn-success btn-sm" id="applyDeductionFilters">
                            <i class="fas fa-filter"></i> {{ __('employees.show.filters.apply') }}
                        </button>
                        <a href="{{ route('employees.printDeductions', $employee) }}" class="btn btn-success btn-sm" target="_blank">
                            <i class="fas fa-print"></i> {{ __('employees.show.filters.print_record') }}
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-centered table-hover" id="deductionsTable">
                            <thead class="thead-light">
                                <tr>
                                    <th>{{ __('employees.show.deductions.columns.id') }}</th>
                                    <th>{{ __('employees.show.deductions.columns.description') }}</th>
                                    <th>{{ __('employees.show.deductions.columns.amount') }}</th>
                                    <th>{{ __('employees.show.deductions.columns.type') }}</th>
                                    <th>{{ __('employees.show.deductions.columns.date') }}</th>
                                    <th>{{ __('employees.show.deductions.columns.status') }}</th>
                                    <th>{{ __('employees.show.deductions.columns.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($deductions as $deduction)
                                    <tr data-id="{{ $deduction->id }}"
                                        data-status="{{ $deduction->status }}"
                                        data-date="{{ $deduction->deduction_date->format('Y-m-d') }}">
                                        <td>{{ $deduction->id }}</td>
                                        <td>{{ $deduction->description }}</td>
                                        <td>{{ number_format($deduction->amount, 2) }} {{ get_currency_code() }}</td>
                                        @php
                                            $rawType = (string) ($deduction->type ?? '');
                                            $typeTranslations = [
                                                'social_insurance' => 'التأمين الاجتماعي',
                                                'health_insurance' => 'التأمين الصحي',
                                                'health-insurance' => 'التأمين الصحي',
                                                'health insurance' => 'التأمين الصحي',
                                                'healthinsurance' => 'التأمين الصحي',
                                                'loan' => 'سداد القرض',
                                                'tax' => 'الضرائب',
                                                'penalty' => 'غرامة',
                                                'other' => 'أخرى',
                                                'miscellaneous' => 'متفرقات',
                                                'pension' => 'التقاعد',
                                                'unemployment' => 'التأمين ضد البطالة',
                                            ];
                                            
                                            $typeLabel = $typeTranslations[strtolower($rawType)] ?? \Illuminate\Support\Str::title(str_replace(['_', '-'], ' ', $rawType));
                                        @endphp
                                        <td>{{ $typeLabel }}</td>
                                        <td>{{ $deduction->deduction_date->format('Y-m-d') }}</td>
                                        <td>
                                            @php
                                                $deductionStatusClass = match ($deduction->status) {
                                                    'applied' => 'badge-success',
                                                    'pending' => 'badge-warning',
                                                    'cancelled' => 'badge-secondary',
                                                    default => 'badge-dark',
                                                };
                                            @endphp
                                            <span class="badge {{ $deductionStatusClass }}">{{ $deduction->status }}</span>
                                        </td>
                                        <td>
                                            @can('view deduction')
                                                <a href="{{ route('deductions.show', $deduction) }}" class="btn btn-info btn-sm">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            @endcan
                                            @can('edit deduction')
                                                <a href="{{ route('deductions.edit', $deduction) }}" class="btn btn-warning btn-sm">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            @endcan
                                            @can('delete deduction')
                                                <form action="{{ route('deductions.destroy', $deduction) }}" method="POST" onsubmit="return confirm('{{ __('employees.show.deductions.delete_confirm') }}')" style="display:inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm">
                                                        <i class="fas fa-trash"></i> ???
                                                    </button>
                                                </form>
                                            @endcan
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">{{ __('employees.show.deductions.no_records') }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

  

        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">{{ __('employees.show.paid_salaries.title') }}</h5>
                    <div class="d-flex gap-2">
                        <div class="col-md-3">
                            <select class="form-control form-select" id="paidPayrollMonthFilter">
                                <option value="">{{ __('employees.show.filters.all_months') }}</option>
                                @for ($m = 1; $m <= 12; $m++)
                                    <option value="{{ $m }}">{{ \Carbon\Carbon::create()->month($m)->translatedFormat('F') }}</option>
                                @endfor
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-control form-select" id="paidPayrollYearFilter">
                                <option value="">{{ __('employees.show.filters.all_years') }}</option>
                                @for ($y = now()->year; $y >= now()->year - 5; $y--)
                                    <option value="{{ $y }}">{{ $y }}</option>
                                @endfor
                            </select>
                        </div>
                        <!-- ✅ تعديل: استخدام رابط طباعة الرواتب للموظف -->
                        <a href="{{ route('employees.printPayrolls', $employee) }}" class="btn btn-success btn-sm" target="_blank">
                            <i class="fas fa-print"></i> {{ __('employees.show.filters.print_record') }}
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-centered table-hover" id="paidPayrollTable">
                            <thead class="thead-light">
                                <tr>
                                    <th>الشهر والسنة</th>
                                    <th>تاريخ الدفع</th>
                                    <th>عرض الراتب</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($paidPayrolls as $payroll)
                                    <tr data-month="{{ $payroll->month }}" data-year="{{ $payroll->year }}">
                                        <td>{{ \Carbon\Carbon::create()->month($payroll->month)->translatedFormat('F') }} {{ $payroll->year }}</td>
                                        <td>{{ $payroll->paid_at ? $payroll->paid_at->format('Y-m-d H:i') : __('employees.show.paid_salaries.not_paid') }}</td>
                                        <td>
                                            <a href="{{ route('payroll.show', $payroll) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i> عرض الراتب
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3" class="text-center">{{ __('employees.show.paid_salaries.no_records') }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')



@push('styles')
<style>
.fixed-top.bg-white.shadow-sm {
    z-index: 1020 !important;
}
</style>
@endpush

<script>
// ====================== فلترة جدول الرواتب المدفوعة ======================
document.getElementById('paidPayrollMonthFilter')?.addEventListener('change', function() {
    const selectedMonth = this.value;
    const selectedYear = document.getElementById('paidPayrollYearFilter').value;
    const rows = document.querySelectorAll('#paidPayrollTable tbody tr');
    rows.forEach(row => {
        const rowMonth = row.getAttribute('data-month');
        const rowYear = row.getAttribute('data-year');
        const monthMatch = !selectedMonth || rowMonth == selectedMonth;
        const yearMatch = !selectedYear || rowYear == selectedYear;
        row.style.display = monthMatch && yearMatch ? '' : 'none';
    });
});

document.getElementById('paidPayrollYearFilter')?.addEventListener('change', function() {
    const selectedYear = this.value;
    const selectedMonth = document.getElementById('paidPayrollMonthFilter').value;
    const rows = document.querySelectorAll('#paidPayrollTable tbody tr');
    rows.forEach(row => {
        const rowMonth = row.getAttribute('data-month');
        const rowYear = row.getAttribute('data-year');
        const monthMatch = !selectedMonth || rowMonth == selectedMonth;
        const yearMatch = !selectedYear || rowYear == selectedYear;
        row.style.display = monthMatch && yearMatch ? '' : 'none';
    });
});

// ====================== فلترة جدول الحضور ======================
document.getElementById('attendanceMonthFilter')?.addEventListener('change', function() {
    const selectedMonth = this.value;
    const selectedYear = document.getElementById('attendanceYearFilter').value;
    const rows = document.querySelectorAll('#attendanceTable tbody tr');
    rows.forEach(row => {
        const rowDate = row.getAttribute('data-date');
        const rowYear = rowDate ? rowDate.split('-')[0] : '';
        const rowMonth = rowDate ? parseInt(rowDate.split('-')[1]) : '';
        const monthMatch = !selectedMonth || rowMonth == selectedMonth;
        const yearMatch = !selectedYear || rowYear == selectedYear;
        row.style.display = monthMatch && yearMatch ? '' : 'none';
    });
});

document.getElementById('attendanceYearFilter')?.addEventListener('change', function() {
    const selectedYear = this.value;
    const selectedMonth = document.getElementById('attendanceMonthFilter').value;
    const rows = document.querySelectorAll('#attendanceTable tbody tr');
    rows.forEach(row => {
        const rowDate = row.getAttribute('data-date');
        const rowYear = rowDate ? rowDate.split('-')[0] : '';
        const rowMonth = rowDate ? parseInt(rowDate.split('-')[1]) : '';
        const monthMatch = !selectedMonth || rowMonth == selectedMonth;
        const yearMatch = !selectedYear || rowYear == selectedYear;
        row.style.display = monthMatch && yearMatch ? '' : 'none';
    });
});

// ====================== فلترة جدول طلبات الإجازات ======================
document.getElementById('leaveMonthFilter')?.addEventListener('change', function() {
    const selectedMonth = this.value;
    const selectedYear = document.getElementById('leaveYearFilter').value;
    const rows = document.querySelectorAll('#leavesTable tbody tr');
    rows.forEach(row => {
        const startDate = row.getAttribute('data-start');
        const rowYear = startDate ? startDate.split('-')[0] : '';
        const rowMonth = startDate ? parseInt(startDate.split('-')[1]) : '';
        const monthMatch = !selectedMonth || rowMonth == selectedMonth;
        const yearMatch = !selectedYear || rowYear == selectedYear;
        row.style.display = monthMatch && yearMatch ? '' : 'none';
    });
});

document.getElementById('leaveYearFilter')?.addEventListener('change', function() {
    const selectedYear = this.value;
    const selectedMonth = document.getElementById('leaveMonthFilter').value;
    const rows = document.querySelectorAll('#leavesTable tbody tr');
    rows.forEach(row => {
        const startDate = row.getAttribute('data-start');
        const rowYear = startDate ? startDate.split('-')[0] : '';
        const rowMonth = startDate ? parseInt(startDate.split('-')[1]) : '';
        const monthMatch = !selectedMonth || rowMonth == selectedMonth;
        const yearMatch = !selectedYear || rowYear == selectedYear;
        row.style.display = monthMatch && yearMatch ? '' : 'none';
    });
});

// ====================== فلترة جدول القروض ======================
document.getElementById('loanMonthFilter')?.addEventListener('change', function() {
    const selectedMonth = this.value;
    const selectedYear = document.getElementById('loanYearFilter').value;
    const rows = document.querySelectorAll('#loansTable tbody tr');
    rows.forEach(row => {
        const startDate = row.getAttribute('data-start');
        const rowYear = startDate ? startDate.split(' ')[0].split('-')[0] : '';
        const rowMonth = startDate ? parseInt(startDate.split(' ')[0].split('-')[1]) : '';
        const monthMatch = !selectedMonth || rowMonth == selectedMonth;
        const yearMatch = !selectedYear || rowYear == selectedYear;
        row.style.display = monthMatch && yearMatch ? '' : 'none';
    });
});

document.getElementById('loanYearFilter')?.addEventListener('change', function() {
    const selectedYear = this.value;
    const selectedMonth = document.getElementById('loanMonthFilter').value;
    const rows = document.querySelectorAll('#loansTable tbody tr');
    rows.forEach(row => {
        const startDate = row.getAttribute('data-start');
        const rowYear = startDate ? startDate.split(' ')[0].split('-')[0] : '';
        const rowMonth = startDate ? parseInt(startDate.split(' ')[0].split('-')[1]) : '';
        const monthMatch = !selectedMonth || rowMonth == selectedMonth;
        const yearMatch = !selectedYear || rowYear == selectedYear;
        row.style.display = monthMatch && yearMatch ? '' : 'none';
    });
});

// ====================== فلترة جدول الاستقطاعات ======================
document.getElementById('deductionMonthFilter')?.addEventListener('change', function() {
    const selectedMonth = this.value;
    const selectedYear = document.getElementById('deductionYearFilter').value;
    const rows = document.querySelectorAll('#deductionsTable tbody tr');
    rows.forEach(row => {
        const rowDate = row.getAttribute('data-date');
        const rowYear = rowDate ? rowDate.split('-')[0] : '';
        const rowMonth = rowDate ? parseInt(rowDate.split('-')[1]) : '';
        const monthMatch = !selectedMonth || rowMonth == selectedMonth;
        const yearMatch = !selectedYear || rowYear == selectedYear;
        row.style.display = monthMatch && yearMatch ? '' : 'none';
    });
});

document.getElementById('deductionYearFilter')?.addEventListener('change', function() {
    const selectedYear = this.value;
    const selectedMonth = document.getElementById('deductionMonthFilter').value;
    const rows = document.querySelectorAll('#deductionsTable tbody tr');
    rows.forEach(row => {
        const rowDate = row.getAttribute('data-date');
        const rowYear = rowDate ? rowDate.split('-')[0] : '';
        const rowMonth = rowDate ? parseInt(rowDate.split('-')[1]) : '';
        const monthMatch = !selectedMonth || rowMonth == selectedMonth;
        const yearMatch = !selectedYear || rowYear == selectedYear;
        row.style.display = monthMatch && yearMatch ? '' : 'none';
    });
});

// ====================== فلترة جدول ملخص الرواتب ======================
document.getElementById('payrollMonthFilter')?.addEventListener('change', function() {
    const selectedMonth = this.value;
    const selectedYear = document.getElementById('payrollYearFilter').value;
    const rows = document.querySelectorAll('#payrollSummaryTable tbody tr');
    rows.forEach(row => {
        const rowMonth = row.getAttribute('data-month');
        const rowYear = row.getAttribute('data-year');
        const monthMatch = !selectedMonth || rowMonth == selectedMonth;
        const yearMatch = !selectedYear || rowYear == selectedYear;
        row.style.display = monthMatch && yearMatch ? '' : 'none';
    });
});

// ====================== فلترة جدول ملخص الرواتب ======================
document.getElementById('payrollMonthFilter')?.addEventListener('change', function() {
    const selectedMonth = this.value;
    const selectedYear = document.getElementById('payrollYearFilter').value;
    const rows = document.querySelectorAll('#payrollSummaryTable tbody tr');
    rows.forEach(row => {
        const rowMonth = row.getAttribute('data-month');
        const rowYear = row.getAttribute('data-year');
        const monthMatch = !selectedMonth || rowMonth == selectedMonth;
        const yearMatch = !selectedYear || rowYear == selectedYear;
        row.style.display = monthMatch && yearMatch ? '' : 'none';
    });
});

document.getElementById('payrollYearFilter')?.addEventListener('change', function() {
    const selectedYear = this.value;
    const selectedMonth = document.getElementById('payrollMonthFilter').value;
    const rows = document.querySelectorAll('#payrollSummaryTable tbody tr');
    rows.forEach(row => {
        const rowMonth = row.getAttribute('data-month');
        const rowYear = row.getAttribute('data-year');
        const monthMatch = !selectedMonth || rowMonth == selectedMonth;
        const yearMatch = !selectedYear || rowYear == selectedYear;
        row.style.display = monthMatch && yearMatch ? '' : 'none';
    });
});

// ✅ تفعيل القفز السلس للأقسام
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.jump-link').forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            const targetId = this.getAttribute('href');
            const targetElement = document.querySelector(targetId);
            if (targetElement) {
                window.scrollTo({
                    top: targetElement.offsetTop - 80,
                    behavior: 'smooth'
                });
            }
        });
    });
});
</script>
@endpush

@endsection
