<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <title>ملف {{ $employee->name }}</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .header { text-align: center; margin-bottom: 20px; }
        .info-section { margin-bottom: 15px; }
        .info-section h3 { border-bottom: 1px solid #ccc; padding-bottom: 3px; }
        .info-table { width: 100%; border-collapse: collapse; }
        .info-table td { border: 1px solid #ccc; padding: 5px; vertical-align: top; }
        .info-table th { background-color: #f2f2f2; border: 1px solid #ccc; padding: 5px; text-align: right; }
        .balance-row { font-weight: bold; background-color: #f9f9f9; }
        .leave-detail-row { background-color: #fafafa; }
        .leave-detail-row td { padding: 3px 5px; }
        .status-badge { padding: 2px 5px; border-radius: 3px; font-size: 0.8em; }
        .badge-success { background-color: #d4edda; color: #155724; }
        .badge-warning { background-color: #fff3cd; color: #856404; }
        .badge-danger { background-color: #f8d7da; color: #721c24; }
        .badge-info { background-color: #d1ecf1; color: #0c5460; }
        .badge-secondary { background-color: #d6d8db; color: #383d41; }
        .badge-dark { background-color: #c6c8ca; color: #1b1e21; }
        .text-danger { color: #dc3545; }
        .text-success { color: #28a745; }
        .text-warning { color: #ffc107; }
        /* أضف CSS إضافي للطباعة */
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>ملف الموظف #{{ $employee->employee_id }}</h2>
        <h3>{{ $employee->name }}</h3>
    </div>

    <div class="info-section">
        <h3>المعلومات الأساسية</h3>
        <table class="info-table">
            <tr>
                <td><strong>البريد الإلكتروني:</strong></td>
                <td>{{ $employee->email ?? 'غير محدد' }}</td>
                <td><strong>رقم الهاتف:</strong></td>
                <td>{{ $employee->phone ?? 'غير محدد' }}</td>
            </tr>
            <tr>
                <td><strong>تاريخ الميلاد:</strong></td>
                <td>{{ $employee->birth_date?->format('Y-m-d') ?? 'غير محدد' }}</td>
                <td><strong>العمر:</strong></td>
                <td>{{ $employee->age ?? 'غير محدد' }} سنة</td>
            </tr>
            <tr>
                <td><strong>الرقم الوطني:</strong></td>
                <td>{{ $employee->national_id ?? 'غير محدد' }}</td>
                <td><strong>المؤهل العلمي:</strong></td>
                <td>{{ $employee->qualification ?? 'غير محدد' }}</td>
            </tr>
            <tr>
                <td><strong>القسم:</strong></td>
                <td>{{ $employee->department?->name ?? 'غير محدد' }}</td>
                <td><strong>المنصب:</strong></td>
                <td>{{ $employee->position?->name ?? 'غير محدد' }}</td>
            </tr>
            <tr>
                <td><strong>تاريخ التوظيف:</strong></td>
                <td>{{ $employee->hire_date?->format('Y-m-d') ?? 'غير محدد' }}</td>
                <td><strong>الحالة:</strong></td>
                <td>
                    @php
                        $statusLabels = [
                            'active' => 'نشط',
                            'inactive' => 'غير نشط',
                            'pending' => 'قيد التوظيف',
                        ];
                        $statusLabel = $statusLabels[$employee->status] ?? $employee->status;
                    @endphp
                    {{ $statusLabel }}
                </td>
            </tr>
            <tr>
                <td><strong>الراتب الأساسي:</strong></td>
                    <td>{{ number_format($employee->salary ?? 0, 2) }} {{ get_currency_code() }}</td>
                <td><strong>البدلات الشهرية:</strong></td>
                <td>{{ number_format($employee->allowances ?? 0, 2) }} {{ get_currency_code() }}</td>
            </tr>
            <tr>
                <td><strong>إجمالي الراتب:</strong></td>
                    <td class="text-success"><strong>{{ number_format(($employee->salary ?? 0) + ($employee->allowances ?? 0), 2) }} {{ get_currency_code() }}</strong></td>
                <td><strong>عدد أيام الإجازة الشهرية:</strong></td>
                <td>{{ $employee->monthly_leave_days_allowed ?? 0 }} يوم</td>
            </tr>
            <tr>
                <td colspan="4"><strong>العنوان:</strong> {{ $employee->address ?? 'غير محدد' }}</td>
            </tr>
        </table>
    </div>

    <div class="info-section">
        <h3>رصيد الإجازات السنوية (الحالي)</h3>
        <table class="info-table">
            <tr class="balance-row">
                <td><strong>السنة</strong></td>
                <td><strong>الممنوحة</strong></td>
                <td><strong>المستخدمة</strong></td>
                <td><strong>المتبقية</strong></td>
            </tr>
            @php
                $currentYear = date('Y');
                $granted = $employee->getAnnualGranted($currentYear);
                $used = $employee->getAnnualUsed($currentYear);
                $remaining = $granted - $used;
                $textClass = $remaining < 0 ? 'text-danger' : ($remaining > 5 ? 'text-success' : 'text-warning');
            @endphp
            <tr class="balance-row">
                <td>{{ $currentYear }}</td>
                <td>{{ $granted }}</td>
                <td>{{ $used }}</td>
                <td class="{{ $textClass }}"><strong>{{ $remaining }}</strong></td>
            </tr>
        </table>
    </div>

    <!-- يمكنك إضافة أقسام مماثلة لعرض سجلات الإجازات، القروض، الرواتب، الحضور، الاستقطاعات -->
    <!-- مثال لقسم الإجازات -->
    @if($leaves && $leaves->count() > 0)
    <div class="info-section">
        <h3>سجل الإجازات</h3>
        <table class="info-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>النوع</th>
                    <th>من</th>
                    <th>إلى</th>
                    <th>الأيام</th>
                    <th>السبب</th>
                    <th>الحالة</th>
                </tr>
            </thead>
            <tbody>
                @foreach($leaves as $leave)
                <tr>
                    <td>{{ $leave->id }}</td>
                    <td>
                        @switch($leave->leave_type)
                            @case('annual') <span class="status-badge badge-primary">سنوية</span> @break
                            @case('sick') <span class="status-badge badge-warning">مرضية</span> @break
                            @case('emergency') <span class="status-badge badge-danger">طارئة</span> @break
                            @case('maternity') <span class="status-badge badge-pink">وضع</span> @break
                            @case('paternity') <span class="status-badge badge-info">أبوة</span> @break
                            @case('unpaid') <span class="status-badge badge-secondary">بدون راتب</span> @break
                            @default <span class="status-badge badge-dark">{{ $leave->leave_type }}</span>
                        @endswitch
                    </td>
                    <td>{{ $leave->start_date->format('Y-m-d') }}</td>
                    <td>{{ $leave->end_date->format('Y-m-d') }}</td>
                    <td>{{ $leave->days_count }}</td>
                    <td>{{ Str::limit($leave->reason, 50) }}</td>
                    <td>
                        @php
                            $statusClasses = [
                                'pending' => 'badge-warning',
                                'approved' => 'badge-success',
                                'rejected' => 'badge-danger',
                                'cancelled' => 'badge-secondary',
                            ];
                            $statusLabels = [
                                'pending' => 'معلق',
                                'approved' => 'موافق عليه',
                                'rejected' => 'مرفوض',
                                'cancelled' => 'ملغى',
                            ];
                            $badgeClass = $statusClasses[$leave->status] ?? 'badge-dark';
                            $badgeLabel = $statusLabels[$leave->status] ?? $leave->status;
                        @endphp
                        <span class="status-badge {{ $badgeClass }}">{{ $badgeLabel }}</span>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @endif

    <!-- أضف أقسام مماثلة لـ $loans, $payrolls, $attendances, $deductions -->

    <script>
        // طباعة الصفحة مباشرة عند التحميل
        window.onload = function() {
            window.print();
        };
    </script>
</body>
</html>