<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <title>طباعة سجل الرواتب - {{ $employee->name }}</title>
    <style>
        body {
            font-family: 'Tajawal', Arial, sans-serif;
            margin: 20px;
            direction: rtl;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .employee-info {
            margin-bottom: 20px;
        }
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .info-table th,
        .info-table td {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: right;
        }
        .info-table th {
            background-color: #f8f9fa;
            font-weight: 600;
        }
        .payroll-details {
            margin-top: 30px;
        }
        .payroll-details h3 {
            border-bottom: 2px solid #007bff;
            padding-bottom: 5px;
            color: #007bff;
        }
        .payroll-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        .payroll-table th,
        .payroll-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: right;
        }
        .payroll-table th {
            background-color: #e9ecef;
            font-weight: 600;
        }
        .total-row {
            font-weight: bold;
            background-color: #f8f9fa;
        }
        .no-print {
            display: none;
        }
        @media print {
            .no-print {
                display: block;
                text-align: center;
                margin: 20px 0;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>نظام إدارة الموارد البشرية نواتِك</h2>
        <h3>طباعة سجل الرواتب</h3>
    </div>

    <div class="employee-info">
        <h4>معلومات الموظف:</h4>
        <table class="info-table">
            <tr>
                <th>الاسم:</th>
                <td>{{ $employee->name }}</td>
            </tr>
            <tr>
                <th>رقم الموظف:</th>
                <td>{{ $employee->employee_id }}</td>
            </tr>
            <tr>
                <th>الوظيفة:</th>
                <td>{{ $employee->position?->name ?? 'غير محدد' }}</td>
            </tr>
            <tr>
                <th>القسم:</th>
                <td>{{ $employee->department?->name ?? 'غير محدد' }}</td>
            </tr>
            <tr>
                <th>تاريخ التعيين:</th>
                <td>{{ $employee->hire_date?->format('Y-m-d') ?? 'غير محدد' }}</td>
            </tr>
        </table>
    </div>

    <div class="payroll-details">
        <h3>سجل الرواتب</h3>
        @if($payrolls && count($payrolls) > 0)
            <table class="payroll-table">
                <thead>
                    <tr>
                        <th>الشهر</th>
                        <th>السنة</th>
                        <th>الراتب الأساسي</th>
                        <th>الحوافز</th>
                        <th>الاستقطاعات</th>
                        <th>خصم الإجازات</th>
                        <th>الراتب الصافي</th>
                        <th>حالة الدفع</th>
                        <th>تاريخ الدفع</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($payrolls as $payroll)
                        <tr>
                            <td>{{ \Carbon\Carbon::create()->month($payroll->month)->translatedFormat('F') }}</td>
                            <td>{{ $payroll->year }}</td>
                            <td>{{ $payroll->basic_salary }} {{ $currency_name }}</td>
                            <td>{{ $payroll->incentives }} {{ $currency_name }}</td>
                            <td>{{ $payroll->deductions }} {{ $currency_name }}</td>
                            <td>{{ $payroll->leave_deduction }} {{ $currency_name }}</td>
                            <td>{{ $payroll->net_salary }} {{ $currency_name }}</td>
                            <td>
                                @switch($payroll->status)
                                    @case('paid')
                                        <span class="badge bg-success">مدفوع</span>
                                        @break
                                    @case('pending')
                                        <span class="badge bg-warning">في الانتظار</span>
                                        @break
                                    @case('cancelled')
                                        <span class="badge bg-danger">ملغي</span>
                                        @break
                                    @default
                                        <span class="badge bg-secondary">{{ $payroll->status }}</span>
                                @endswitch
                            </td>
                            <td>{{ $payroll->paid_at ? $payroll->paid_at->format('Y-m-d H:i') : 'لم يُدفع بعد' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <p class="text-muted">لا توجد سجلات رواتب لهذا الموظف.</p>
        @endif
    </div>

    <!-- Footer with Print Button -->
    <div class="no-print" style="text-align:center; margin-top:30px;">
        <button onclick="window.print()">طباعة</button>
        <a href="{{ route('employees.show', $employee) }}" class="btn btn-secondary" style="margin-left:10px;">عودة إلى الملف</a>
    </div>
<!-- Footer with Print Button -->
<div style="text-align:center; margin-top:30px;">
    <button onclick="window.print()" class="btn btn-primary">طباعة</button>
    <a href="{{ route('employees.show', $employee) }}" class="btn btn-secondary" style="margin-left:10px;">عودة إلى الملف</a>
</div>
</body>
</html>