<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <title>ملخص راتب {{ $monthlyData['month_name'] }} - {{ $employee->name }}</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 20px;
            direction: rtl;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .employee-info {
            margin-bottom: 10px;
        }
        .summary-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .summary-table, .summary-table th, .summary-table td {
            border: 1px solid #000;
        }
        .summary-table th, .summary-table td {
            padding: 8px;
            text-align: center;
        }
        .summary-table th {
            background-color: #f2f2f2;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
        }
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>تقرير ملخص راتب</h2>
        <div class="employee-info">
            <p><strong>الاسم:</strong> {{ $employee->name }}</p>
            <p><strong>الرقم الوظيفي:</strong> {{ $employee->employee_id }}</p>
        </div>
    </div>

    <table class="summary-table">
        <thead>
            <tr>
                <th>الشهر</th>
                <th>الراتب الإجمالي</th>
                <th>إجمالي الاستقطاعات</th>
                <th>إجمالي أقساط القروض</th>
                <th>خصم الإجازات</th>
                <th>الراتب الصافي</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>{{ $monthlyData['month_name'] }}</td>
                <td>{{ number_format($monthlyData['gross_salary'], 2) }} {{ get_currency_code() }}</td>
                <td>{{ number_format($monthlyData['deductions_total'], 2) }} {{ get_currency_code() }}</td>
                <td>{{ number_format($monthlyData['loan_installments_total'], 2) }} {{ get_currency_code() }}</td>
                <td>{{ number_format($monthlyData['leave_deduction'], 2) }} {{ get_currency_code() }}</td>
                <td>{{ number_format($monthlyData['net_salary'], 2) }} {{ get_currency_code() }}</td>
            </tr>
        </tbody>
    </table>

    <div class="footer">
        <p>تم إنشاء التقرير في: {{ now()->format('Y-m-d H:i:s') }}</p>
        <button class="no-print" onclick="window.print();">طباعة</button>
    </div>
</body>
</html>