<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <title>طباعة سجل القروض - {{ $employee->name }}</title>
    <style>
        body {
            font-family: 'Tajawal', Arial, sans-serif;
            margin: 20px;
            direction: rtl;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .employee-info {
            margin-bottom: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: center;
        }
        th {
            background-color: #f2f2f2;
        }
        .text-center {
            text-align: center;
        }
        .text-start {
            text-align: right; /* لأن الاتجاه RTL */
        }
        .fw-bold {
            font-weight: bold;
        }
        .text-danger {
            color: #dc3545;
        }
        .text-success {
            color: #28a745;
        }
        .text-muted {
            color: #6c757d;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
        }
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>طباعة سجل القروض</h2>
        <div class="employee-info">
            <p><strong>الاسم:</strong> {{ $employee->name }}</p>
            <p><strong>الرقم الوظيفي:</strong> {{ $employee->employee_id }}</p>
            <p><strong>التاريخ:</strong> {{ now()->translatedFormat('d F Y') }}</p>
        </div>
    </div>

    @if($loans && count($loans) > 0)
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>المبلغ</th>
                    <th>نوع القرض</th>
                    <th>الفائدة</th>
                    <th>عدد الأقساط</th>
                    <th>قيمة القسط</th>
                    <th>الحالة</th>
                </tr>
            </thead>
            <tbody>
                @foreach($loans as $loan)
                    <tr>
                        <td>{{ $loan->id }}</td>
                            <td>{{ number_format($loan->amount, 2) }} {{ get_currency_code() }}</td>
                        <td>{{ $loan->loan_type ?? 'غير محدد' }}</td>
                        <td>{{ $loan->interest_rate ?? 0 }}%</td>
                        <td>{{ $loan->installment_count ?? 0 }}</td>
                            <td>{{ number_format($loan->installment_amount, 2) }} {{ get_currency_code() }}</td>
                        <td>
                            @switch($loan->status)
                                @case('pending')
                                    <span class="badge bg-warning text-dark">معلق</span>
                                    @break
                                @case('approved')
                                    <span class="badge bg-info">موافق عليه</span>
                                    @break
                                @case('active')
                                    <span class="badge bg-primary">نشط</span>
                                    @break
                                @case('paid')
                                    <span class="badge bg-success">مدفوع</span>
                                    @break
                                @default
                                    <span class="badge bg-secondary">{{ $loan->status }}</span>
                            @endswitch
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p class="text-muted text-center">لا توجد قروض مسجلة.</p>
    @endif

    <div class="footer">
        <button class="no-print" onclick="window.print();">طباعة</button>
        <a href="{{ route('employees.show', $employee) }}" class="no-print">عودة إلى الملف</a>
    </div>
</body>
</html>