<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <title>طباعة سجل الإجازات - {{ $employee->name }}</title>
    <style>
        body {
            font-family: 'Tajawal', Arial, sans-serif;
            margin: 20px;
            direction: rtl;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .employee-info {
            margin-bottom: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: center;
        }
        th {
            background-color: #f2f2f2;
        }
        .text-center {
            text-align: center;
        }
        .text-start {
            text-align: right; /* لأن الاتجاه RTL */
        }
        .fw-bold {
            font-weight: bold;
        }
        .text-danger {
            color: #dc3545;
        }
        .text-success {
            color: #28a745;
        }
        .text-muted {
            color: #6c757d;
        }
        @media print {
            body {
                margin: 0;
            }
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>طباعة سجل الإجازات</h2>
        <div class="employee-info">
            <p><strong>الاسم:</strong> {{ $employee->name }}</p>
            <p><strong>الرقم الوظيفي:</strong> {{ $employee->employee_id }}</p>
            <p><strong>التاريخ:</strong> {{ now()->translatedFormat('d F Y') }}</p>
        </div>
    </div>

    @if($leaves && count($leaves) > 0)
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>نوع الإجازة</th>
                    <th>من</th>
                    <th>إلى</th>
                    <th>الأيام</th>
                    <th>السبب</th>
                    <th>الحالة</th>
                </tr>
            </thead>
            <tbody>
                @foreach($leaves as $leave)
                    <tr>
                        <td>{{ $leave->id }}</td>
                        <td>
                            @php
                                $leaveTypes = [
                                    'annual' => 'إجازة سنوية',
                                    'sick' => 'إجازة مرضية',
                                    'emergency' => 'إجازة طارئة',
                                    'maternity' => 'إجازة وضع',
                                    'paternity' => 'إجازة أبوة',
                                    'unpaid' => 'إجازة بدون راتب',
                                ];
                            @endphp
                            {{ $leaveTypes[$leave->leave_type] ?? $leave->leave_type }}
                        </td>
                        <td>{{ $leave->start_date->format('Y-m-d') }}</td>
                        <td>{{ $leave->end_date->format('Y-m-d') }}</td>
                        <td>{{ $leave->days_count }}</td>
                        <td>{{ Str::limit($leave->reason, 30) }}</td>
                        <td>
                            @php
                                $statusLabels = [
                                    'pending' => 'معلق',
                                    'approved' => 'موافق عليه',
                                    'rejected' => 'مرفوض',
                                    'cancelled' => 'ملغى',
                                ];
                            @endphp
                            <span class="badge bg-dark text-white">{{ $statusLabels[$leave->status] ?? $leave->status }}</span>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p class="text-muted text-center">لا توجد إجازات مسجلة.</p>
    @endif

    <div class="text-center mt-4 no-print">
        <button onclick="window.print();" class="btn btn-primary">طباعة</button>
        <a href="{{ route('employees.show', $employee) }}" class="btn btn-secondary">عودة إلى الملف</a>
    </div>
</body>
</html>