<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <title>طباعة تراكم الإجازات - {{ $employee->name }}</title>
    <style>
        body {
            font-family: 'Tajawal', Arial, sans-serif;
            margin: 20px;
            direction: rtl;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .employee-info {
            margin-bottom: 20px;
        }
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .info-table th,
        .info-table td {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: right;
        }
        .info-table th {
            background-color: #f8f9fa;
            font-weight: 600;
        }
        .monthly-details {
            margin-top: 30px;
        }
        .monthly-details h3 {
            border-bottom: 2px solid #007bff;
            padding-bottom: 5px;
            color: #007bff;
        }
        .monthly-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        .monthly-table th,
        .monthly-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: right;
        }
        .monthly-table th {
            background-color: #e9ecef;
            font-weight: 600;
        }
        .total-row {
            font-weight: bold;
            background-color: #f8f9fa;
        }
        .no-print {
            display: none;
        }
        @media print {
            body {
                margin: 0;
            }
            .no-print {
                display: block;
                text-align: center;
                margin: 20px 0;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>نظام إدارة الموارد البشرية نواتِك</h2>
        <h3>طباعة تراكم الإجازات</h3>
    </div>

    <div class="employee-info">
        <h4>معلومات الموظف:</h4>
        <table class="info-table">
            <tr>
                <th>الاسم:</th>
                <td>{{ $employee->name }}</td>
            </tr>
            <tr>
                <th>رقم الموظف:</th>
                <td>{{ $employee->employee_id }}</td>
            </tr>
            <tr>
                <th>الوظيفة:</th>
                <td>{{ $employee->position?->name ?? 'غير محدد' }}</td>
            </tr>
            <tr>
                <th>القسم:</th>
                <td>{{ $employee->department?->name ?? 'غير محدد' }}</td>
            </tr>
            <tr>
                <th>تاريخ التعيين:</th>
                <td>{{ $employee->hire_date?->format('Y-m-d') ?? 'غير محدد' }}</td>
            </tr>
        </table>
    </div>

    <div class="monthly-details">
        <h3>تفاصيل تراكم الإجازات الشهرية</h3>
        @if($leaveMonthlyDetails && count($leaveMonthlyDetails) > 0)
            <table class="monthly-table">
                <thead>
                    <tr>
                        <th>الشهر</th>
                        <th>السنة</th>
                        <th>الرصيد السابق</th>
                        <th>الممنوح</th>
                        <th>المستخدم</th>
                        <th>الرصيد الحالي</th>
                        <th>ملاحظات</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($leaveMonthlyDetails as $detail)
                        <tr>
                            <td>{{ \Carbon\Carbon::create()->month($detail['month'])->translatedFormat('F') }}</td>
                            <td>{{ $detail['year'] }}</td>
                            <td>{{ $detail['balance_before'] }} يوم</td>
                            <td>{{ $detail['granted_this_month'] }} يوم</td>
                            <td>{{ $detail['used_this_month'] }} يوم</td>
                            <td>{{ $detail['balance_after'] }} يوم</td>
                            <td>{{ $detail['notes'] ?? '-' }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr class="total-row">
                        <td colspan="2">الإجمالي</td>
                        <td>{{ $leaveMonthlyDetails->sum('balance_before') }} يوم</td>
                        <td>{{ $leaveMonthlyDetails->sum('granted_this_month') }} يوم</td>
                        <td>{{ $leaveMonthlyDetails->sum('used_this_month') }} يوم</td>
                        <td>{{ $leaveMonthlyDetails->sum('balance_after') }} يوم</td>
                        <td>-</td>
                    </tr>
                </tfoot>
            </table>
        @else
            <p class="text-muted">لا توجد بيانات لتراكم الإجازات لهذا الموظف.</p>
        @endif
    </div>

    <!-- Footer with Print Button -->
<div style="text-align:center; margin-top:30px;">
    <button onclick="window.print()" class="btn btn-primary">طباعة</button>
    <a href="{{ route('employees.show', $employee) }}" class="btn btn-secondary" style="margin-left:10px;">عودة إلى الملف</a>
</div>
</body>
</html>