{{-- resources/views/employees/print-deductions.blade.php --}}
<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <title>طباعة سجل الاستقطاعات - {{ $employee->name }}</title>
    <style>
        body {
            font-family: 'Tajawal', Arial, sans-serif;
            margin: 20px;
            direction: rtl;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .employee-info {
            margin-bottom: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: center;
        }
        th {
            background-color: #f2f2f2;
        }
        .text-center {
            text-align: center;
        }
        .text-start {
            text-align: right; /* لأن الاتجاه RTL */
        }
        .fw-bold {
            font-weight: bold;
        }
        .text-danger {
            color: #dc3545;
        }
        .text-success {
            color: #28a745;
        }
        .text-muted {
            color: #6c757d;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
        }
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>{{ __('deductions.print_heading') }}</h2>
        <div class="employee-info">
            <p><strong>{{ __('deductions.employee_name') }}:</strong> {{ $employee->name }}</p>
            <p><strong>{{ __('deductions.employee_employee_id') }}:</strong> {{ $employee->employee_id }}</p>
            <p><strong>{{ __('deductions.table.date') }}:</strong> {{ now()->translatedFormat('d F Y') }}</p>
        </div>
    </div>

    @if($deductions && count($deductions) > 0)
        <table>
            <thead>
                <tr>
                    <th>{{ __('deductions.table.id') }}</th>
                    <th>{{ __('deductions.table.type') }}</th>
                    <th>{{ __('deductions.table.description') }}</th>
                    <th>{{ __('deductions.table.amount') }}</th>
                    <th>{{ __('deductions.table.date') }}</th>
                    <th>{{ __('deductions.table.status') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($deductions as $deduction)
                    <tr>
                        <td>{{ $deduction->id }}</td>
                        <td>
                            {{ __('deductions.types.' . $deduction->type, [], null) ?: ($deduction->type ?? '') }}
                        </td>
                        <td>{{ Str::limit($deduction->description, 30) }}</td>
                        <td>{{ number_format($deduction->amount, 2) }} {{ get_currency_code() }}</td>
                        <td>{{ $deduction->deduction_date->format('Y-m-d') }}</td>
                        <td>
                            @php $s = $deduction->status; @endphp
                            @if($s === 'applied')
                                <span class="badge bg-success">{{ __('deductions.status.applied') }}</span>
                            @elseif($s === 'pending')
                                <span class="badge bg-warning text-dark">{{ __('deductions.status.pending') }}</span>
                            @elseif($s === 'cancelled')
                                <span class="badge bg-secondary">{{ __('deductions.status.cancelled') }}</span>
                            @else
                                <span class="badge bg-dark">{{ $deduction->status }}</span>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p class="text-muted text-center">لا توجد استقطاعات مسجلة.</p>
    @endif

    <div class="footer">
        <button class="no-print" onclick="window.print();">طباعة</button>
        <a href="{{ route('employees.show', $employee) }}" class="no-print">عودة إلى الملف</a>
    </div>
</body>
</html>