<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <title>طباعة سجل الحضور - {{ $employee->name }}</title>
    <style>
        body {
            font-family: 'Tajawal', Arial, sans-serif;
            margin: 20px;
            direction: rtl;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .employee-info {
            margin-bottom: 20px;
        }
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .info-table th,
        .info-table td {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: right;
        }
        .info-table th {
            background-color: #f8f9fa;
            font-weight: 600;
        }
        .attendance-details {
            margin-top: 30px;
        }
        .attendance-details h3 {
            border-bottom: 2px solid #007bff;
            padding-bottom: 5px;
            color: #007bff;
        }
        .attendance-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        .attendance-table th,
        .attendance-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: right;
        }
        .attendance-table th {
            background-color: #e9ecef;
            font-weight: 600;
        }
        .total-row {
            font-weight: bold;
            background-color: #f8f9fa;
        }
        .no-print {
            display: none;
        }
        @media print {
            .no-print {
                display: block;
                text-align: center;
                margin: 20px 0;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>نظام إدارة الموارد البشرية نواتِك</h2>
        <h3>طباعة سجل الحضور</h3>
    </div>

    <div class="employee-info">
        <h4>معلومات الموظف:</h4>
        <table class="info-table">
            <tr>
                <th>الاسم:</th>
                <td>{{ $employee->name }}</td>
            </tr>
            <tr>
                <th>رقم الموظف:</th>
                <td>{{ $employee->employee_id }}</td>
            </tr>
            <tr>
                <th>الوظيفة:</th>
                <td>{{ $employee->position?->name ?? 'غير محدد' }}</td>
            </tr>
            <tr>
                <th>القسم:</th>
                <td>{{ $employee->department?->name ?? 'غير محدد' }}</td>
            </tr>
            <tr>
                <th>تاريخ التعيين:</th>
                <td>{{ $employee->hire_date?->format('Y-m-d') ?? 'غير محدد' }}</td>
            </tr>
        </table>
    </div>

    <div class="attendance-details">
        <h3>سجل الحضور</h3>
        @if($attendances && count($attendances) > 0)
            <table class="attendance-table">
                <thead>
                    <tr>
                        <th>التاريخ</th>
                        <th>وقت الحضور</th>
                        <th>وقت الانصراف</th>
                        <th>مدة العمل</th>
                        <th>الحالة</th>
                        <th>ملاحظات</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($attendances as $attendance)
                        <tr>
                            <td>{{ $attendance->date->format('Y-m-d') }}</td>
                            <td>{{ $attendance->check_in ?? 'لم يسجل' }}</td>
                            <td>{{ $attendance->check_out ?? 'لم يسجل' }}</td>
                            <td>{{ $attendance->work_duration ?? 'غير محسوبة' }}</td>
                            <td>
                                @switch($attendance->status)
                                    @case('present')
                                        <span class="badge bg-success">حاضر</span>
                                        @break
                                    @case('late')
                                        <span class="badge bg-warning">متأخر</span>
                                        @break
                                    @case('absent')
                                        <span class="badge bg-danger">غائب</span>
                                        @break
                                    @case('leave')
                                        <span class="badge bg-info">إجازة</span>
                                        @break
                                    @default
                                        <span class="badge bg-secondary">{{ $attendance->status }}</span>
                                @endswitch
                            </td>
                            <td>{{ $attendance->notes ?? '-' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <p class="text-muted">لا توجد سجلات حضور لهذا الموظف.</p>
        @endif
    </div>

    <div class="no-print" style="text-align:center; margin-top:30px;">
        <button onclick="window.print()">طباعة</button>
        <a href="{{ route('employees.show', $employee) }}" class="btn btn-secondary" style="margin-left:10px;">عودة إلى الملف</a>
    </div>
<!-- Footer with Print Button -->
<div style="text-align:center; margin-top:30px;">
    <button onclick="window.print()" class="btn btn-primary">طباعة</button>
    <a href="{{ route('employees.show', $employee) }}" class="btn btn-secondary" style="margin-left:10px;">عودة إلى الملف</a>
</div>
</body>
</html>