<!-- Add Position Modal -->
<div class="modal fade" id="addPositionModal" tabindex="-1" role="dialog" aria-labelledby="addPositionModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addPositionModalLabel">إضافة منصب جديد</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="إغلاق">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="addPositionForm" method="POST" action="{{ route('positions.store') }}">
                @csrf
                <div class="modal-body">
                    <!-- اسم المنصب -->
                    <div class="form-group">
                        <label for="position_name">اسم المنصب <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="position_name" name="name" required>
                    </div>

                    <!-- اختيار القسم -->
                    <div class="form-group">
                        <label for="position_department_id">القسم التابع له <span class="text-danger">*</span></label>
                        <select class="form-control" id="position_department_id" name="department_id" required>
                            <option value="">اختر القسم</option>
                            @foreach($departments as $department)
                                <option value="{{ $department->id }}">{{ $department->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- الوصف -->
                    <div class="form-group">
                        <label for="position_description">الوصف</label>
                        <textarea class="form-control" id="position_description" name="description" rows="3"></textarea>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>
