{{--
|--------------------------------------------------------------------------
| ملف عرض قائمة الموظفين (employees.index)
|--------------------------------------------------------------------------
|
| يعرض هذا الملف جدولاً لجميع الموظفين مع إحصائيات علوية وخيارات تصفية متقدمة.
| تم تحديثه ليعكس التغييرات في الموديل، خاصة حقل 'incentives' بدلاً من 'allowances'.
|
| التعديلات الرئيسية:
| 1. إظهار 'البدلات/الحوافز (incentives)' بدلاً من 'العلاوات (allowances)'.
| 2. إضافة زر الإضافة 'إضافة موظف جديد' تحت حماية الصلاحيات.
| 3. تحديث منطق الفلترة (JavaScript) في الأسفل ليعمل بشكل صحيح.
| 4. تضمين جميع العناصر المطلوبة مثل الترقيم والإحصائيات.
|
--}}
@extends('layouts.app')

@section('title', __('app.employees'))

@section('content')
<div class="container-fluid">
    <!--====================================
    |           شريط العنوان والمسار
    ====================================-->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('app.employees') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('app.home') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('app.employees') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    
    <!-- مسافة فاصلة إضافية -->
    <div class="mb-4"></div>

    <!--====================================
    |           بطاقات الإحصائيات
    ====================================-->
    <div class="row">
        <!-- الموظفون غير النشطين (المغادرون) -->
        <div class="col-xl-3 col-md-6">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('employees.stats.inactive_title') }}</p>
                            <h4 class="mb-0">{{ $inactiveEmployees ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-user-times fa-2x"></i>
                            </span>
                        </div>
                    </div>
                    <div class="mt-3">
                         <p class="text-white-50 mb-0 font-size-12">{{ __('employees.stats.inactive_subtitle') }}</p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- الموظفون النشطون -->
        <div class="col-xl-3 col-md-6">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('employees.stats.active_title') }}</p>
                            <h4 class="mb-0">{{ $activeEmployees ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-user-check fa-2x"></i>
                            </span>
                        </div>
                    </div>
                    <div class="mt-3">
                         <p class="text-white-50 mb-0 font-size-12">{{ __('employees.stats.active_subtitle') }}</p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- الموظفون المعلقون -->
        <div class="col-xl-3 col-md-6">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('employees.stats.pending_title') }}</p>
                            <h4 class="mb-0">{{ $pendingEmployees ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-user-clock fa-2x"></i>
                            </span>
                        </div>
                    </div>
                    <div class="mt-3">
                         <p class="text-white-50 mb-0 font-size-12">{{ __('employees.stats.pending_subtitle') }}</p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- إجمالي الموظفين -->
        <div class="col-xl-3 col-md-6">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('employees.stats.total_title') }}</p>
                            <h4 class="mb-0">{{ $totalEmployees ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-users fa-2x"></i>
                            </span>
                        </div>
                    </div>
                    <div class="mt-3">
                         <p class="text-white-50 mb-0 font-size-12">{{ __('employees.stats.total_subtitle') }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- مسافة فاصلة إضافية -->
    <div class="mb-4"></div>

    <!--====================================
    |           جدول قائمة الموظفين
    ====================================-->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="card-title">{{ __('app.employees_list') }}</h4>
                        
                        {{-- ⭐ زر إضافة موظف جديد ⭐ --}}
                        @can('create', App\Models\Employee::class)
                        <a href="{{ route('employees.create') }}" class="btn btn-primary waves-effect waves-light">
                            <i class="fas fa-plus-circle align-middle mr-2"></i> {{ __('app.add') }} {{ __('app.employee') }}
                        </a>
                        @endcan
                        {{-- ⭐ نهاية زر الإضافة ⭐ --}}
                    </div>

                    <!-- منطقة الفلاتر والبحث (Server-Side) -->
                    <form method="GET" action="{{ route('employees.index') }}" class="row mb-4 p-3 border rounded shadow-sm bg-light" id="searchForm">
                        <div class="col-lg-4 col-md-6 mb-2">
                            <label for="searchInput" class="form-label font-size-12">{{ __('employees.filters.quick_search_label') }}</label>
                            <input type="text" id="searchInput" name="search" class="form-control" placeholder="{{ __('employees.filters.search_placeholder') }}" value="{{ request('search') }}">
                        </div>
                        <div class="col-lg-2 col-md-6 mb-2">
                            <label for="departmentFilter" class="form-label font-size-12">{{ __('employees.filters.department_label') }}</label>
                            <select id="departmentFilter" name="department_id" class="form-control">
                                <option value="">{{ __('employees.filters.department_all') }}</option>
                                @foreach($departments as $dept)
                                <option value="{{ $dept->id }}" {{ request('department_id') == $dept->id ? 'selected' : '' }}>{{ $dept->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-lg-2 col-md-6 mb-2">
                            <label for="statusFilter" class="form-label font-size-12">{{ __('employees.filters.status_label') }}</label>
                            <select id="statusFilter" name="status" class="form-control">
                                <option value="">{{ __('employees.filters.status_all') }}</option>
                                <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>{{ __('app.status.active') }}</option>
                                <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>{{ __('app.status.inactive') }}</option>
                                <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>{{ __('app.status.pending') }}</option>
                            </select>
                        </div>
                        <div class="col-lg-2 col-md-6 mb-2 d-flex align-items-end gap-2">
                            <button type="submit" class="btn btn-primary w-100" title="بحث"><i class="fas fa-search"></i> {{ __('app.search') ?? 'بحث' }}</button>
                            <a href="{{ route('employees.index') }}" class="btn btn-secondary" title="{{ __('employees.filters.reset_title') }}"><i class="fas fa-sync-alt"></i> {{ __('employees.filters.reset_button') }}</a>
                        </div>
                    </form>

                    <!-- مسافة فاصلة -->
                    <div class="mb-3"></div>

                    <!-- جدول الموظفين الفعلي -->
                                    <style>
                                        /* Force all table header/cell text and descendants to black for readability */
                                        #employeesTable th,
                                        #employeesTable td,
                                        #employeesTable td * {
                                            color: #000 !important;
                                        }
                                        /* Ensure links and badges inside the table are also black */
                                        #employeesTable a,
                                        #employeesTable .badge {
                                            color: #000 !important;
                                        }
                                    </style>
                                    <div class="table-responsive">
                        <table id="employeesTable" class="table table-centered table-nowrap table-hover mb-0">
                            <thead class="bg-light">
                                <tr>
                                    <th style="width: 50px;">{{ __('employees.table.photo') }}</th>
                                    <th>{{ __('employees.table.name') }}</th>
                                    <th>{{ __('employees.table.email') }}</th>
                                    <th>{{ __('employees.table.department') }}</th>
                                    <th>{{ __('employees.table.salary', ['currency' => $currency_name]) }}</th>
                                    {{-- ✅ الحقل المُعدّل: البدلات/الحوافز --}}
                                    <th>{{ __('employees.table.incentives', ['currency' => $currency_name]) }}</th>
                                    <th>{{ __('app.additional_components_total') }}</th>
                                    <th>{{ __('app.overtime_hourly_rate_label') }}</th>
                                    <th>{{ __('app.leave_accrual_label') }}</th>
                                    <th>{{ __('app.missing_hours_deduction_label') }}</th>
                                    <th>{{ __('app.overtime_hours_12m_label') }}</th>
                                    <th>{{ __('app.overtime_status_label') }}</th>
                                    <th>{{ __('app.overtime_pay_12m_label') }}</th>
                                    <th>{{ __('employees.table.status') }}</th>
                                    <th>{{ __('employees.table.position') }}</th>
                                    <th style="width: 120px;">{{ __('employees.table.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($employees as $employee)
                                <tr>
                                    {{-- عمود الصورة --}}
                                    <td>
                                        <div class="avatar-xs">
                                            {{-- استخدام مسار التخزين العام --}}
                                            <img src="{{ asset('storage/' . $employee->photo) }}" onerror="this.onerror=null;this.src='{{ asset('images/default-user.png') }}';" alt="{{ $employee->name }}" class="img-thumbnail rounded-circle">
                                        </div>
                                    </td>
                                    
                                    {{-- عمود الاسم --}}
                                    <td>
                                        <h5 class="font-size-14 mb-1"><a href="{{ route('employees.show', $employee) }}" class="text-dark">{{ $employee->name }}</a></h5>
                                        <p class="text-muted mb-0 font-size-12">#{{ $employee->employee_id }}</p>
                                    </td>
                                    
                                    {{-- عمود البريد الإلكتروني --}}
                                    <td>{{ $employee->email }}</td>
                                    
                                    {{-- عمود القسم (للفلترة) --}}
                                    <td data-department="{{ $employee->department->name ?? __('employees.table.not_specified') }}">{{ $employee->department->name ?? __('employees.table.not_specified') }}</td>
                                    
                                    {{-- عمود الراتب الأساسي --}}
                                    <td>{{ number_format($employee->salary ?? 0, 2) }}</td>
                                    
                                    {{-- ✅ عمود البدلات/الحوافز (المُعدّل) --}}
                                    <td>{{ number_format($employee->incentives ?? 0, 2) }}</td>
                                    <td>
                                        @php
                                            // relational components total (pivot value)
                                            try {
                                                if ($employee->relationLoaded('salaryComponents')) {
                                                    $relComponents = $employee->salaryComponents->sum(fn($c) => (float) ($c->pivot->value ?? 0));
                                                } else {
                                                    $relComponents = $employee->salaryComponents()->sum('employee_salary_components.value');
                                                }
                                            } catch (\Throwable $e) {
                                                $relComponents = 0;
                                            }
                                            // named components (component_1..component_7)
                                            $namedComponents = 0;
                                            for ($i = 1; $i <= 7; $i++) {
                                                $namedComponents += (float) ($employee->{"component_$i"} ?? 0);
                                            }
                                            $additionalTotal = $relComponents + $namedComponents;
                                        @endphp
                                        {{ number_format($additionalTotal ?? 0, 2) }}
                                    </td>
                                    <td>{{ number_format($employee->overtime_hourly_rate ?? 0, 2) }}</td>
                                    <td>
                                        @if($employee->accrue_leaves)
                                            <span class="badge badge-success">{{ __('app.enabled') }}</span>
                                        @else
                                            <span class="badge badge-secondary">{{ __('app.disabled') }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        {{-- Deduct missing hours flag/status --}}
                                        @if(isset($employee->deduct_if_underworked) && $employee->deduct_if_underworked)
                                            <span class="badge badge-danger">{{ __('app.deduct_missing_hours_enabled') ?? 'خصم الساعات' }}</span>
                                            @if(isset($employee->missing_hours_deduction_amount))
                                                <div class="text-muted small">{{ number_format($employee->missing_hours_deduction_amount,2) }}</div>
                                            @endif
                                        @else
                                            <span class="badge badge-secondary">{{ __('app.deduct_missing_hours_disabled') ?? 'لا يخصم' }}</span>
                                        @endif
                                    </td>
                                    <td>{{ number_format($employee->overtime_hours_last_12m ?? 0, 2) }}</td>
                                    <td>
                                        {{-- Overtime paid flag/status --}}
                                        @if(isset($employee->overtime_paid) && $employee->overtime_paid)
                                            <span class="badge badge-success">{{ __('app.overtime_paid') ?? 'يتم دفع الأوفرتايم' }}</span>
                                        @else
                                            <span class="badge badge-secondary">{{ __('app.overtime_not_paid') ?? 'غير مدفوع' }}</span>
                                        @endif
                                    </td>
                                    <td>{{ number_format($employee->overtime_pay_last_12m ?? 0, 2) }}</td>
                                    
                                    {{-- عمود الحالة (للفلترة) --}}
                                    <td>
                                        @php
                                            $statusClass = '';
                                            $statusText = '';
                                            $statusKey = $employee->status;
                                            switch ($employee->status) {
                                                case 'active':
                                                    $statusClass = 'badge-soft-success';
                                                    $statusText = __('app.status.active');
                                                    break;
                                                case 'inactive':
                                                    $statusClass = 'badge-soft-danger';
                                                    $statusText = __('app.status.inactive');
                                                    break;
                                                case 'pending':
                                                    $statusClass = 'badge-soft-warning';
                                                    $statusText = __('app.status.pending');
                                                    break;
                                                default:
                                                    $statusClass = 'badge-soft-secondary';
                                                    $statusText = __('employees.status_unknown');
                                                    $statusKey = 'unknown';
                                                    break;
                                            }
                                        @endphp
                                        <span class="badge {{ $statusClass }} font-size-12" data-status="{{ $statusText }}" data-status-key="{{ $statusKey }}">{{ $statusText }}</span>
                                    </td>
                                    
                                    {{-- عمود الوظيفة (للفلترة) --}}
                                    <td data-position="{{ position_label($employee->position) ?? __('employees.table.not_specified') }}">{{ position_label($employee->position) ?? __('employees.table.not_specified') }}</td>
                                    
                                    {{-- عمود الإجراءات --}}
                                    <td>
                                        <ul class="list-inline mb-0">
                                            {{-- عرض التفاصيل --}}
                                            <li class="list-inline-item">
                                                <a href="{{ route('employees.show', $employee) }}" class="px-2 text-primary" data-toggle="tooltip" data-placement="top" title="{{ __('employees.table.actions_view') }}"><i class="fas fa-eye font-size-18"></i></a>
                                            </li>
                                            
                                            @can('update', $employee)
                                            {{-- تعديل --}}
                                            <li class="list-inline-item">
                                                <a href="{{ route('employees.edit', $employee) }}" class="px-2 text-success" data-toggle="tooltip" data-placement="top" title="{{ __('employees.table.actions_edit') }}"><i class="fas fa-pencil-alt font-size-18"></i></a>
                                            </li>
                                            @endcan
                                            {{-- تقويم / حضور --}}
                                            <li class="list-inline-item">
                                                <a href="{{ route('employees.calendar', $employee) }}" class="px-2 text-info" data-toggle="tooltip" data-placement="top" title="تقويم الحضور"><i class="fas fa-calendar-alt font-size-18"></i></a>
                                            </li>
                                            
                                            @can('delete', $employee)
                                            {{-- حذف --}}
                                            <li class="list-inline-item">
                                                <form action="{{ route('employees.destroy', $employee) }}" method="POST" onsubmit="return confirm('{{ __('employees.messages.delete_confirm') }}');" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="p-0 border-0 bg-transparent text-danger" data-toggle="tooltip" data-placement="top" title="{{ __('employees.table.actions_delete') }}"><i class="fas fa-trash-alt font-size-18"></i></button>
                                                </form>
                                            </li>
                                            @endcan
                                        </ul>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="15" class="text-center py-4">
                                        <i class="fas fa-exclamation-circle fa-2x text-warning mb-2"></i>
                                        <p class="mb-0">{{ __('app.no_employees') }}</p>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- مسافة فاصلة -->
                    <div class="mb-3"></div>

                    <!-- الترقيم (Pagination) -->
                    <div class="row">
                        <div class="col-12">
                            <div class="d-flex justify-content-center justify-content-md-end mt-3">
                                {{ $employees->links() }}
                            </div>
                        </div>
                    </div>
                    
                    <!-- مسافة فاصلة نهائية -->
                    <div class="mb-5"></div>

                </div>
            </div>
        </div>
    </div>
    
    <!-- مسافة فاصلة نهائية -->
    <div class="mb-5"></div>

</div>
@endsection

@section('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // تفعيل الـ tooltips
    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-toggle="tooltip"]'));
    tooltipTriggerList.map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
});
</script>
@endsection