@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('app.add') }} {{ __('app.employee') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('app.home') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('employees.index') }}">{{ __('app.employees') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('app.add') }} {{ __('app.employee') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    {{-- رسائل النجاح --}}
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">{{ __('app.add_employee_form') }}</h4>

                    {{-- أخطاء التحقق --}}
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('employees.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <!-- رقم الموظف (يُولد تلقائيًا) -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="employee_id" class="form-label">{{ __('app.employee_id') }}</label>
                                <input type="text"
                                       class="form-control bg-light"
                                       id="employee_id"
                                       name="employee_id"
                                       value="{{ old('employee_id') }}"
                                       readonly
                                       placeholder="{{ __('app.auto_generated') }}">
                                <small class="text-muted">{{ __('app.example') }}: EMP20250001</small>
                            </div>

                            <!-- الاسم الكامل -->
                            <div class="col-md-6 mb-3">
                                <label for="name" class="form-label">{{ __('app.full_name') }} <span class="text-danger">*</span></label>
                                <input type="text"
                                       name="name"
                                       id="name"
                                       class="form-control"
                                       value="{{ old('name') }}"
                                       required>
                            </div>
                        </div>

                        <!-- البريد الإلكتروني ورقم الهاتف -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="email" class="form-label">{{ __('app.email') }}</label>
                                <input type="email"
                                       name="email"
                                       id="email"
                                       class="form-control"
                                       value="{{ old('email') }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="phone" class="form-label">{{ __('app.phone') }}</label>
                                <input type="text"
                                       name="phone"
                                       id="phone"
                                       class="form-control"
                                       value="{{ old('phone') }}">
                            </div>
                        </div>

                        <!-- ربط حساب المستخدم -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="user_id" class="form-label">ربط حساب المستخدم (اختياري)</label>
                                <select class="form-select select2" id="user_id" name="user_id">
                                    <option value="">-- لا يوجد حساب مرتبط --</option>
                                    @php
                                        $users = \App\Models\User::orderBy('name')->get();
                                    @endphp
                                    @foreach($users as $user)
                                        <option value="{{ $user->id }}" {{ old('user_id') == $user->id ? 'selected' : '' }}>
                                            {{ $user->name }} ({{ $user->email }})
                                        </option>
                                    @endforeach
                                </select>
                                <small class="text-muted">اختر حساب مستخدم لربطه بهذا الموظف. يمكّن الموظف من تسجيل الدخول والوصول لطلباته.</small>
                                @error('user_id')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- القسم والمنصب -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="department_id" class="form-label">{{ __('app.department') }}</label>
                                <div class="input-group">
                                    <select name="department_id" id="department_id" class="form-control" required>
                                        <option value="">{{ __('app.select_department') }}</option>
                                        @foreach($departments as $department)
                                            <option value="{{ $department->id }}"
                                                    {{ old('department_id') == $department->id ? 'selected' : '' }}>
                                                {{ $department->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <button class="btn btn-outline-secondary" type="button"
                                            data-bs-toggle="modal"
                                            data-bs-target="#addDepartmentModal">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>
                                @error('department_id')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="position_id" class="form-label">{{ __('app.position') }}</label>
                                <div class="input-group">
                                    <select name="position_id" id="position_id" class="form-control" required>
                                        <option value="">{{ __('app.select_position') }}</option>
                                        @foreach($positions as $position)
                                            <option value="{{ $position->id }}"
                                                    {{ old('position_id') == $position->id ? 'selected' : '' }}>
                                                {{ $position->name }}
                                                @if($position->department)
                                                    ({{ $position->department->name }})
                                                @endif
                                            </option>
                                        @endforeach
                                    </select>
                                    <button class="btn btn-outline-secondary" type="button"
                                            data-bs-toggle="modal"
                                            data-bs-target="#addPositionModal">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>
                                @error('position_id')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- تاريخ التوظيف والراتب الأساسي -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="hire_date" class="form-label">{{ __('app.hire_date') }}</label>
                                <input type="date"
                                       name="hire_date"
                                       id="hire_date"
                                       class="form-control"
                                       value="{{ old('hire_date') }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="salary" class="form-label">{{ __('app.basic_salary') }} <span class="text-danger">*</span></label>
                                <input type="number"
                                       step="0.01"
                                       name="salary"
                                       id="salary"
                                       class="form-control"
                                       value="{{ old('salary', '0.00') }}"
                                       required>
                                <small class="text-muted">{{ __('app.example') }}: 1500.00 {{ $currency_name }}</small>
                            </div>
                        </div>

                        <!-- الحوافز -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="incentives" class="form-label">{{ __('app.incentives') }} ({{ __('app.optional') }})</label>
                                <input type="number"
                                       step="0.01"
                                       name="incentives"
                                       id="incentives"
                                       class="form-control"
                                       value="{{ old('incentives', '0.00') }}">
                                <small class="text-muted">{{ __('app.example') }}: حوافز إنتاجية، أداء، مبيعات (بالعملة: {{ $currency_name }})</small>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="default_paid_off_amount" class="form-label">قيمة اليوم الحضور المدفوع (افتراضي)</label>
                                <input type="number"
                                       step="0.01"
                                       name="default_paid_off_amount"
                                       id="default_paid_off_amount"
                                       class="form-control"
                                       value="{{ old('default_paid_off_amount', $defaultPaidOffAmount ?? '0.00') }}">
                                <small class="text-muted">قيمة مالية مفترضة ليوم الحضور الذي وقع في عطلة أسبوعية/رسمية. تملأ تلقائياً أثناء إنشاء الرواتب.</small>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="overtime_hourly_rate" class="form-label">{{ __('app.overtime_hourly_rate') ?? 'سعر ساعة العمل الإضافي' }}</label>
                                <input type="number"
                                       step="0.01"
                                       name="overtime_hourly_rate"
                                       id="overtime_hourly_rate"
                                       class="form-control"
                                       value="{{ old('overtime_hourly_rate', '0.00') }}">
                                <small class="text-muted">{{ __('app.example') }}: 5.00 {{ $currency_name }}</small>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="deduction_hourly_rate" class="form-label">{{ __('app.deduction_hourly_rate') ?? 'ساعة خصم النقص' }}</label>
                                <input type="number"
                                       step="0.01"
                                       name="deduction_hourly_rate"
                                       id="deduction_hourly_rate"
                                       class="form-control"
                                       value="{{ old('deduction_hourly_rate', '0.00') }}">
                                <small class="text-muted">{{ __('app.example') }}: 5.00 {{ $currency_name }} - المبلغ الذي يخصم من الموظف عن كل ساعة نقص</small>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="total_salary_display" class="form-label">{{ __('app.total_salary') }} ({{ __('app.estimated') }})</label>
                                <input type="text"
                                       id="total_salary_display"
                                       class="form-control"
                                       readonly
                                       placeholder="{{ __('app.will_be_calculated') }}">
                                <small class="text-muted">{{ __('app.salary_components') }} (بالعملة: {{ $currency_name }})</small>
                            </div>
                        </div>

                        <!-- عدد أيام الإجازة الشهرية المجانية -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="monthly_leave_days_allowed" class="form-label">{{ __('app.monthly_free_leave_days') }}</label>
                                <input type="number"
                                       name="monthly_leave_days_allowed"
                                       id="monthly_leave_days_allowed"
                                       class="form-control"
                                       value="{{ old('monthly_leave_days_allowed') }}"
                                       min="0" max="30" required>
                                @error('monthly_leave_days_allowed')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                                <small class="text-muted">{{ __('app.free_days_info') }}</small>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="annual_entitlement" class="form-label">{{ __('app.annual_entitlement') ?? 'الرصيد السنوي' }}</label>
                                <input type="number"
                                       name="annual_entitlement"
                                       id="annual_entitlement"
                                       class="form-control"
                                       value="{{ old('annual_entitlement', 0) }}"
                                       min="0"
                                       required>
                                @error('annual_entitlement')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                                <small class="text-muted">عدد أيام الإجازة السنوية الممنوحة افتراضياً.</small>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div class="form-check">
                                    <!-- ✅ hidden input لإرسال 0 عند عدم الاختيار -->
                                    <input type="hidden" name="accrue_leaves" value="0">
                                    <input class="form-check-input" type="checkbox" value="1" id="accrue_leaves" name="accrue_leaves" {{ old('accrue_leaves', 1) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="accrue_leaves">{{ __('app.accrue_leaves_label') }}</label>
                                </div>
                                <small class="text-muted">{{ __('app.accrue_leaves_info') }}</small>
                            </div>
                        </div>

                        <div class="row mt-2">
                            <div class="col-md-6 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="1" id="deduct_if_underworked" name="deduct_if_underworked" {{ old('deduct_if_underworked') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="deduct_if_underworked">{{ __('app.deduct_if_underworked_label') }}</label>
                                </div>
                                <small class="text-muted">{{ __('app.deduct_if_underworked_info') }}</small>
                            </div>

                            <div class="col-md-6 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="1" id="overtime_paid" name="overtime_paid" {{ old('overtime_paid', 1) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="overtime_paid">{{ __('app.overtime_paid_label') }}</label>
                                </div>
                                <small class="text-muted">{{ __('app.overtime_paid_info') }}</small>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label class="form-label">{{ __('app.weekly_off_days_label') }}</label>
                                <div class="d-flex gap-2 flex-wrap">
                                        @php
                                            $days = __('app.week_days');
                                            // determine pre-selected days: prefer old input, else check query param `weekly_off`
                                            $preSelected = old('weekly_off_days', []);
                                            if (!is_array($preSelected)) {
                                                $preSelected = $preSelected ? (array) $preSelected : [];
                                            }
                                            $fromQuery = request()->query('weekly_off');
                                            if ($fromQuery) {
                                                if (is_array($fromQuery)) {
                                                    $preSelected = array_merge($preSelected, $fromQuery);
                                                } else {
                                                    $preSelected[] = $fromQuery;
                                                }
                                            }
                                            $preSelected = array_values(array_filter($preSelected));
                                            $preSingle = count($preSelected) > 0 ? $preSelected[0] : null;
                                        @endphp

                                        {{-- Multi-select (Select2) for weekly off days --}}
                                        <div class="mb-2 w-100">
                                            <label for="weekly_off_select" class="form-label">{{ __('app.weekly_off_days_label') }}</label>
                                            <select id="weekly_off_select" name="weekly_off_days[]" class="form-control select2" multiple="multiple" aria-label="weekly off select" data-placeholder="{{ __('app.weekly_off_days_label') }}">
                                                @foreach($days as $key=>$label)
                                                    <option value="{{ $key }}" {{ in_array($key, $preSelected) ? 'selected' : '' }}>{{ $label }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                </div>
                                <small class="text-muted">{{ __('app.weekly_off_days_info') }}</small>
                            </div>
                        </div>

                        <!-- قسم مكونات الراتب الإضافية -->
                        <div class="col-md-12 mb-3">
                            <h5>{{ __('app.salary_components_section') }}</h5>
                            <!-- ✅ تغيير id إلى "componentsContainer" ليطابق الكود الأصلي -->
                            <div id="componentsContainer">
                                @for ($i = 1; $i <= 7; $i++)
                                    <div class="row mb-2 component-row align-items-center">
                                        <div class="col-md-5">
                                            <input type="text" class="form-control component-name" name="component_names[]" placeholder="{{ __('app.component_name_placeholder') }}"
                                                   value="{{ $defaultComponents["name_$i"] ?? '' }}">
                                        </div>
                                        <div class="col-md-5">
                                            <input type="number" class="form-control component-value" name="component_values[]" placeholder="{{ __('app.component_value_placeholder') }}" step="0.01" min="0"
                                                   value="{{ $defaultComponents["value_$i"] ?? '' }}">
                                        </div>
                                        <div class="col-md-2">
                                            <button type="button" class="btn btn-sm btn-outline-danger remove-component">{{ __('app.remove') }}</button>
                                        </div>
                                    </div>
                                @endfor
                            </div>
                            <!-- ✅ تغيير id إلى "addComponent" ليطابق الكود الأصلي -->
                            <input type="text" id="addComponent" class="d-none"> <!-- حقل مخفي لربط الحدث فقط -->
                            <button type="button" id="add-component-btn" class="btn btn-info btn-sm mb-3">+ {{ __('app.add_component') }}</button>
                        </div>

                        <!-- تاريخ الميلاد والعمر -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="birth_date" class="form-label">{{ __('app.birth_date') }}</label>
                                <input type="date"
                                       name="birth_date"
                                       id="birth_date"
                                       class="form-control"
                                       value="{{ old('birth_date') }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="age_display" class="form-label">{{ __('app.age') }}</label>
                                <input type="text"
                                       id="age_display"
                                       class="form-control"
                                       readonly>
                                <input type="hidden" name="age" id="age_hidden">
                            </div>
                        </div>

                        <!-- المؤهل العلمي والرقم الوطني -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="qualification" class="form-label">{{ __('app.qualification') }}</label>
                                <input type="text"
                                       name="qualification"
                                       id="qualification"
                                       class="form-control"
                                       value="{{ old('qualification') }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="national_id" class="form-label">{{ __('app.national_id') }}</label>
                                <input type="text"
                                       name="national_id"
                                       id="national_id"
                                       class="form-control"
                                       value="{{ old('national_id') }}">
                            </div>
                        </div>

                        <!-- العنوان -->
                        <div class="mb-3">
                            <label for="address" class="form-label">{{ __('app.address') }}</label>
                            <textarea name="address"
                                      id="address"
                                      class="form-control"
                                      rows="2">{{ old('address') }}</textarea>
                        </div>

                        <!-- الصورة الشخصية -->
                        <div class="mb-3">
                            <label for="photo" class="form-label">{{ __('app.employee_photo') }}</label>
                            <input type="file"
                                   name="photo"
                                   id="photo"
                                   class="form-control"
                                   accept="image/*">
                        </div>

                        <!-- السيرة الذاتية -->
                        <div class="mb-3">
                            <label for="cv_files" class="form-label">{{ __('app.upload_cv') }}</label>
                            <input type="file"
                                   name="cv_files[]"
                                   id="cv_files"
                                   class="form-control"
                                   multiple
                                   accept=".pdf,.doc,.docx">
                        </div>

                        <!-- أوقات الحضور والانصراف المجدولة -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="scheduled_check_in" class="form-label">{{ __('app.scheduled_check_in') }}</label>
                                <input type="time"
                                       name="scheduled_check_in"
                                       id="scheduled_check_in"
                                       class="form-control"
                                       value="{{ old('scheduled_check_in', '09:00') }}"
                                       required>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="scheduled_check_out" class="form-label">{{ __('app.scheduled_check_out') }}</label>
                                <input type="time"
                                       name="scheduled_check_out"
                                       id="scheduled_check_out"
                                       class="form-control"
                                       value="{{ old('scheduled_check_out', '17:00') }}"
                                       required>
                            </div>
                        </div>

                        <!-- الحالة -->
                        <div class="mb-3">
                            <label for="status" class="form-label">{{ __('app.status_label') }}</label>
                            <select name="status" id="status" class="form-control" required>
                                <option value="active" {{ old('status') == 'active' ? 'selected' : '' }}>{{ __('app.active') }}</option>
                                <option value="inactive" {{ old('status') == 'inactive' ? 'selected' : '' }}>{{ __('app.inactive') }}</option>
                                <option value="pending" {{ old('status') == 'pending' ? 'selected' : '' }}>{{ __('app.pending') }}</option>
                            </select>
                        </div>

                        <!-- زر الإرسال -->
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save"></i> {{ __('app.save') }}
                            </button>
                            <a href="{{ route('employees.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> {{ __('app.back') }}
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@include('employees.partials.add-department-modal')
@include('employees.partials.add-position-modal')
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const birthDateInput = document.getElementById('birth_date');
        const ageDisplay = document.getElementById('age_display');
        const ageHidden = document.getElementById('age_hidden');
        // ✅ تصدير متغير $currency_name إلى JavaScript
        const currencyName = @json($currency_name);

        // ✅ دالة لحساب إجمالي الراتب (الأساسي + الحوافز + مكونات الراتب)
        function updateTotalSalary() {
            const basic = parseFloat(document.getElementById('salary').value) || 0;
            const incentives = parseFloat(document.getElementById('incentives').value) || 0;

            // حساب مجموع مكونات الراتب
            let componentsTotal = 0;
            // ✅ البحث عن عناصر component-value داخل container الصحيح
            const componentRows = document.querySelectorAll('#componentsContainer .component-value');
            componentRows.forEach(input => {
                const value = parseFloat(input.value) || 0;
                componentsTotal += value;
            });

            const total = basic + incentives + componentsTotal;
            // ✅ استخدام المتغير currencyName المُصدر من PHP
            document.getElementById('total_salary_display').value = total.toFixed(2) + ' ' + currencyName;
        }

        // ✅ دالة لإضافة مكون راتب (حقل نصي للاسم وحقل رقمي للقيمة) - مبنية على الكود الأصلي
        function addComponentRow(componentName = '', componentValue = '') {
            const container = document.getElementById('componentsContainer');
            const componentIndex = container.children.length + 1;
            if (componentIndex > 7) {
                alert('لا يمكن إضافة أكثر من 7 مكونات.');
                return;
            }

            const newRow = document.createElement('div');
            newRow.className = 'row component-row mb-2';

            newRow.innerHTML = `
                <div class="col-md-5">
                    <input type="text" name="component_names[]" class="form-control component-name" placeholder="اسم المكون" maxlength="255" value="${componentName}">
                </div>
                <div class="col-md-5">
                    <input type="number" step="0.01" name="component_values[]" class="form-control component-value" placeholder="القيمة" min="0" value="${componentValue}">
                </div>
                <div class="col-md-2">
                    <button type="button" class="btn btn-danger btn-sm remove-component">حذف</button>
                </div>
            `;
            container.appendChild(newRow);

            // ✅ ربط حدث "input" لحقل القيمة الجديد لتحديث المجموع
            newRow.querySelector('.component-value').addEventListener('input', updateTotalSalary);

            // ✅ إضافة مستمع الحدث للحذف إلى الزر الجديد
            newRow.querySelector('.remove-component').addEventListener('click', function () {
                newRow.remove();
                updateTotalSalary(); // تحديث المجموع بعد الحذف
            });

            // التأكد من أن الحد الأقصى هو 7 مكونات عند الإضافة
            if (container.children.length >= 7) {
                document.getElementById('add-component-btn').disabled = true;
            }
        }

        // ✅ إضافة مكون عند النقر على الزر
        document.getElementById('add-component-btn').addEventListener('click', function () {
            addComponentRow();
        });

        // ✅ ربط حدث "input" لحقول القيم التي تم تحميلها مسبقًا (من $defaultComponents)
        document.querySelectorAll('#componentsContainer .component-value').forEach(input => {
            input.addEventListener('input', updateTotalSalary);
        });

        // ✅ ربط حدث "click" لأزرار الحذف التي تم تحميلها مسبقًا
        document.querySelectorAll('#componentsContainer .remove-component').forEach(button => {
            button.addEventListener('click', function () {
                this.closest('.component-row').remove();
                updateTotalSalary(); // تحديث المجموع بعد الحذف
                // ✅ إعادة تمكين الزر إذا كان العدد أقل من 7 بعد الحذف
                if (document.getElementById('componentsContainer').children.length < 7) {
                    document.getElementById('add-component-btn').disabled = false;
                }
            });
        });

        // ✅ ربط حدث "input" للحقول الثابتة (الراتب الأساسي والحوافز) لتحديث المجموع
        document.getElementById('salary')?.addEventListener('input', updateTotalSalary);
        document.getElementById('incentives')?.addEventListener('input', updateTotalSalary);

        // ✅ تحديث المجموع عند التحميل (لحساب القيم الافتراضية أو القديمة)
        updateTotalSalary();

        // التأكد من أن الحد الأقصى هو 7 مكونات عند التحميل
        const container = document.getElementById('componentsContainer');
        if (container.children.length >= 7) {
            document.getElementById('add-component-btn').disabled = true;
        }

        // تحديث العمر عند تغيير تاريخ الميلاد
        if (birthDateInput) {
            birthDateInput.addEventListener('change', function () {
                const birthDateValue = this.value;
                if (birthDateValue) {
                    const birthDate = new Date(birthDateValue);
                    const today = new Date();
                    let age = today.getFullYear() - birthDate.getFullYear();
                    const monthDiff = today.getMonth() - birthDate.getMonth();
                    if (monthDiff < 0 || (monthDiff === 0 && today.getDate() < birthDate.getDate())) {
                        age--;
                    }
                    ageDisplay.value = age + ' سنة';
                    ageHidden.value = age;
                } else {
                    ageDisplay.value = '';
                    ageHidden.value = '';
                }
            });
        }

    });

    // إضافة قسم جديد
    function submitAddDepartment() {
        const nameInput = document.getElementById('new_department_name');
        const name = nameInput.value.trim();
        const description = document.getElementById('new_department_desc').value.trim(); // ✅ إضافة الحقل المفقود

        if (!name) {
            alert('يرجى إدخال اسم القسم.');
            return;
        }

        fetch('{{ route("departments.store") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({ name, description }) // ✅ إرسال الوصف
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                const select = document.getElementById('department_id');
                const option = new Option(data.department.name, data.department.id);
                select.add(option);
                select.value = data.department.id;

                bootstrap.Modal.getInstance(document.getElementById('addDepartmentModal')).hide();
                alert(data.message);

                nameInput.value = '';
                document.getElementById('new_department_desc').value = ''; // ✅ مسح الحقل المضاف
            } else {
                alert(data.message || 'خطأ في إضافة القسم');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('حدث خطأ أثناء إضافة القسم.');
        });
    }

    // إضافة منصب جديد
    function submitAddPosition() {
        const nameInput = document.getElementById('new_position_name');
        const departmentSelect = document.getElementById('position_department_id');

        const name = nameInput.value.trim();
        const departmentId = departmentSelect.value;
        const description = document.getElementById('new_position_desc').value.trim();

        if (!name || !departmentId) {
            alert('يرجى إدخال جميع الحقول المطلوبة.');
            return;
        }

        fetch('{{ route("positions.store") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({ name, department_id: departmentId, description })
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                const select = document.getElementById('position_id');
                const deptName = document.querySelector(`#position_department_id option[value="${departmentId}"]`).text;
                const option = new Option(`${data.position.name} (${deptName})`, data.position.id);
                select.add(option);
                select.value = data.position.id;

                bootstrap.Modal.getInstance(document.getElementById('addPositionModal')).hide();
                alert(data.message);

                nameInput.value = '';
                departmentSelect.value = '';
                document.getElementById('new_position_desc').value = ''; // ✅ مسح الحقل
            } else {
                alert(data.message || 'خطأ في إضافة المنصب');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('حدث خطأ أثناء إضافة المنصب.');
        });
    }
    // ✅ إصلاح الزر (الوظيفة الأصلية للزر موجودة في addComponentRow)
    // window.addEventListener('load', function () {
    //     const addBtn = document.getElementById('addComponent'); // لا يوجد زر مع هذا الـ id بعد التعديل
    //     if (addBtn) {
    //         addBtn.addEventListener('click', function () {
    //             console.log('✅ زر إضافة المكون يعمل الآن');
    //         });
    //     } else {
    //         console.error('❌ لم يتم العثور على زر إضافة المكون');
    //     }
    // });

        // Initialize Select2 for multi-select weekly off days
        (function() {
            const select = document.getElementById('weekly_off_select');
            if (!select) return;
            // load select2 if available
            try {
                if (window.jQuery && typeof window.jQuery.fn.select2 === 'function') {
                    window.jQuery(select).select2({
                        placeholder: '{{ __('app.weekly_off_days_label') }}',
                        width: '100%'
                    });
                }
            } catch (e) {
                // ignore
            }
        })();

</script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
@endpush