@extends('layouts.app')

@section('title', __('calendar.title') . ' - ' . ($employee->name ?? ''))

@section('content')
<style>
    /* Make all table cell text black */
    #calendarGrid table td,
    #calendarGrid table th {
        color: #000 !important;
    }
    
    /* Ensure badge text is also black */
    #calendarGrid .badge {
        color: #000 !important;
    }
    
    /* Ensure small text is black */
    #calendarGrid small {
        color: #000 !important;
    }
    
    /* Ensure span text is black */
    #calendarGrid span {
        color: #000 !important;
    }
</style>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('calendar.attendance_calendar') }} {{ $employee->name ?? __('calendar.employee') }}</h4>
                <div class="page-title-right">
                    <a href="{{ route('employees.index') }}" class="btn btn-secondary">{{ __('calendar.back') }}</a>
                </div>
            </div>
        </div>
    </div>

    <div class="card mt-3">
        <div class="card-body">
            <form id="monthForm" class="form-inline mb-3">
                <label class="mr-2">{{ __('calendar.month') }}</label>
                <select id="month" name="month" class="form-control mr-2">
                    @for($m=1;$m<=12;$m++)
                        <option value="{{ $m }}" {{ $m == $month ? 'selected' : '' }}>{{ \Carbon\Carbon::create()->month($m)->format('F') }} ({{ $m }})</option>
                    @endfor
                </select>

                <label class="mr-2">{{ __('calendar.year') }}</label>
                <select id="year" name="year" class="form-control mr-2">
                    @for($y = now()->year -1; $y <= now()->year +1; $y++)
                        <option value="{{ $y }}" {{ $y == $year ? 'selected' : '' }}>{{ $y }}</option>
                    @endfor
                </select>

                <button type="button" id="showBtn" class="btn btn-primary">{{ __('calendar.show') }}</button>
            </form>

            <div id="calendarGrid">
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>{{ __('calendar.table.day') }}</th>
                                <th>{{ __('calendar.table.date') }}</th>
                                <th>{{ __('calendar.table.status') }}</th>
                                <th>{{ __('calendar.table.reason') }}</th>
                                <th>{{ __('calendar.table.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(empty($days))
                                <tr>
                                    <td colspan="5" class="text-center">{{ __('calendar.table.no_data') }}</td>
                                </tr>
                            @else
                            @foreach($days as $d)
                                <tr data-date="{{ $d['date'] }}" @if($d['is_other_month'] ?? false) style="opacity: 0.6; background-color: #f9f9f9;" @endif>
                                    <td>{{ $d['label'] }}</td>
                                    <td>{{ $d['date'] }}</td>
                                    <td>
                                        @if($d['status'] == 'holiday')
                                            <span class="badge badge-info">{{ __('calendar.statuses.holiday') }}</span>
                                        @elseif($d['status'] == 'weekly_off')
                                            <span class="badge badge-secondary">{{ __('calendar.statuses.weekly_off') }}</span>
                                        @elseif($d['status'] == 'present_on_official_holiday')
                                            <span class="badge badge-warning">{{ __('calendar.statuses.present_on_official_holiday') }}</span>
                                        @elseif($d['status'] == 'present_on_weekly_off')
                                            <span class="badge badge-warning">{{ __('calendar.statuses.present_on_weekly_off') }}</span>
                                        @elseif($d['status'] == 'leave')
                                            <span class="badge badge-success">{{ __('calendar.statuses.leave') }}</span>
                                        @elseif($d['status'] == 'not_present')
                                            <span class="badge badge-danger">{{ __('calendar.statuses.not_present') }}</span>
                                        @elseif($d['status'] == 'present')
                                            <span class="badge badge-light">{{ __('calendar.statuses.present') }}</span>
                                        @else
                                            <span class="badge badge-light">{{ __('calendar.statuses.present') }}</span>
                                        @endif
                                    </td>
                                    <td class="reason-cell">
                                        @if($d['status'] == 'leave')
                                            <small class="text-muted">{{ $d['reason'] ?? '-' }}</small>
                                        @elseif($d['status'] == 'not_present')
                                            <small class="text-danger"><strong>{{ __('calendar.statuses.not_present') }}</strong></small>
                                        @elseif($d['status'] == 'holiday')
                                            <small class="text-info">{{ $d['reason'] ?? __('calendar.statuses.holiday') }}</small>
                                        @elseif($d['status'] == 'weekly_off')
                                            <small class="text-secondary">{{ $d['reason'] ?? __('calendar.statuses.weekly_off') }}</small>
                                        @elseif($d['status'] == 'present_on_official_holiday')
                                            <small class="text-success"><strong>{{ __('calendar.statuses.present_on_official_holiday') }}</strong><br><small class="text-muted">{{ $d['reason'] ?? '' }}</small></small>
                                        @elseif($d['status'] == 'present_on_weekly_off')
                                            <small class="text-success"><strong>{{ __('calendar.statuses.present_on_weekly_off') }}</strong></small>
                                        @elseif($d['status'] == 'present')
                                            <small class="text-success"><strong>{{ __('calendar.statuses.present') }}</strong></small>
                                        @else
                                            <small class="text-muted">-</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($d['status'] == 'not_present')
                                            <div class="d-flex align-items-center gap-2" data-date="{{ $d['date'] }}">
                                                <!-- Deduction source select (compact) -->
                                                <select class="form-control form-control-sm deduction-source" data-date="{{ $d['date'] }}" style="flex:1; max-width:180px;">
                                                    <option value="monthly">{{ __('calendar.deduction_source.monthly') }}</option>
                                                    <option value="annual">{{ __('calendar.deduction_source.annual') }}</option>
                                                </select>

                                                <!-- Grant leave using selected source -->
                                                <button class="btn btn-sm btn-danger grant-absent-leave" data-date="{{ $d['date'] }}">{{ __('calendar.actions.grant_leave') }}</button>
                                            </div>
                                        @else
                                            <!-- لا توجد أزرار -->
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Translation helper
    const translations = {
        ar: {
            'confirm_grant': '{{ __("calendar.actions.confirm_grant") }}',
            'confirm_absent': '{{ __("calendar.actions.confirm_absent") }}',
            'grant_success': '{{ __("calendar.actions.success") }}',
            'grant_error': '{{ __("calendar.actions.error") }}',
            'deduction_amount': '{{ __("calendar.actions.deduction_amount_label") }}',
            'grant_modal_title': '{{ __("calendar.actions.grant_modal_title") }}',
            'deduction_modal_title': '{{ __("calendar.actions.deduction_modal_title") }}',
            'source_label': '{{ __("calendar.actions.deduction_source_label") }}',
            'reason_label': '{{ __("calendar.actions.reason_label") }}',
            'amount_label': '{{ __("calendar.actions.amount_label") }}',
            'confirm': '{{ __("calendar.actions.confirm") }}',
            'cancel': '{{ __("calendar.actions.cancel") }}',
            'execute_deduction': '{{ __("calendar.actions.execute_deduction") }}',
            'amount_not_specified': '{{ __("calendar.actions.amount_not_specified") }}',
            'source_none': '{{ __("calendar.deduction_source.none") }}',
            'source_monthly': '{{ __("calendar.deduction_source.monthly") }}',
            'source_annual': '{{ __("calendar.deduction_source.annual") }}',
        }
    };

    document.getElementById('showBtn').addEventListener('click', function(){
        const m = document.getElementById('month').value;
        const y = document.getElementById('year').value;
        const u = new URL(window.location.href);
        u.searchParams.set('month', m);
        u.searchParams.set('year', y);
        window.location.href = u.toString();
    });

    // helper to send action
    async function sendAction(date, action, extra = {}){
        const res = await fetch('{{ route('employees.calendar.action', $employee) }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(Object.assign({date: date, action: action}, extra))
        });
        return res.json();
    }

    document.querySelectorAll('.grant-leave').forEach(b=> b.addEventListener('click', async function(e){
        const date = this.dataset.date;
        if (!confirm(translations.ar.confirm_grant + ' ' + date + '؟')) return;
        const r = await sendAction(date, 'grant_leave');
        if (r.status === 'ok') location.reload(); else alert(r.message || translations.ar.grant_error);
    }));

    document.querySelectorAll('.mark-absent').forEach(b=> b.addEventListener('click', async function(e){
        const date = this.dataset.date;
        if (!confirm(translations.ar.confirm_absent + ' ' + date + '؟')) return;
        const r = await sendAction(date, 'mark_absent');
        if (r.status === 'ok') location.reload(); else alert(r.message || translations.ar.grant_error);
    }));

    document.querySelectorAll('.apply-deduction').forEach(b=> b.addEventListener('click', async function(e){
        const date = this.dataset.date;
        const amount = prompt(translations.ar.deduction_amount);
        if (amount === null) return;
        const r = await sendAction(date, 'apply_deduction', {deduction_amount: amount});
        if (r.status === 'ok') location.reload(); else alert(r.message || translations.ar.grant_error);
    }));

    // Grant absent leave with selected source (smart balance handling)
    document.querySelectorAll('.grant-absent-leave').forEach(b => b.addEventListener('click', async function(){
        const date = this.dataset.date;
        const sel = document.querySelector('.deduction-source[data-date="' + date + '"]');
        const from = sel ? sel.value : 'annual';
        
        const sourceLabels = {
            'annual': translations.ar.source_annual,
            'monthly': translations.ar.source_monthly
        };
        const sourceLabel = sourceLabels[from] || from;
        const msg = translations.ar.confirm_grant + ' ' + date + ' ' + translations.ar.reason_label + ' ' + sourceLabel + '؟';
        if (!confirm(msg)) return;
        
        const r = await sendAction(date, 'grant_leave', {from: from});
        if (r.status === 'ok') {
            // Update the row without page reload
            const row = document.querySelector('tr[data-date="' + date + '"]');
            if (row) {
                // Update status cell with badge from server response
                const statusCell = row.querySelector('td:nth-child(3)');
                const reasonCell = row.querySelector('td:nth-child(4)');
                const actionCell = row.querySelector('td:nth-child(5)');
                
                // Use the badge text from server response
                const badgeClass = r.new_status === 'deducted' ? 'badge-warning' : 'badge-success';
                const badgeText = r.new_badge || (r.new_status === 'deducted' ? '{{ __("calendar.statuses.deducted") }}' : '{{ __("calendar.statuses.leave") }}');
                
                // Update status badge
                statusCell.innerHTML = '<span class="badge ' + badgeClass + '">' + badgeText + '</span>';
                
                // Update reason cell with the detailed message from server
                const reasonText = r.message || translations.ar.grant_success;
                reasonCell.innerHTML = '<small class="text-success"><strong>' + reasonText + '</strong></small>';
                
                // Clear action cell (hide buttons)
                actionCell.innerHTML = '';
            }
            // Show success message to user
            alert(r.message || translations.ar.grant_success);
        } else {
            alert(r.message || translations.ar.grant_error);
        }
    }));

        // --- Modal grant leave flow ---
        // Create modals HTML
        const grantModalHtml = `
        <div class="modal fade" id="grantModal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header"><h5 class="modal-title">${translations.ar.grant_modal_title}</h5><button type="button" class="close" data-dismiss="modal">&times;</button></div>
                    <div class="modal-body">
                        <input type="hidden" id="grant_date">
                        <div class="form-group">
                            <label>${translations.ar.source_label}</label>
                            <select id="grant_source" class="form-control">
                                <option value="none">${translations.ar.source_none}</option>
                                <option value="monthly">${translations.ar.source_monthly}</option>
                                <option value="annual">${translations.ar.source_annual}</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>${translations.ar.reason_label}</label>
                            <input type="text" id="grant_reason" class="form-control">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" id="grantConfirm" class="btn btn-primary">${translations.ar.confirm}</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">${translations.ar.cancel}</button>
                    </div>
                </div>
            </div>
        </div>`;

        document.body.insertAdjacentHTML('beforeend', grantModalHtml);

        document.querySelectorAll('.open-grant-modal').forEach(btn => btn.addEventListener('click', function(){
                document.getElementById('grant_date').value = this.dataset.date;
                document.getElementById('grant_reason').value = '';
                $('#grantModal').modal('show');
        }));

        document.getElementById('grantConfirm').addEventListener('click', async function(){
                const date = document.getElementById('grant_date').value;
                const source = document.getElementById('grant_source').value;
                const reason = document.getElementById('grant_reason').value;
                const r = await sendAction(date, 'grant_leave', {from: source, reason: reason});
                if (r.status === 'ok') location.reload(); else alert(r.message || translations.ar.grant_error);
        });

        // --- Modal deduction flow ---
        const dedHtml = `
        <div class="modal fade" id="dedModal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header"><h5 class="modal-title">${translations.ar.deduction_modal_title}</h5><button type="button" class="close" data-dismiss="modal">&times;</button></div>
                    <div class="modal-body">
                        <input type="hidden" id="ded_date">
                        <div class="form-group"><label>${translations.ar.amount_label}</label><input type="number" id="ded_amount" class="form-control" step="0.01"></div>
                        <div class="form-group"><label>${translations.ar.reason_label}</label><input type="text" id="ded_reason" class="form-control"></div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" id="dedConfirm" class="btn btn-danger">${translations.ar.execute_deduction}</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">${translations.ar.cancel}</button>
                    </div>
                </div>
            </div>
        </div>`;

        document.body.insertAdjacentHTML('beforeend', dedHtml);

        document.querySelectorAll('.open-deduction-modal').forEach(btn => btn.addEventListener('click', function(){
                document.getElementById('ded_date').value = this.dataset.date;
                document.getElementById('ded_amount').value = '';
                document.getElementById('ded_reason').value = '';
                $('#dedModal').modal('show');
        }));

        document.getElementById('dedConfirm').addEventListener('click', async function(){
                const date = document.getElementById('ded_date').value;
                const amount = document.getElementById('ded_amount').value;
                const reason = document.getElementById('ded_reason').value;
                if (!amount || amount <= 0) { if (!confirm(translations.ar.amount_not_specified) ) return; }
                const r = await sendAction(date, 'apply_deduction', {deduction_amount: amount, reason: reason});
                if (r.status === 'ok') location.reload(); else alert(r.message || translations.ar.grant_error);
        });
</script>

@endsection
