@extends('layouts.app')

@section('title', __('deductions.form.show_title') . ' #' . $deduction->id)

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">{{ __('deductions.form.show_title') }}</h4>
                    <div class="d-flex gap-2">
                        <!-- back button -->
                        <a href="{{ route('deductions.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> {{ __('deductions.form.button_back') }}
                        </a>
                        <!-- edit button -->
                        @can('update', $deduction)
                            <a href="{{ route('deductions.edit', $deduction) }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-edit"></i> {{ __('deductions.form.button_update') }}
                            </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-4">
                        <div>
                            <h4 class="card-title">{{ __('deductions.form.show_title') }} #{{ $deduction->id }}</h4>
                            <p class="text-muted">{{ __('deductions.form.label_employee') }}: {{ $deduction->employee->name }}</p>
                        </div>
                        <div>
                            <!-- current record status (translated) -->
                            @switch($deduction->status)
                                @case('applied')
                                    <span class="badge bg-success fs-6">{{ __('deductions.status.applied') }}</span>
                                    @break
                                @case('pending')
                                    <span class="badge bg-warning text-dark fs-6">{{ __('deductions.status.pending') }}</span>
                                    @break
                                @case('cancelled')
                                    <span class="badge bg-secondary fs-6">{{ __('deductions.status.cancelled') }}</span>
                                    @break
                                @default
                                    <span class="badge bg-dark fs-6">{{ __('deductions.status.unknown') }}</span>
                            @endswitch
                        </div>
                    </div>

                    <!-- جدول تفاصيل الاستقطاع -->
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tr>
                                    <th>{{ __('deductions.table.type') }}</th>
                                <td>
                                    {{ __('deductions.type_labels.' . $deduction->type) ?? $deduction->type }}
                                </td>
                                <th>{{ __('deductions.table.description') }}</th>
                                <td>{{ $deduction->description ?: __('deductions.not_specified') }}</td>
                            </tr>
                            <tr>
                                <th>{{ __('deductions.table.amount') }}</th>
                                <td>{{ number_format($deduction->amount, 2) }} {{ get_currency_code() }}</td>
                                <th>{{ __('deductions.table.deduction_date') }}</th>
                                <td>{{ $deduction->deduction_date->format('Y-m-d') }}</td>
                            </tr>
                            <tr>
                                <th>{{ __('deductions.form.label_end_date') }}</th>
                                <td>{{ $deduction->end_date ? $deduction->end_date->format('Y-m-d') : __('deductions.not_specified') }}</td>
                                <th>{{ __('deductions.table.status') }}</th>
                                <td>
                                    @switch($deduction->status)
                                        @case('applied')
                                            <span class="badge bg-success">{{ __('deductions.status.applied') }}</span>
                                            @break
                                        @case('pending')
                                            <span class="badge bg-warning text-dark">{{ __('deductions.status.pending') }}</span>
                                            @break
                                        @case('cancelled')
                                            <span class="badge bg-secondary">{{ __('deductions.status.cancelled') }}</span>
                                            @break
                                        @default
                                            <span class="badge bg-dark">{{ __('deductions.status.unknown') }}</span>
                                    @endswitch
                                </td>
                            </tr>
                            <tr>
                                <th>{{ __('deductions.table.status') }}</th>
                                <td>
                                    @switch($deduction->status)
                                        @case('applied')
                                            <span class="badge bg-success">{{ __('deductions.status.applied') }}</span>
                                            @break
                                        @case('pending')
                                            <span class="badge bg-warning text-dark">{{ __('deductions.status.pending') }}</span>
                                            @break
                                        @case('cancelled')
                                            <span class="badge bg-secondary">{{ __('deductions.status.cancelled') }}</span>
                                            @break
                                        @default
                                            <span class="badge bg-dark">{{ __('deductions.status.unknown') }}</span>
                                    @endswitch
                                </td>
                                <th>{{ __('deductions.form.label_frequency') }}</th>
                                <td>
                                    @if($deduction->is_monthly)
                                        <span class="badge bg-success">{{ __('deductions.frequency.monthly') }}</span>
                                    @else
                                        <span class="badge bg-info text-dark">{{ __('deductions.frequency.once') }}</span>
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>

                    <!-- عرض جدول الاستقطاعات الشهرية إذا كانت موجودة -->
                    @if($relatedMonthlyDeductions->count() > 0)
                        <div class="mt-4">
                            <h5 class="mb-3">{{ __('deductions.cards.monthly') }}</h5>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                            <th>{{ __('deductions.table.id') }}</th>
                                            <th>{{ __('deductions.table.deduction_date') }}</th>
                                            <th>{{ __('deductions.table.amount') }}</th>
                                            <th>{{ __('deductions.table.status') }}</th>
                                            <th>{{ __('deductions.table.actions') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($relatedMonthlyDeductions as $monthlyDeduction)
                                            <tr>
                                                <td>{{ $monthlyDeduction->id }}</td>
                                                <td>{{ $monthlyDeduction->deduction_date->translatedFormat('F Y') }} ({{ $monthlyDeduction->deduction_date->format('Y-m-d') }})</td>
                                                <td>{{ number_format($monthlyDeduction->amount, 2) }} {{ $currency_name ?? 'د.ك' }}</td>
                                                <td>
                                                    @switch($monthlyDeduction->status)
                                                        @case('applied')
                                                            <span class="badge bg-success">{{ __('deductions.status.applied') }}</span>
                                                            @break
                                                        @case('pending')
                                                            <span class="badge bg-warning text-dark">{{ __('deductions.status.pending') }}</span>
                                                            @break
                                                        @case('cancelled')
                                                            <span class="badge bg-secondary">{{ __('deductions.status.cancelled') }}</span>
                                                            @break
                                                        @default
                                                            <span class="badge bg-dark">{{ __('deductions.status.unknown') }}</span>
                                                    @endswitch
                                                </td>
                                                <td>
                                                     <!-- زر تعديل يوجه إلى صفحة تعديل السجل الحالي -->
                                                    @can('update', $monthlyDeduction)
                                                        <a href="{{ route('deductions.edit', $monthlyDeduction) }}" class="btn btn-warning btn-sm" title="تعديل">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                    @endcan
                                                    <!-- زر حذف (اختياري) -->
                                                    @can('delete', $monthlyDeduction)
                                                        <form action="{{ route('deductions.destroy', $monthlyDeduction) }}" method="POST" class="d-inline">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger btn-sm" title="{{ __('app.delete') }}" onclick="return confirm('{{ addslashes(__('app.confirm_delete_deduction_month', ['month' => $monthlyDeduction->deduction_date->translatedFormat('F Y')])) }}')">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    @endcan
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="5" class="text-center text-muted">لا توجد استقطاعات شهرية مرتبطة.</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    @endif

                    <!-- جدول التواريخ المهمة -->
                    <div class="table-responsive mt-4">
                        <table class="table table-sm table-borderless">
                            <tr>
                                <th>{{ __('deductions.timestamps.created') }}</th>
                                <td>{{ $deduction->created_at->format('Y-m-d H:i:s') }}</td>
                                <th>{{ __('deductions.timestamps.updated') }}</th>
                                <td>{{ $deduction->updated_at->format('Y-m-d H:i:s') }}</td>
                            </tr>
                        </table>
                    </div>

                    <!-- بيانات وصفية إضافية -->
                    <div class="table-responsive mt-2">
                        <table class="table table-sm table-bordered">
                            <tr>
                                <th>{{ __('deductions.meta.created_by') }}</th>
                                <td>{{ $deduction->meta['created_by']['name'] ?? ($deduction->meta['created_by']['id'] ?? __('deductions.not_specified')) }}</td>
                                <th>{{ __('deductions.form.label_frequency') }}</th>
                                <td>{{ $deduction->meta['original_frequency'] ?? ($deduction->frequency ?? ($deduction->is_monthly ? 'monthly' : 'once')) }}</td>
                            </tr>
                            <tr>
                                <th>{{ __('deductions.meta.ip') }}</th>
                                <td>{{ $deduction->meta['ip'] ?? __('deductions.not_specified') }}</td>
                                <th>{{ __('deductions.meta.user_agent') }}</th>
                                <td>{{ $deduction->meta['user_agent'] ?? __('deductions.not_specified') }}</td>
                            </tr>
                        </table>
                    </div>

                </div> <!-- End of card body -->
            </div> <!-- End of card -->
        </div> <!-- End of col -->
    </div> <!-- End of row -->
</div> <!-- End of container -->
@endsection