<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <title>{{ __('deductions.print_heading') }} - {{ $employee->name }}</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .header { text-align: center; margin-bottom: 20px; }
        .info-section { margin-bottom: 15px; }
        .info-section h3 { border-bottom: 1px solid #ccc; padding-bottom: 3px; }
        .info-table { width: 100%; border-collapse: collapse; }
        .info-table td { border: 1px solid #ccc; padding: 5px; vertical-align: top; }
        .info-table th { background-color: #f2f2f2; border: 1px solid #ccc; padding: 5px; text-align: right; }
        .deduction-row { font-size: 0.9em; }
        .status-badge { padding: 2px 5px; border-radius: 3px; font-size: 0.8em; }
        .badge-success { background-color: #d4edda; color: #155724; }
        .badge-warning { background-color: #fff3cd; color: #856404; }
        .badge-danger { background-color: #f8d7da; color: #721c24; }
        .badge-info { background-color: #d1ecf1; color: #0c5460; }
        .badge-secondary { background-color: #d6d8db; color: #383d41; }
        .text-danger { color: #dc3545; }
        .text-success { color: #28a745; }
        .text-warning { color: #ffc107; }
        /* أضف CSS إضافي للطباعة */
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>{{ __('deductions.print_heading') }}: {{ $employee->name }}</h2>
        <h3>{{ __('deductions.employee_employee_id') }}: {{ $employee->employee_id }}</h3>
    </div>

    <div class="info-section">
        <h3>{{ __('deductions.print_heading') }} ({{ $deductions->last()?->created_at->format('Y-m-d') ?? 'N/A' }} - {{ $deductions->first()?->created_at->format('Y-m-d') ?? 'N/A' }})</h3>
        <table class="info-table">
            <thead>
                <tr>
                    <th>{{ __('deductions.table.id') }}</th>
                    <th>{{ __('deductions.table.type') }}</th>
                    <th>{{ __('deductions.table.amount') }}</th>
                    <th>{{ __('deductions.table.status') }}</th>
                    <th>{{ __('deductions.table.deduction_date') }}</th>
                    <th>{{ __('deductions.form.label_end_date') }}</th>
                    <th>{{ __('deductions.table.description') }}</th>
                    <th>{{ __('deductions.table.created_at') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse($deductions as $deduction)
                <tr class="deduction-row">
                    <td>{{ $deduction->id }}</td>
                    <td>
                        {{ __('deductions.type_labels.' . $deduction->type) ?? $deduction->type }}
                        @if($deduction->name)
                            <br><small class="text-muted">{{ $deduction->name }}</small>
                        @endif
                    </td>
                    <td>{{ number_format($deduction->amount, 2) }} {{ get_currency_code() }}</td>
                    <td>
                        @php
                            $statusClasses = [
                                'pending' => 'badge-warning',
                                'applied' => 'badge-success',
                                'cancelled' => 'badge-secondary',
                            ];
                            $statusLabels = [
                                'pending' => __('deductions.status.pending'),
                                'applied' => __('deductions.status.applied'),
                                'cancelled' => __('deductions.status.cancelled'),
                            ];
                            $badgeClass = $statusClasses[$deduction->status] ?? 'badge-dark';
                            $badgeLabel = $statusLabels[$deduction->status] ?? $deduction->status;
                        @endphp
                        <span class="status-badge {{ $badgeClass }}">{{ $badgeLabel }}</span>
                    </td>
                    <td>{{ $deduction->deduction_date ? $deduction->deduction_date->format('Y-m-d') : __('deductions.not_specified') }}</td>
                    <td>{{ $deduction->end_date ? $deduction->end_date->format('Y-m-d') : __('deductions.not_specified') }}</td>
                    <td>{{ Str::limit($deduction->description, 50) }}</td>
                    <td>{{ $deduction->created_at->format('Y-m-d') }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="9" class="text-center py-3">{{ __('deductions.no_deductions') }}</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <script>
        // طباعة الصفحة مباشرة عند التحميل
        window.onload = function() {
            window.print();
        };
    </script>
</body>
</html>