@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('deductions.page_title') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('deductions.breadcrumb_home') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('deductions.breadcrumb_deductions') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('deductions.cards.total_deductions') }}</p>
                            <h4 class="mb-0">{{ $totalDeductions ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-file-invoice-dollar fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('deductions.cards.total_amount') }}</p>
                            <h4 class="mb-0">{{ number_format($totalAmount ?? 0, 2) }} {{ get_currency_code() }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-money-bill-wave fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('deductions.cards.monthly') }}</p>
                            <h4 class="mb-0">{{ $monthlyDeductions ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-calendar-alt fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('deductions.cards.annual') }}</p>
                            <h4 class="mb-0">{{ $annualDeductions ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-calendar fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters Section -->
    <div class="row mb-4">
        <div class="col-md-3">
            <input type="text" id="searchInput" class="form-control" placeholder="{{ __('deductions.filters.search_placeholder') }}">
        </div>
        <div class="col-md-3">
            <select id="employeeFilter" class="form-select">
                <option value="">{{ __('deductions.filters.all_employees') }}</option>
                @foreach($employees as $employee)
                    <option value="{{ $employee->id }}">{{ $employee->name }} ({{ $employee->employee_id }})</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-2">
            <select id="typeFilter" class="form-select">
                <option value="">{{ __('deductions.filters.all_types') }}</option>
                @foreach(__('deductions.type_labels') as $key => $label)
                    <option value="{{ $key }}">{{ $label }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-2">
            <select id="statusFilter" class="form-select">
                <option value="">{{ __('deductions.filters.all_statuses') }}</option>
                <option value="pending">{{ __('deductions.status.pending') }}</option>
                <option value="applied">{{ __('deductions.status.applied') }}</option>
                <option value="cancelled">{{ __('deductions.status.cancelled') }}</option>
            </select>
        </div>
        <div class="col-md-2 d-flex align-items-end">
            <button id="applyFilters" class="btn btn-primary w-100 me-1">
                <i class="fas fa-filter"></i> {{ __('deductions.buttons.apply') }}
            </button>
            <button id="resetFilters" class="btn btn-outline-secondary w-100">
                <i class="fas fa-sync-alt"></i> {{ __('deductions.buttons.reset') }}
            </button>
        </div>
    </div>

    <!-- Main Content -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h4 class="card-title">{{ __('deductions.page_title') }}</h4>
                        <div class="btn-group">
                            @can('create deduction')
                            <a href="{{ route('deductions.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus"></i> {{ __('deductions.buttons.create') }}
                            </a>
                            @endcan
                        </div>
                    </div>

                    <!-- Deductions Table -->
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap table-hover" id="deductionsTable">
                            <thead class="thead-light">
                                <tr>
                                    <th>{{ __('deductions.table.id') }}</th>
                                    <th>{{ __('deductions.table.employee_name') }}</th>
                                    <th>{{ __('deductions.table.type') }}</th>
                                    <th>{{ __('deductions.table.amount') }}</th>
                                    <th>{{ __('deductions.table.description') }}</th>
                                    <th>{{ __('deductions.table.deduction_date') }}</th>
                                    <th>{{ __('deductions.table.frequency') }}</th>
                                    <th>{{ __('deductions.table.status') }}</th>
                                    <th>{{ __('deductions.table.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($deductions as $deduction)
                                <tr>
                                    <td>{{ $deduction->id }}</td>
                                    <td>{{ $deduction->employee->name ?? 'غير محدد' }}</td>
                                    <td>
                                        <span class="badge bg-soft-dark text-dark">{{ __('deductions.type_labels.' . $deduction->type) }}</span>
                                    </td>
                                    <td>{{ number_format($deduction->amount ?? 0, 2) }} {{ get_currency_code() }}</td>
                                    <td>{{ $deduction->description ?? '-' }}</td>
                                    <td>{{ $deduction->deduction_date?->format('Y-m-d') ?? __('deductions.not_specified') }}</td>
                                    <td>
                                        @php $freq = $deduction->frequency ?? ($deduction->is_monthly ? 'monthly' : 'once'); @endphp
                                        @if($freq === 'monthly')
                                            <span class="badge bg-success">{{ __('deductions.frequency.monthly') }}</span>
                                        @elseif(in_array($freq, ['yearly','annual']))
                                            <span class="badge bg-info text-dark">{{ __('deductions.frequency.yearly') }}</span>
                                        @else
                                            <span class="badge bg-secondary">{{ __('deductions.frequency.once') }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($deduction->status == 'applied')
                                            <span class="badge bg-success">{{ __('deductions.status.applied') }}</span>
                                        @elseif($deduction->status == 'pending')
                                            <span class="badge bg-warning text-dark">{{ __('deductions.status.pending') }}</span>
                                        @elseif($deduction->status == 'cancelled')
                                            <span class="badge bg-danger">{{ __('deductions.status.cancelled') }}</span>
                                        @else
                                            <span class="badge bg-secondary">{{ __('deductions.status.unknown') ?? 'غير معروف' }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('deductions.show', $deduction) }}" class="btn btn-info btn-sm"><i class="fas fa-eye"></i></a>
                                        <!-- ✅ تم التعديل: تحقق من إذن المستخدم باستخدام hasPermission أو hasRole -->
                                        @if(auth()->user()->hasPermission('edit_deductions') || auth()->user()->hasRole(['admin', 'super-admin']))
                                        <a href="{{ route('deductions.edit', $deduction) }}" class="btn btn-warning btn-sm"><i class="fas fa-edit"></i></a>
                                        @endif
                                        <!-- ✅ تم التعديل: تحقق من إذن المستخدم باستخدام hasPermission أو hasRole -->
                                        @if(auth()->user()->hasPermission('delete_deductions') || auth()->user()->hasRole(['admin', 'super-admin']))
                                        <form action="{{ route('deductions.destroy', $deduction) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('{{ addslashes(__('app.confirm_delete_deduction')) }}')"><i class="fas fa-trash"></i></button>
                                        </form>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">{{ __('deductions.table.no_records') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if(isset($deductions) && $deductions->hasPages())
                    <div class="d-flex justify-content-center">
                        {{ $deductions->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('searchInput');
    const employeeFilter = document.getElementById('employeeFilter');
    const typeFilter = document.getElementById('typeFilter');
    const statusFilter = document.getElementById('statusFilter');
    const applyFiltersBtn = document.getElementById('applyFilters');
    const resetFiltersBtn = document.getElementById('resetFilters');

    function applyFilters() {
        let url = new URL(window.location.href);
        url.search = '';

        if (searchInput.value) url.searchParams.append('search', searchInput.value);
        if (employeeFilter.value) url.searchParams.append('employee_id', employeeFilter.value);
        if (typeFilter.value) url.searchParams.append('type', typeFilter.value);
        if (statusFilter.value) url.searchParams.append('status', statusFilter.value);

        window.location.href = url.toString();
    }

    function resetFilters() {
        searchInput.value = '';
        employeeFilter.value = '';
        typeFilter.value = '';
        statusFilter.value = '';
        window.location.href = window.location.pathname + '?page=1';
    }

    applyFiltersBtn.addEventListener('click', applyFilters);
    resetFiltersBtn.addEventListener('click', resetFilters);

    const urlParams = new URLSearchParams(window.location.search);
    searchInput.value = urlParams.get('search') || '';
    employeeFilter.value = urlParams.get('employee_id') || '';
    typeFilter.value = urlParams.get('type') || '';
    statusFilter.value = urlParams.get('status') || '';
});
</script>
@endsection