@extends('layouts.app')

@section('content')
<div class="container">
    <h3 class="mb-4">{{ __('deductions.form.edit_title') }}</h3>

    <form action="{{ route('deductions.update', $deduction->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="row">
            <!-- الموظف -->
            <div class="col-md-6 mb-3">
                <label for="employee_id" class="form-label">{{ __('deductions.form.label_employee') }} <span class="text-danger">*</span></label>
                <select name="employee_id" id="employee_id" class="form-select select2" required>
                    <option value="">{{ __('app.select_placeholder') ?? 'اختر الموظف' }}</option>
                    @foreach($employees as $employee)
                        <option value="{{ $employee->id }}" {{ old('employee_id', $deduction->employee_id) == $employee->id ? 'selected' : '' }}>
                            {{ $employee->name }} - {{ $employee->employee_id }}
                        </option>
                    @endforeach
                </select>
                @error('employee_id')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror
            </div>

            <!-- نوع الاستقطاع (`type`) -->
            <div class="col-md-6 mb-3">
                <label for="type" class="form-label">{{ __('deductions.form.label_type') }} <span class="text-danger">*</span></label>
                <select name="type" id="type" class="form-select" required>
                    <option value="">{{ __('app.select_placeholder') ?? 'اختر النوع' }}</option>
                    @foreach(__('deductions.type_labels') as $key => $label)
                        <option value="{{ $key }}" {{ old('type', $deduction->type) == $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                @error('type')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror
            </div>
        </div>

        <div class="row">
            <!-- طريقة الاستقطاع محذوفة (تم إلغاؤها) -->

            <!-- التكرار (`frequency`) -->
            <div class="col-md-6 mb-3">
                <label for="frequency" class="form-label">{{ __('deductions.form.label_frequency') }} <span class="text-danger">*</span></label>
                <select name="frequency" id="frequency" class="form-select" required>
                    <option value="">{{ __('app.select_placeholder') ?? 'اختر التكرار' }}</option>
                    @php $freqOptions = ['once','monthly','yearly']; $current = old('frequency', $deduction->frequency ?? ($deduction->is_monthly ? 'monthly' : 'once')); @endphp
                    @foreach($freqOptions as $key)
                        <option value="{{ $key }}" {{ $current == $key ? 'selected' : '' }}>{{ __('deductions.frequency.' . $key) }}</option>
                    @endforeach
                </select>
                @error('frequency')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror
            </div>
        </div>

        <div class="row">
            <!-- المبلغ -->
            <div class="col-md-6 mb-3">
                <label for="amount" class="form-label">{{ __('deductions.form.label_amount') }} <span class="text-danger">*</span></label>
                <div class="input-group">
                    <input type="number" step="0.01" name="amount" id="amount" class="form-control" value="{{ old('amount', $deduction->amount) }}" min="0.01" max="100000" required>
                    <span class="input-group-text">{{ $currency_name ?? 'د.ك' }}</span>
                </div>
                @error('amount')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror
            </div>

            <!-- تاريخ الاستقطاع -->
            <div class="col-md-6 mb-3">
                <label for="deduction_date" class="form-label">{{ __('deductions.form.label_deduction_date') }} <span class="text-danger">*</span></label>
                <input type="date" name="deduction_date" id="deduction_date" class="form-control" value="{{ old('deduction_date', $deduction->deduction_date ? $deduction->deduction_date->format('Y-m-d') : '') }}" required placeholder="{{ __('deductions.date_placeholder') }}">
                @error('deduction_date')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror
            </div>
        </div>

        <!-- الوصف -->
        <div class="mb-3">
            <label for="description" class="form-label">{{ __('deductions.form.label_description') }}</label>
            <textarea name="description" id="description" class="form-control" rows="2">{{ old('description', $deduction->description) }}</textarea>
            @error('description')
                <div class="text-danger mt-1">{{ $message }}</div>
            @enderror
        </div>

        <!-- ملاحظات إضافية -->
        <div class="mb-3">
            <label for="notes" class="form-label">{{ __('deductions.form.label_notes') }}</label>
            <textarea name="notes" id="notes" class="form-control" rows="2">{{ old('notes', $deduction->notes) }}</textarea>
            @error('notes')
                <div class="text-danger mt-1">{{ $message }}</div>
            @enderror
        </div>

        <div class="row">
            <!-- تاريخ الانتهاء -->
            <div class="col-md-6 mb-3">
                <label for="end_date" class="form-label">{{ __('deductions.form.label_end_date') }}</label>
                <input type="date" name="end_date" id="end_date" class="form-control" value="{{ old('end_date', $deduction->end_date ? $deduction->end_date->format('Y-m-d') : null) }}" min="{{ old('deduction_date', $deduction->deduction_date->format('Y-m-d')) }}" placeholder="{{ __('deductions.date_placeholder') }}">
                @error('end_date')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror
            </div>

            <!-- الحالة -->
            <div class="col-md-6 mb-3">
                <label for="status" class="form-label">{{ __('deductions.form.label_status') }} <span class="text-danger">*</span></label>
                <select name="status" id="status" class="form-select" required>
                    @foreach(__('deductions.status') as $key => $label)
                        <option value="{{ $key }}" {{ old('status', $deduction->status) == $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                @error('status')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror
            </div>
        </div>

        <!-- زر الحفظ -->
        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-warning" id="submitBtn">
                <i class="fas fa-save"></i> {{ __('deductions.form.button_update') }}
            </button>
            <a href="{{ route('deductions.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> {{ __('deductions.form.button_back') }}
            </a>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<!-- يمكن إضافة تهيئة select2 هنا إذا كانت المكتبة مثبتة -->
<script>
    // مثال على تهيئة select2 (إذا كنت تستخدمها)
    // $(document).ready(function() {
    //     $('.select2').select2();
    // });
</script>
@endpush