@extends('layouts.app')

@section('content')
<div class="container">
    <h3 class="mb-4 text-center">{{ __('deductions.form.create_title') }}</h3>

    <!-- ✅ عرض الأخطاء إن وجدت -->
    @if ($errors->any())
        <div class="alert alert-danger">
            <strong>حدثت بعض الأخطاء:</strong>
            <ul class="mb-0 mt-2">
                @foreach ($errors->all() as $error)
                    <li>⚠️ {{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- ✅ عرض رسالة النجاح -->
    @if (session('success'))
        <div class="alert alert-success text-center">
            {{ session('success') }}
        </div>
    @endif

    <!-- ✅ نموذج إضافة الاستقطاع -->
    <form action="{{ route('deductions.store') }}" method="POST" autocomplete="off">
        @csrf

        <div class="row">
            <!-- الموظف -->
            <div class="col-md-6 mb-3">
                <label for="employee_id" class="form-label">{{ __('deductions.form.label_employee') }} <span class="text-danger">*</span></label>
                <select name="employee_id" id="employee_id" class="form-select select2" required>
                    <option value="">{{ __('app.select_placeholder') ?? 'اختر الموظف' }}</option>
                    @foreach($employees as $employee)
                        <option value="{{ $employee->id }}" {{ old('employee_id') == $employee->id ? 'selected' : '' }}>
                            {{ $employee->name }} - {{ $employee->employee_id }}
                        </option>
                    @endforeach
                </select>
                @error('employee_id')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror
            </div>

            <!-- نوع الاستقطاع -->
            <div class="col-md-6 mb-3">
                <label for="deduction_type" class="form-label">{{ __('deductions.form.label_type') }} <span class="text-danger">*</span></label>
                <select name="deduction_type" id="deduction_type" class="form-select" required>
                    <option value="">{{ __('app.select_placeholder') ?? 'اختر النوع' }}</option>
                    @foreach(__('deductions.type_labels') as $key => $label)
                        <option value="{{ $key }}" {{ old('deduction_type') == $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                @error('deduction_type')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror
            </div>
        </div>

        <div class="row">
            <!-- التكرار -->
            <div class="col-md-6 mb-3">
                <label for="frequency" class="form-label">{{ __('deductions.form.label_frequency') }} <span class="text-danger">*</span></label>
                <select name="frequency" id="frequency" class="form-select" required>
                    <option value="">{{ __('app.select_placeholder') ?? 'اختر التكرار' }}</option>
                    @php $freqOptions = ['once','monthly','yearly']; @endphp
                    @foreach($freqOptions as $key)
                        <option value="{{ $key }}" {{ old('frequency') == $key ? 'selected' : '' }}>{{ __('deductions.frequency.' . $key) }}</option>
                    @endforeach
                </select>
                @error('frequency')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror
            </div>

            <!-- المبلغ -->
            <div class="col-md-6 mb-3">
                <label for="amount" class="form-label">{{ __('deductions.form.label_amount') }} <span class="text-danger">*</span></label>
                <div class="input-group">
                    <input type="number" step="0.01" name="amount" id="amount" class="form-control" 
                           value="{{ old('amount') }}" min="0.01" required>
                    <span class="input-group-text">{{ $currency_name ?? 'د.ك' }}</span>
                </div>
                @error('amount')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror
            </div>
        </div>

        <div class="row">
            <!-- تاريخ الاستقطاع -->
            <div class="col-md-6 mb-3">
                <label for="deduction_date" class="form-label">{{ __('deductions.form.label_deduction_date') }} <span class="text-danger">*</span></label>
                <input type="date" name="deduction_date" id="deduction_date" class="form-control"
                       value="{{ old('deduction_date', now()->format('Y-m-d')) }}" required>
                @error('deduction_date')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror
            </div>

            <!-- الوصف -->
            <div class="col-md-6 mb-3">
                <label for="description" class="form-label">{{ __('deductions.form.label_description') }}</label>
                <textarea name="description" id="description" class="form-control" rows="2">{{ old('description') }}</textarea>
                @error('description')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror
            </div>
        </div>

        <!-- ملاحظات -->
        <div class="mb-3">
            <label for="notes" class="form-label">{{ __('deductions.form.label_notes') }}</label>
            <textarea name="notes" id="notes" class="form-control" rows="2">{{ old('notes') }}</textarea>
            @error('notes')
                <div class="text-danger mt-1">{{ $message }}</div>
            @enderror
        </div>

        <div class="row">
            <!-- تاريخ الانتهاء -->
            <div class="col-md-6 mb-3">
                <label for="end_date" class="form-label">{{ __('deductions.form.label_end_date') }}</label>
                <input type="date" name="end_date" id="end_date" class="form-control"
                       value="{{ old('end_date') }}" placeholder="{{ __('deductions.date_placeholder') }}">
                @error('end_date')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror
            </div>

            <!-- الحالة -->
            <div class="col-md-6 mb-3">
                <label for="status" class="form-label">{{ __('deductions.form.label_status') }} <span class="text-danger">*</span></label>
                <select name="status" id="status" class="form-select" required>
                    @foreach(__('deductions.status') as $key => $label)
                        <option value="{{ $key }}" {{ old('status', 'pending') == $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                @error('status')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror
            </div>
        </div>

        <!-- طريقة الاستقطاع محذوفة (تم إلغاؤها) -->

        <!-- زر الحفظ -->
        <div class="d-flex justify-content-center gap-2">
            <button type="submit" class="btn btn-success px-4">
                <i class="fas fa-save"></i> {{ __('deductions.form.button_save') }}
            </button>
            <a href="{{ route('deductions.index') }}" class="btn btn-secondary px-4">
                <i class="fas fa-arrow-left"></i> {{ __('deductions.form.button_back') }}
            </a>
        </div>
    </form>
</div>
@endsection