{{-- resources/views/dashboard/index.blade.php --}}
@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('app.dashboard') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('dashboard.breadcrumb_home') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('app.dashboard') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
<div class="row mb-4">
    <div class="col-md-12">
        <a href="{{ route('employees.create') }}" class="btn btn-primary me-2"><i class="fas fa-user-plus me-1"></i> {{ __('app.add') }} {{ __('app.employee') }}</a>
        <a href="{{ route('payroll.create') }}" class="btn btn-success me-2"><i class="fas fa-file-invoice-dollar me-1"></i> {{ __('app.add') }} {{ __('app.payroll') }}</a>
        <a href="{{ route('leaves.create') }}" class="btn btn-info me-2"><i class="fas fa-plane me-1"></i> {{ __('app.add') }} {{ __('app.leaves') }}</a>
        <a href="{{ route('loans.create') }}" class="btn btn-warning me-2"><i class="fas fa-money-bill-wave me-1"></i> {{ __('app.add') }} {{ __('app.loans') }}</a>
        <!-- ✅ إضافة زر "إضافة استقطاع" -->
        <a href="{{ route('deductions.create') }}" class="btn btn-danger me-2"><i class="fas fa-minus-circle me-1"></i> {{ __('app.add') }} {{ __('app.deductions') }}</a>
    </div>
</div>
            <input type="text" id="globalSearch" class="form-control" placeholder="{{ __('dashboard.search_placeholder') }}" value="{{ request('search') ?? request('q') ?? '' }}">
            @if(!empty($searchQuery ?? null))
                <div class="mt-3">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">{{ __('dashboard.search_results_for') }} "{{ $searchQuery }}"</h5>

                            @php $any = false; @endphp

                            @if(!empty($searchResults['employees'] ?? null) && $searchResults['employees']->count())
                                @php $any = true; @endphp
                                <h6>{{ __('dashboard.search_employees') }}</h6>
                                <ul>
                                    @foreach($searchResults['employees'] as $emp)
                                        <li><a href="{{ route('employees.show', $emp) }}">{{ $emp->name }} @if($emp->id) (ID: {{ $emp->id }}) @endif</a></li>
                                    @endforeach
                                </ul>
                            @endif

                            @if(!empty($searchResults['activities'] ?? null) && $searchResults['activities']->count())
                                @php $any = true; @endphp
                                <h6 class="mt-2">{{ __('dashboard.search_activities') }}</h6>
                                <ul>
                                    @foreach($searchResults['activities'] as $act)
                                        <li>{{ $act->created_at->format('Y-m-d H:i') }} — {{ __('activity.' . $act->description) ?? $act->description }} — {{ $act->user?->name ?? '—' }}</li>
                                    @endforeach
                                </ul>
                            @endif

                            @if(!empty($searchResults['notifications'] ?? null) && $searchResults['notifications']->count())
                                @php $any = true; @endphp
                                <h6 class="mt-2">{{ __('dashboard.search_notifications') }}</h6>
                                <ul>
                                    @foreach($searchResults['notifications'] as $n)
                                        @php $data = json_decode($n->data, true); @endphp
                                        <li>{{ $n->created_at }} — {{ $data['title'] ?? Str::limit($data['message'] ?? '', 60) }}</li>
                                    @endforeach
                                </ul>
                            @endif

                            @if(!empty($searchResults['attendances'] ?? null) && $searchResults['attendances']->count())
                                @php $any = true; @endphp
                                <h6 class="mt-2">{{ __('dashboard.search_attendances') }}</h6>
                                <ul>
                                    @foreach($searchResults['attendances'] as $a)
                                        <li>{{ $a->date->format('Y-m-d') }} — {{ $a->employee?->name ?? '—' }} — {{ $a->status }}</li>
                                    @endforeach
                                </ul>
                            @endif

                            @if(!empty($searchResults['departments'] ?? null) && $searchResults['departments']->count())
                                @php $any = true; @endphp
                                <h6 class="mt-2">{{ __('dashboard.search_departments') }}</h6>
                                <ul>
                                    @foreach($searchResults['departments'] as $d)
                                        <li><a href="{{ route('departments.show', $d) }}">{{ $d->name }}</a></li>
                                    @endforeach
                                </ul>
                            @endif

                            @if(!empty($searchResults['positions'] ?? null) && $searchResults['positions']->count())
                                @php $any = true; @endphp
                                <h6 class="mt-2">{{ __('dashboard.search_positions') }}</h6>
                                <ul>
                                    @foreach($searchResults['positions'] as $p)
                                        <li><a href="{{ route('positions.show', $p) }}">{{ $p->name }}</a></li>
                                    @endforeach
                                </ul>
                            @endif
                            @if(!empty($searchResults['payrolls'] ?? null) && $searchResults['payrolls']->count())
                                @php $any = true; @endphp
                                <h6 class="mt-2">{{ __('dashboard.search_payrolls') }}</h6>
                                <ul>
                                    @foreach($searchResults['payrolls'] as $p)
                                        <li>
                                            <a href="{{ route('payroll.show', $p) }}">{{ $p->employee->name ?? '—' }} — {{ \Carbon\Carbon::create()->month($p->month)->translatedFormat('F') }} {{ $p->year }} — {{ number_format($p->net_salary,2) }}</a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif

                            @if(!empty($searchResults['leaves'] ?? null) && $searchResults['leaves']->count())
                                @php $any = true; @endphp
                                <h6 class="mt-2">{{ __('app.leaves') }}</h6>
                                <ul>
                                    @foreach($searchResults['leaves'] as $l)
                                        <li><a href="{{ route('leaves.show', $l) }}">{{ $l->employee->name ?? '—' }}: {{ $l->start_date->format('Y-m-d') }} {{ __('app.to') }} {{ $l->end_date->format('Y-m-d') }}</a></li>
                                    @endforeach
                                </ul>
                            @endif

                            @if(!empty($searchResults['deductions'] ?? null) && $searchResults['deductions']->count())
                                @php $any = true; @endphp
                                <h6 class="mt-2">{{ __('app.deductions') }}</h6>
                                <ul>
                                    @foreach($searchResults['deductions'] as $d)
                                        <li><a href="{{ route('deductions.show', $d) }}">{{ $d->employee->name ?? '—' }} — {{ number_format($d->amount,2) }}</a></li>
                                    @endforeach
                                </ul>
                            @endif

                            @if(!empty($searchResults['loans'] ?? null) && $searchResults['loans']->count())
                                @php $any = true; @endphp
                                <h6 class="mt-2">{{ __('app.loans') }}</h6>
                                <ul>
                                    @foreach($searchResults['loans'] as $ln)
                                        <li><a href="{{ route('loans.show', $ln) }}">{{ $ln->employee->name ?? '—' }} — {{ number_format($ln->amount,2) }}</a></li>
                                    @endforeach
                                </ul>
                            @endif

                            @unless($any)
                                <p class="text-muted">{{ __('app.no_data_found') }}</p>
                            @endunless
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row">
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('app.total') }} {{ __('app.employees') }}</p>
                            <h4 class="mb-0">{{ $stats['total_employees'] ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-users fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('app.attendance') }} - {{ __('app.today') }}</p>
                            <h4 class="mb-0">{{ $presentToday ?? 0 }}</h4>
                            <small class="text-white">{{ $attendanceRate ?? 0 }}%</small>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-clock fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('app.attendance_status.late') }} - {{ __('app.today') }}</p>
                            <h4 class="mb-0">{{ $lateToday ?? 0 }}</h4>
                            <small class="text-white">{{ $lateRate ?? 0 }}%</small>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-hourglass-half fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('app.attendance_status.absent') }} - {{ __('app.today') }}</p>
                            <h4 class="mb-0">{{ $absentToday ?? 0 }}</h4>
                            <small class="text-white">{{ $absentRate ?? 0 }}%</small>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-user-times fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

                       






    <!-- Charts & Activities -->
    <div class="row mt-4">
        <!-- Attendance Chart -->
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">{{ __('app.attendance_stats') }}</h5>
                    <span>{{ __('app.average_checkin_time') }}: <strong>{{ $averageCheckInTime ?? '00:00' }}</strong></span>
                </div>
                <div class="card-body">
                    <canvas id="attendanceChart" height="200"></canvas>
                </div>
            </div>
        </div>

        <!-- Recent Activities -->
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">{{ __('app.recent_activities') }}</h5>
                </div>
                <div class="card-body">
                    @forelse($recentActivities ?? [] as $activity)
                    <div class="d-flex align-items-start border-bottom pb-3 mb-3">
                        <div class="flex-grow-1 ms-3">
                            <h6 class="mb-1">
                                @php
                                    $activityProps = $activity->properties ?? [];
                                    if (is_string($activityProps)) {
                                        $decoded = json_decode($activityProps, true);
                                        $activityProps = is_array($decoded) ? $decoded : [];
                                    } elseif (!is_array($activityProps)) {
                                        $activityProps = (array) $activityProps;
                                    }
                                @endphp
                                {{ __('activity.' . $activity->description, $activityProps) }}
                            </h6>
                            <p class="mb-0 text-muted">
                                {{ __('dashboard.by') }}: <strong>{{ $activity->user?->name ?? __('dashboard.system_fallback_name') }}</strong>
                            </p>
                            <small class="text-dark">{{ $activity->created_at->translatedFormat('d F Y H:i') }}</small>
                        </div>
                    </div>
                    @empty
                    <div class="text-center text-muted py-4">
                        <i class="fas fa-history fa-2x mb-2"></i>
                        <p class="mb-0">{{ __('app.no_recent_activities') }}</p>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Payrolls & Leaves -->
<div class="row mt-4">
    <!-- Recent Payrolls -->
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">{{ __('app.recent_payrolls') }}</h5>
                <a href="{{ route('payroll.index') }}" class="btn btn-sm btn-outline-primary">{{ __('app.view_all') }}</a>
            </div>
            <div class="card-body">
                @if($recentPayrolls && $recentPayrolls->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>{{ __('dashboard.th_employee') }}</th>
                                    <th>{{ __('dashboard.th_net_salary') }}</th>
                                    <th>{{ __('dashboard.th_month') }}</th>
                                    <th>{{ __('dashboard.th_status') }}</th>
                                    <th>{{ __('dashboard.th_actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($recentPayrolls as $payroll)
                                <tr>
                                    <td>{{ $payroll->employee->name }}</td>
                                    <td>{{ number_format($payroll->net_salary, 2) }} {{ $currency_name ?? 'د.ك' }}</td>
                                    <td>{{ \Carbon\Carbon::create()->month($payroll->month)->translatedFormat('F') }} {{ $payroll->year }}</td>
                                        <td>
                                            @switch($payroll->status)
                                                @case('paid')
                                                    <span class="badge bg-success">{{ __('dashboard.paid') }}</span>
                                                    @break
                                                @case('pending')
                                                    <span class="badge bg-warning text-dark">{{ __('dashboard.pending_payment') }}</span>
                                                    @break
                                                @default
                                                    <span class="badge bg-secondary">{{ $payroll->status }}</span>
                                            @endswitch
                                        </td>
                                    <td>
                                        <a href="{{ route('payroll.show', $payroll) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <p class="text-muted text-center py-3">{{ __('app.no_recent_payrolls') }}</p>
                @endif
            </div>
        </div>
    </div>

    <!-- Recent Leaves -->
<div class="col-lg-6">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="card-title mb-0">{{ __('app.recent_leaves') }}</h5>
            <a href="{{ route('leaves.index') }}" class="btn btn-sm btn-outline-primary">{{ __('app.view_all') }}</a>
        </div>
        <div class="card-body">
            @if($recentLeaves && $recentLeaves->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                            <thead>
                            <tr>
                                <th>{{ __('dashboard.th_employee') }}</th>
                                <th>{{ __('dashboard.th_leave_type') }}</th>
                                <th>{{ __('dashboard.th_period') }}</th>
                                <th>{{ __('dashboard.th_status') }}</th>
                                <th>{{ __('dashboard.th_actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($recentLeaves as $leave)
                            <tr>
                                <td>{{ $leave->employee->name }}</td>
                                <td>
                                    @php
                                        $leaveTypes = [
                                            'annual' => __('dashboard.leave_type_annual'),
                                            'sick' => __('dashboard.leave_type_sick'),
                                            'emergency' => __('dashboard.leave_type_emergency'),
                                            'maternity' => __('dashboard.leave_type_maternity'),
                                            'paternity' => __('dashboard.leave_type_paternity'),
                                            'unpaid' => __('dashboard.leave_type_unpaid'),
                                        ];
                                    @endphp
                                    {{ $leaveTypes[$leave->leave_type] ?? $leave->leave_type }}
                                </td>
                                <td>{{ $leave->start_date->format('Y-m-d') }} {{ __('app.to') }} {{ $leave->end_date->format('Y-m-d') }}</td>
                                <td>
                                    @switch($leave->status)
                                        @case('approved')
                                            <span class="badge bg-success">{{ __('dashboard.leave_status_approved') }}</span>
                                            @break
                                        @case('pending')
                                            <span class="badge bg-warning text-dark">{{ __('dashboard.leave_status_pending') }}</span>
                                            @break
                                        @case('rejected')
                                            <span class="badge bg-danger">{{ __('dashboard.leave_status_rejected') }}</span>
                                            @break
                                        @default
                                            <span class="badge bg-secondary">{{ $leave->status }}</span>
                                    @endswitch
                                </td>
                                <td>
                                    <a href="{{ route('leaves.show', $leave) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="text-muted text-center py-3">{{ __('app.no_recent_leaves') }}</p>
            @endif
        </div>
    </div>
</div>

    <!-- Recent Deductions & Loans -->
    <div class="row mt-4">
        <!-- Recent Deductions -->
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">{{ __('app.recent_deductions') }}</h5>
                    <a href="{{ route('deductions.index') }}" class="btn btn-sm btn-outline-primary">{{ __('app.view_all') }}</a>
                </div>
                <div class="card-body">
                    @if($recentDeductions && $recentDeductions->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>{{ __('dashboard.th_employee') }}</th>
                                        <th>{{ __('dashboard.th_type') }}</th>
                                        <th>{{ __('dashboard.th_amount') }}</th>
                                        <th>{{ __('dashboard.th_date') }}</th>
                                        <th>{{ __('dashboard.th_status') }}</th>
                                        <th>{{ __('dashboard.th_actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($recentDeductions as $deduction)
                                    <tr>
                                        <td>{{ $deduction->employee->name }}</td>
                                        @php
                                            // Robust extraction of deduction type for translation lookup
                                            $rawType = $deduction->type ?? null;
                                            $rawString = '';

                                            if (is_array($rawType)) {
                                                $rawString = $rawType['slug'] ?? $rawType['code'] ?? $rawType['name'] ?? ($rawType['type'] ?? json_encode($rawType));
                                            } elseif (is_object($rawType)) {
                                                $rawArr = (array) $rawType;
                                                $rawString = $rawArr['slug'] ?? $rawArr['code'] ?? $rawArr['name'] ?? ($rawArr['type'] ?? json_encode($rawArr));
                                            } else {
                                                $rawString = is_string($rawType) ? $rawType : '';
                                            }

                                            // normalize to slug: lowercase, replace non-alnum with underscore
                                            $slug = trim(strtolower((string) $rawString));
                                            $slug = preg_replace('/[^a-z0-9]+/i', '_', $slug);
                                            $slug = trim($slug, '_');

                                            // try multiple candidate slugs (handle variants like 'in_kind_deduction', 'deduction_cash')
                                            $candidates = [$slug];
                                            if ($slug) {
                                                $candidates[] = preg_replace('/_?deduction$/', '', $slug);
                                                $candidates[] = preg_replace('/^deduction_?/', '', $slug);
                                                $candidates[] = preg_replace('/_?type$/', '', $slug);
                                            }
                                            $candidates = array_values(array_filter(array_unique($candidates)));

                                            $deductionTypeLabel = null;
                                            foreach ($candidates as $candidate) {
                                                $key = 'dashboard.deduction_type_' . ($candidate ?: 'other');
                                                $val = __($key);
                                                if ($val !== $key) {
                                                    $deductionTypeLabel = $val;
                                                    break;
                                                }
                                            }

                                            if (!$deductionTypeLabel) {
                                                // Try to match the raw string against translation VALUES (covers cases where DB stores Arabic text like 'خصومات')
                                                try {
                                                    $all = trans('dashboard');
                                                    foreach($all as $tkey => $tval) {
                                                        if (is_string($tval) && mb_strtolower(trim($tval)) == mb_strtolower(trim($rawString))) {
                                                            if (str_starts_with($tkey, 'deduction_type_')) {
                                                                $deductionTypeLabel = $tval;
                                                                break;
                                                            }
                                                        }
                                                    }
                                                } catch (\Throwable $e) {
                                                    // ignore and fallback
                                                }

                                                if (!$deductionTypeLabel) {
                                                    // fallback to provided Arabic label or raw string, else generic 'Other'
                                                    $deductionTypeLabel = $deduction->type_arabic ?? ($rawString ?: __('dashboard.deduction_type_other'));
                                                }
                                            }
                                        @endphp
                                        <td>{{ $deductionTypeLabel }}</td>
                                        <td>{{ number_format($deduction->amount, 2) }} {{ get_currency_code() }}</td>
                                        <td>{{ $deduction->deduction_date->format('Y-m-d') }}</td>
                                        <td>
                                            @switch($deduction->status)
                                                @case('applied')
                                                    <span class="badge bg-success">{{ __('dashboard.deduction_status_applied') }}</span>
                                                    @break
                                                @case('pending')
                                                    <span class="badge bg-warning text-dark">{{ __('dashboard.deduction_status_pending') }}</span>
                                                    @break
                                                @case('cancelled')
                                                    <span class="badge bg-secondary">{{ __('dashboard.deduction_status_cancelled') }}</span>
                                                    @break
                                                @default
                                                    <span class="badge bg-dark">{{ __('dashboard.status_unknown') }}</span>
                                            @endswitch
                                        </td>
                                        <td>
                                            <a href="{{ route('deductions.show', $deduction) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-muted text-center py-3">{{ __('app.no_recent_deductions') }}</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Recent Loans -->
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header d-flex justify-content بين align-items-center">
                    <h5 class="card-title mb-0">{{ __('app.recent_loans') }}</h5>
                    <a href="{{ route('loans.index') }}" class="btn btn-sm btn-outline-primary">{{ __('app.view_all') }}</a>
                </div>
                <div class="card-body">
                    @if($recentLoans && $recentLoans->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>{{ __('dashboard.th_employee') }}</th>
                                        <th>{{ __('dashboard.th_type') }}</th>
                                        <th>{{ __('dashboard.th_amount') }}</th>
                                        <th>{{ __('dashboard.th_date') }}</th>
                                        <th>{{ __('dashboard.th_status') }}</th>
                                        <th>{{ __('dashboard.th_actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($recentLoans as $loan)
                                    <tr>
                                        <td>{{ $loan->employee->name }}</td>
                                        @php
                                            $loanTypeKey = 'dashboard.loan_type_' . ($loan->loan_type ?? '');
                                            $loanTypeLabel = __($loanTypeKey);
                                            if ($loanTypeLabel === $loanTypeKey) {
                                                $loanTypeLabel = $loan->loan_type_arabic ?? $loan->loan_type;
                                            }
                                        @endphp
                                        <td>{{ $loanTypeLabel }}</td>
                                        <td>{{ number_format($loan->amount, 2) }} {{ get_currency_code() }}</td>
                                        <td>{{ $loan->created_at->format('Y-m-d') }}</td>
                                        <td>
                                            @switch($loan->status)
                                                @case('pending')
                                                    <span class="badge bg-warning text-dark">{{ __('dashboard.loan_status_pending') }}</span>
                                                    @break
                                                @case('approved')
                                                    <span class="badge bg-success">{{ __('dashboard.loan_status_approved') }}</span>
                                                    @break
                                                @case('active')
                                                    <span class="badge bg-info">{{ __('dashboard.loan_status_active') }}</span>
                                                    @break
                                                @case('completed')
                                                    <span class="badge bg-secondary">{{ __('dashboard.loan_status_completed') }}</span>
                                                    @break
                                                @case('cancelled')
                                                    <span class="badge bg-danger">{{ __('dashboard.loan_status_cancelled') }}</span>
                                                    @break
                                                @default
                                                    <span class="badge bg-dark">{{ __('dashboard.status_unknown') }}</span>
                                            @endswitch
                                        </td>
                                        <td>
                                            <a href="{{ route('loans.show', $loan) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-muted text-center py-3">{{ __('app.no_recent_loans') }}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Notifications Section -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">{{ __('app.notifications') }}</h5>
                    <div class="btn-group">
                        <button type="button" class="btn btn-outline-secondary btn-sm" id="markAllAsReadDashboard">
                            <i class="fas fa-check-double me-1"></i> {{ __('app.mark_all_as_read') }}
                        </button>
                        <button type="button" class="btn btn-outline-danger btn-sm" id="clearAllNotificationsDashboard">
                            <i class="fas fa-trash-alt me-1"></i> {{ __('app.clear_all_notifications') }}
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{ __('dashboard.th_title') }}</th>
                                    <th>{{ __('dashboard.th_description') }}</th>
                                    <th>{{ __('dashboard.th_sender') }}</th>
                                    <th>{{ __('dashboard.th_date') }}</th>
                                    <th>{{ __('dashboard.th_status') }}</th>
                                    <th>{{ __('dashboard.th_actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($notifications ?? [] as $notification)
                                <tr class="{{ $notification->read_at ? '' : 'table-warning' }}">
                                    <td>{{ $loop->iteration }}</td>
                                    <td><strong>{{ $notification->data['title'] ?? __('app.notification_new_default_title') }}</strong></td>
                                    <td>{{ Str::limit($notification->data['message'] ?? __('app.notification_details_default'), 80) }}</td>
                                        <td>
                                        @if(isset($notification->data['sender']) && $notification->data['sender'] == 'system')
                                            <span style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; font-weight: bold;">
                                                 {{ __('dashboard.system_name') }}
                                            </span>
                                        @else
                                            {{ $notification->notifiable?->name ?? __('dashboard.system_fallback_name') }}
                                        @endif
                                        </td>
                                    <td>{{ $notification->created_at->diffForHumans() }}</td>
                                    <td>
                                        @if($notification->read_at)
                                            <span class="badge bg-success">{{ __('app.notification_read') }}</span>
                                        @else
                                            <span class="badge bg-warning text-dark">{{ __('app.notification_unread') }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            @if(!$notification->read_at)
                                                <button class="btn btn-sm btn-outline-primary mark-as-read" data-id="{{ $notification->id }}">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            @endif
                                            <a href="{{ $notification->data['url'] ?? '#' }}" class="btn btn-sm btn-outline-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <button class="btn btn-sm btn-outline-danger delete-notification" data-id="{{ $notification->id }}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center text-muted py-4">
                                        <i class="fas fa-bell-slash fa-3x mb-3"></i><br>
                                        {{ __('app.no_notifications') }}
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if(isset($notifications) && $notifications->hasPages())
                    <div class="d-flex justify-content-center mt-4">
                        {{ $notifications->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Chart JS -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Translated strings used in JS
        const t_notification_read = '{{ addslashes(__('app.notification_read')) }}';
        const t_confirm_mark_all_read = '{{ addslashes(__('dashboard.confirm_mark_all_read')) }}';
        const t_confirm_clear_all = '{{ addslashes(__('dashboard.confirm_clear_all')) }}';
        const t_confirm_delete_notification = '{{ addslashes(__('dashboard.confirm_delete_notification')) }}';
        const t_error_connection = '{{ addslashes(__('dashboard.error_connection')) }}';
        const t_error_update_notifications = '{{ addslashes(__('dashboard.error_update_notifications')) }}';
        // Initialize Attendance Chart only if canvas exists and data is available
        const attendanceCanvas = document.getElementById('attendanceChart');
        if (attendanceCanvas) {
            const present = {{ $presentToday ?? 0 }};
            const late = {{ $lateToday ?? 0 }};
            const absent = {{ $absentToday ?? 0 }};

            const ctx = attendanceCanvas.getContext('2d');
            const attendanceChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: ['{{ __('dashboard.present') }}', '{{ __('dashboard.late') }}', '{{ __('dashboard.absent') }}'],
                    datasets: [{
                        label: '{{ __('dashboard.attendance_rate') }}',
                        data: [present, late, absent],
                        backgroundColor: [
                            'rgba(40, 167, 69, 0.8)', // Green for Present
                            'rgba(255, 193, 7, 0.8)',  // Yellow for Late
                            'rgba(220, 53, 69, 0.8)'  // Red for Absent
                        ],
                        borderColor: [
                            'rgba(40, 167, 69, 1)',
                            'rgba(255, 193, 7, 1)',
                            'rgba(220, 53, 69, 1)'
                        ],
                        borderWidth: 2
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'bottom'
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    const label = context.label || '';
                                    const value = context.raw || 0;
                                    const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                    const percentage = total > 0 ? ((value / total) * 100).toFixed(1) : '0.0';
                                    return `${label}: ${value} (${percentage}%)`;
                                }
                            }
                        }
                    }
                }
            });
        } else {
            console.warn('Attendance chart canvas not found or data unavailable.');
        }

        // Global Search (debounced) — navigate after user stops typing or presses Enter
        const globalSearch = document.getElementById('globalSearch');
        if (globalSearch) {
            let _searchTimer = null;
            const navigateWithQuery = (q) => {
                const query = (q || '').toString().trim();
                if (query.length === 0) return; // don't navigate for empty

                // avoid reloading if the same search is already in the URL
                const params = new URLSearchParams(window.location.search);
                if (params.get('search') === query || params.get('q') === query) return;

                // navigate directly to dashboard.index with 'search' param (avoid extra redirect)
                window.location.href = `{{ route('dashboard.index') }}?search=${encodeURIComponent(query)}`;
            };

            globalSearch.addEventListener('input', function () {
                clearTimeout(_searchTimer);
                const current = this.value;
                // Wait 650ms after typing stops before navigating
                _searchTimer = setTimeout(() => navigateWithQuery(current), 650);
            });

            // If user presses Enter, navigate immediately
            globalSearch.addEventListener('keydown', function (e) {
                if (e.key === 'Enter') {
                    e.preventDefault();
                    clearTimeout(_searchTimer);
                    navigateWithQuery(this.value);
                }
            });
        }

        // Mark All As Read (Dashboard)
        const markAllBtn = document.getElementById('markAllAsReadDashboard');
        if (markAllBtn) {
            markAllBtn.addEventListener('click', function(e) {
                e.preventDefault();
                if (confirm(t_confirm_mark_all_read)) {
                    fetch("{{ route('notifications.read-all') }}", {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                             alert(t_error_update_notifications);
                        }
                    })
                    .catch(error => {
                        console.error('Error marking all as read:', error);
                        alert(t_error_connection);
                    });
                }
            });
        }

        // Clear All Notifications (Dashboard)
        const clearAllBtn = document.getElementById('clearAllNotificationsDashboard');
        if (clearAllBtn) {
            clearAllBtn.addEventListener('click', function(e) {
                e.preventDefault();
                if (confirm(t_confirm_clear_all)) {
                    fetch("{{ route('notifications.clear-all') }}", {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                             alert(t_error_update_notifications);
                        }
                    })
                    .catch(error => {
                        console.error('Error clearing all notifications:', error);
                        alert(t_error_connection);
                    });
                }
            });
        }

        // Mark Single Notification as Read (Dashboard)
        document.querySelectorAll('.mark-as-read').forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                const notificationId = this.getAttribute('data-id');
                if (notificationId) {
                    fetch(`/notifications/${notificationId}/read`, {
                        method: 'PATCH',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            const row = this.closest('tr');
                            row.classList.remove('table-warning');
                            const statusCell = row.querySelector('td:nth-child(6)');
                            if (statusCell) {
                                statusCell.innerHTML = `<span class="badge bg-success">${t_notification_read}</span>`;
                            }
                            this.remove();
                        } else {
                            alert(t_error_update_notifications);
                        }
                    })
                    .catch(error => {
                        console.error('Error marking notification as read:', error);
                        alert(t_error_connection);
                    });
                }
            });
        });

        // Delete Single Notification (Dashboard)
        document.querySelectorAll('.delete-notification').forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                const notificationId = this.getAttribute('data-id');
                if (notificationId && confirm(t_confirm_delete_notification)) {
                    fetch(`/notifications/${notificationId}`, {
                        method: 'DELETE',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        }
                    })
                    .then(response => response.json())
                        .then(data => {
                        if (data.success) {
                            const row = this.closest('tr');
                            if (row) row.remove();

                            // Check if table is empty after deletion
                            const tableBody = document.querySelector('tbody');
                            if (tableBody && tableBody.children.length === 0) {
                                tableBody.innerHTML = `
                                    <tr>
                                        <td colspan="7" class="text-center text-muted py-4">
                                            <i class="fas fa-bell-slash fa-3x mb-3"></i><br>
                                            {{ __('app.no_notifications') }}
                                        </td>
                                    </tr>
                                `;
                            }
                        } else {
                            alert(t_error_update_notifications);
                        }
                    })
                    .catch(error => {
                        console.error('Error deleting notification:', error);
                        alert(t_error_connection);
                    });
                }
            });
        });
    });
</script>
@endsection