{{-- resources/views/contact.blade.php --}}
@extends('layouts.login')

@section('title', __('custom.contact_title') . ' - ' . __('app.app_name'))
@section('form_title', __('custom.contact_title'))

@section('content')
<div class="container">
    <div class="row g-0">
        <!-- Left Column: Contact Info -->
        <div class="col-lg-6 d-flex flex-column justify-content-center align-items-center p-4 p-md-5 bg-light">
            <div class="text-center mb-4">
                <i class="fas fa-headset fa-3x text-primary mb-3"></i>
                <h2 class="fw-bold">{{ __('custom.contact_title') }}</h2>
                <p class="text-muted">{{ __('custom.contact_subtitle') }}</p>
            </div>

            <!-- Primary CTA Button -->
            <a href="{{ route('login') }}" class="btn btn-primary btn-lg w-100 mb-4">
                <i class="fas fa-arrow-left me-2"></i> {{ __('custom.back_to_login') }}
            </a>

            <!-- Contact Cards -->
            <div class="d-flex flex-column gap-3 w-100 mt-4">
                <!-- WhatsApp -->
                <div class="card h-100 shadow-sm border-0">
                    <div class="card-body d-flex align-items-center">
                        <div class="me-3">
                            <a href="https://wa.me/201098723512" target="_blank" class="text-decoration-none">
                                <i class="fab fa-whatsapp fa-2x text-success"></i>
                            </a>
                        </div>
                        <div>
                            <h6 class="mb-1 fw-bold">{{ __('custom.contact_whatsapp') }}</h6>
                            <p class="mb-0">
                                <a href="https://wa.me/201098723512" target="_blank" class="text-dark text-decoration-none">
                                    <i class="fab fa-whatsapp me-1 text-success"></i> +20 109 872 3512
                                </a>
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Email -->
                <div class="card h-100 shadow-sm border-0">
                    <div class="card-body d-flex align-items-center">
                        <div class="me-3">
                            <a href="mailto:admin@company.com" class="text-decoration-none">
                                <i class="fas fa-envelope fa-2x text-danger"></i>
                            </a>
                        </div>
                        <div>
                            <h6 class="mb-1 fw-bold">{{ __('custom.contact_email') }}</h6>
                            <p class="mb-0">
                                <a href="mailto:admin@company.com" class="text-dark text-decoration-none">
                                    <i class="fas fa-envelope me-1 text-danger"></i> admin@company.com
                                </a>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Working Hours -->
                <div class="alert alert-light border border-info mt-4 w-100 rounded-3">
                <i class="fas fa-clock text-info me-2"></i>
                <strong>{{ __('custom.working_hours_label') }}</strong><br>
                <small class="text-muted">{{ __('custom.working_hours_text') }}</small>
            </div>
        </div>

        <!-- Right Column: Value Proposition -->
        <div class="col-lg-6 d-flex flex-column justify-content-center p-4 p-md-5 position-relative" 
             style="background: linear-gradient(135deg, #00c6ff, #0072ff); color: white;">
                <div class="text-center">
                <h2 class="fw-bold mb-4">{{ __('custom.value_proposition.title') }}</h2>
                <p class="mb-4 opacity-90">{{ __('custom.value_proposition.desc') }}</p>

                <ul class="list-unstyled text-start mx-auto" style="max-width: 400px;">
                    <li class="mb-2 d-flex align-items-start">
                        <i class="fas fa-check-circle text-success mt-1 me-2"></i>
                        <span>{{ __('custom.features.multilang') }}</span>
                    </li>
                    <li class="mb-2 d-flex align-items-start">
                        <i class="fas fa-check-circle text-success mt-1 me-2"></i>
                        <span>{{ __('custom.features.support') }}</span>
                    </li>
                    <li class="mb-2 d-flex align-items-start">
                        <i class="fas fa-check-circle text-success mt-1 me-2"></i>
                        <span>{{ __('custom.features.reports') }}</span>
                    </li>
                    <li class="mb-2 d-flex align-items-start">
                        <i class="fas fa-check-circle text-success mt-1 me-2"></i>
                        <span>{{ __('custom.features.trial') }}</span>
                    </li>
                </ul>
            </div>

            <!-- Secondary CTA -->
            <div class="w-100 mt-4">
                <a href="{{ route('login') }}" 
                   class="btn btn-light btn-lg w-100 py-3 rounded-3 fw-bold"
                   style="color: #0072ff; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
                    <i class="fas fa-comments me-2"></i> {{ __('custom.start_now') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .btn-primary {
        background: linear-gradient(135deg, #00c6ff, #0072ff);
        border: none;
        padding: 15px;
        border-radius: 12px;
        color: white;
        font-weight: 600;
        font-size: 1.1rem;
        transition: all 0.3s;
    }
    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px rgba(0, 198, 255, 0.3);
    }
    .btn-light:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.12);
        color: #0056b3;
    }
    .card {
        border-radius: 12px;
        transition: all 0.25s;
    }
    .card:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 15px rgba(0,0,0,0.08);
    }
</style>
@endpush