<div class="employee-search-component">
    <div class="input-group">
        <span class="input-group-text bg-primary text-white">
            <i class="fas fa-user"></i>
        </span>
        <input type="text" 
               class="form-control form-control-lg" 
               id="{{ $id }}" 
               name="{{ $name }}"
               placeholder="{{ $placeholder ?? 'ابحث عن موظف...' }}"
               {{ $required ? 'required' : '' }}
               readonly
               style="cursor: pointer; background-color: #f8f9fa;">
        <input type="hidden" id="{{ $id }}_id" name="{{ $name }}_id">
        <button class="btn btn-primary" type="button" data-bs-toggle="modal" data-bs-target="#employeeSearchModal">
            <i class="fas fa-search me-1"></i> بحث
        </button>
    </div>
    
    <div class="selected-employee-info mt-2" id="selectedEmployeeInfo" style="display: none;">
        <div class="alert alert-success alert-dismissible fade show mb-0" role="alert">
            <div class="d-flex align-items-center">
                <div class="avatar-sm bg-success rounded-circle d-flex align-items-center justify-content-center me-2">
                    <i class="fas fa-user-check text-white"></i>
                </div>
                <div>
                    <strong>الموظف المحدد:</strong> 
                    <span id="selectedEmployeeName"></span>
                    <span id="selectedEmployeeDetails" class="text-muted small"></span>
                </div>
            </div>
            <button type="button" class="btn-close" onclick="clearSelectedEmployee()"></button>
        </div>
    </div>
    
    <div class="modal fade" id="employeeSearchModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-users me-2"></i>
                        البحث عن موظف
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                
                <div class="modal-body">
                    <!-- Search Controls -->
                    <div class="row mb-4">
                        <div class="col-md-8">
                            <div class="input-group">
                                <span class="input-group-text bg-light">
                                    <i class="fas fa-search"></i>
                                </span>
                                <input type="text" 
                                       id="employeeSearchInput" 
                                       class="form-control form-control-lg" 
                                       placeholder="ابحث بالاسم أو الرقم الوظيفي أو البريد الإلكتروني...">
                                <button class="btn btn-outline-secondary" type="button" id="clearSearch">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <select class="form-select form-select-lg" id="departmentFilter">
                                <option value="">جميع الأقسام</option>
                                <option value="HR">الموارد البشرية</option>
                                <option value="IT">تقنية المعلومات</option>
                                <option value="Finance">المالية</option>
                                <option value="Marketing">التسويق</option>
                                <option value="Operations">العمليات</option>
                            </select>
                        </div>
                    </div>
                    
                    <!-- Filters and Stats -->
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-outline-primary btn-sm" id="filterActive">
                                <i class="fas fa-user-check me-1"></i> نشط
                            </button>
                            <button type="button" class="btn btn-outline-warning btn-sm" id="filterPending">
                                <i class="fas fa-user-clock me-1"></i> قيد التوظيف
                            </button>
                            <button type="button" class="btn btn-outline-secondary btn-sm" id="filterAll">
                                <i class="fas fa-users me-1"></i> الكل
                            </button>
                        </div>
                        
                        <div class="text-muted">
                            <span id="searchResultsCount">0</span> موظف موجود
                        </div>
                    </div>
                    
                    <!-- Loading Indicator -->
                    <div id="employeeSearchLoading" class="text-center py-5" style="display: none;">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">جاري التحميل...</span>
                        </div>
                        <p class="mt-2 text-muted">جاري البحث عن الموظفين...</p>
                    </div>
                    
                    <!-- Error Message -->
                    <div id="employeeSearchError" class="alert alert-danger text-center" style="display: none;">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <span id="errorMessage">حدث خطأ أثناء البحث</span>
                    </div>
                    
                    <!-- Results Table -->
                    <div class="table-responsive" id="employeeSearchResultsContainer" style="display: none;">
                        <table class="table table-hover table-bordered align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th width="50" class="text-center">#</th>
                                    <th>الصورة</th>
                                    <th>الاسم الكامل</th>
                                    <th>الرقم الوظيفي</th>
                                    <th>الوظيفة</th>
                                    <th>القسم</th>
                                    <th>الحالة</th>
                                    <th width="120" class="text-center">الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody id="employeeSearchResults">
                                <!-- سيتم تحميل النتائج عبر Ajax -->
                            </tbody>
                        </table>
                        
                        <!-- Pagination -->
                        <nav aria-label="Page navigation" class="mt-4">
                            <ul class="pagination justify-content-center" id="paginationContainer">
                                <!-- سيتم تحميل الترقيم عبر Ajax -->
                            </ul>
                        </nav>
                    </div>
                    
                    <!-- Empty State -->
                    <div id="employeeSearchEmpty" class="text-center py-5" style="display: none;">
                        <i class="fas fa-users fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">لا توجد نتائج بحث</h5>
                        <p class="text-muted">جرب تعديل معايير البحث</p>
                    </div>
                </div>
                
                <div class="modal-footer bg-light">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-1"></i> إغلاق
                    </button>
                    <button type="button" class="btn btn-outline-primary" id="refreshSearch">
                        <i class="fas fa-sync-alt me-1"></i> تحديث
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.employee-search-component .input-group-text {
    border: none;
}

.employee-search-component .form-control:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
}

.employee-search-component .btn-primary {
    border: none;
    box-shadow: 0 2px 4px rgba(102, 126, 234, 0.3);
}

.employee-search-component .btn-primary:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(102, 126, 234, 0.4);
}

.modal-content {
    border-radius: 15px;
    overflow: hidden;
}

.table-hover tbody tr:hover {
    background-color: rgba(102, 126, 234, 0.05);
    transform: scale(1.01);
    transition: all 0.2s;
}

.avatar-sm {
    width: 40px;
    height: 40px;
    font-size: 0.9rem;
}

.badge-status {
    font-size: 0.75rem;
    padding: 0.4em 0.6em;
}

.pagination .page-link {
    border-radius: 8px !important;
    margin: 0 2px;
    border: 1px solid #dee2e6;
}

.pagination .page-item.active .page-link {
    background-color: #667eea;
    border-color: #667eea;
}

/* Animation */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.fade-in {
    animation: fadeIn 0.3s ease-out;
}

/* Responsive */
@media (max-width: 768px) {
    .modal-dialog {
        margin: 10px;
    }
    
    .table-responsive {
        font-size: 0.85rem;
    }
    
    .btn-group {
        flex-wrap: wrap;
    }
}
</style>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    let searchTimeout;
    let currentQuery = '';
    let currentDepartment = '';
    let currentStatus = 'all';
    let currentPage = 1;
    
    // Search functionality
    const searchInput = document.getElementById('employeeSearchInput');
    const departmentFilter = document.getElementById('departmentFilter');
    const clearSearch = document.getElementById('clearSearch');
    const refreshSearch = document.getElementById('refreshSearch');
    
    // Filter buttons
    const filterActive = document.getElementById('filterActive');
    const filterPending = document.getElementById('filterPending');
    const filterAll = document.getElementById('filterAll');
    
    // Result containers
    const loadingContainer = document.getElementById('employeeSearchLoading');
    const errorContainer = document.getElementById('employeeSearchError');
    const resultsContainer = document.getElementById('employeeSearchResultsContainer');
    const emptyContainer = document.getElementById('employeeSearchEmpty');
    const resultsCount = document.getElementById('searchResultsCount');
    
    // Event listeners
    searchInput.addEventListener('input', function() {
        currentQuery = this.value;
        currentPage = 1;
        performSearch();
    });
    
    departmentFilter.addEventListener('change', function() {
        currentDepartment = this.value;
        currentPage = 1;
        performSearch();
    });
    
    clearSearch.addEventListener('click', function() {
        searchInput.value = '';
        currentQuery = '';
        currentPage = 1;
        performSearch();
    });
    
    refreshSearch.addEventListener('click', function() {
        performSearch();
    });
    
    // Filter buttons
    filterActive.addEventListener('click', function() {
        currentStatus = 'active';
        currentPage = 1;
        performSearch();
        setActiveFilter(this);
    });
    
    filterPending.addEventListener('click', function() {
        currentStatus = 'pending';
        currentPage = 1;
        performSearch();
        setActiveFilter(this);
    });
    
    filterAll.addEventListener('click', function() {
        currentStatus = 'all';
        currentPage = 1;
        performSearch();
        setActiveFilter(this);
    });
    
    function setActiveFilter(activeButton) {
        // Remove active class from all buttons
        document.querySelectorAll('.btn-group .btn').forEach(btn => {
            btn.classList.remove('active');
        });
        // Add active class to clicked button
        activeButton.classList.add('active');
    }
    
    // Set default active filter
    filterAll.classList.add('active');
    
    function performSearch() {
        clearTimeout(searchTimeout);
        
        if (currentQuery.length >= 2 || currentDepartment || currentStatus !== 'all') {
            showLoading();
            
            searchTimeout = setTimeout(function() {
                fetchSearchResults();
            }, 500);
        } else {
            hideAllContainers();
            emptyContainer.style.display = 'block';
        }
    }
    
    function fetchSearchResults() {
        const params = new URLSearchParams({
            search: currentQuery,
            department: currentDepartment,
            status: currentStatus,
            page: currentPage
        });
        
        fetch(`{{ route("employees.search") }}?${params}`)
            .then(response => response.json())
            .then(data => {
                displayResults(data);
            })
            .catch(error => {
                showError('حدث خطأ أثناء البحث. يرجى المحاولة مرة أخرى.');
            });
    }
    
    function displayResults(data) {
        hideAllContainers();
        
        if (data.data && data.data.length > 0) {
            let html = '';
            data.data.forEach(function(employee, index) {
                const globalIndex = (data.current_page - 1) * data.per_page + index + 1;
                
                html += `
                    <tr class="fade-in">
                        <td class="text-center">${globalIndex}</td>
                        <td>
                            ${employee.photo ? 
                                `<img src="/storage/${employee.photo}" alt="صورة الموظف" class="rounded-circle" width="40" height="40">` :
                                `<div class="avatar-sm bg-primary rounded-circle d-flex align-items-center justify-content-center">
                                    <span class="text-white">${employee.name.charAt(0)}</span>
                                </div>`
                            }
                        </td>
                        <td>
                            <div class="fw-bold">${employee.name}</div>
                            <div class="small text-muted">${employee.email || 'لا يوجد بريد'}</div>
                        </td>
                        <td>
                            <span class="badge bg-primary">${employee.employee_id || 'غير متوفر'}</span>
                        </td>
                        <td>${employee.position || 'غير محدد'}</td>
                        <td>
                            <span class="badge bg-info">${employee.department || 'غير محدد'}</span>
                        </td>
                        <td>
                            ${employee.status === 'active' ? 
                                '<span class="badge bg-success badge-status">نشط</span>' :
                                employee.status === 'pending' ? 
                                '<span class="badge bg-warning badge-status">قيد التوظيف</span>' :
                                '<span class="badge bg-secondary badge-status">غير نشط</span>'
                            }
                        </td>
                        <td class="text-center">
                            <button class="btn btn-sm btn-success select-employee" 
                                    data-id="${employee.id}" 
                                    data-name="${employee.name}"
                                    data-position="${employee.position || ''}"
                                    data-department="${employee.department || ''}">
                                <i class="fas fa-check"></i> اختيار
                            </button>
                        </td>
                    </tr>
                `;
            });
            
            document.getElementById('employeeSearchResults').innerHTML = html;
            resultsContainer.style.display = 'block';
            resultsCount.textContent = data.total;
            
            // Setup pagination
            setupPagination(data);
        } else {
            emptyContainer.style.display = 'block';
            resultsCount.textContent = '0';
        }
    }
    
    function setupPagination(data) {
        const paginationContainer = document.getElementById('paginationContainer');
        let paginationHtml = '';
        
        // Previous button
        if (data.prev_page_url) {
            paginationHtml += `
                <li class="page-item">
                    <a class="page-link" href="#" data-page="${data.current_page - 1}">
                        <i class="fas fa-chevron-right"></i>
                    </a>
                </li>
            `;
        }
        
        // Page numbers
        for (let i = Math.max(1, data.current_page - 2); i <= Math.min(data.last_page, data.current_page + 2); i++) {
            paginationHtml += `
                <li class="page-item ${i === data.current_page ? 'active' : ''}">
                    <a class="page-link" href="#" data-page="${i}">${i}</a>
                </li>
            `;
        }
        
        // Next button
        if (data.next_page_url) {
            paginationHtml += `
                <li class="page-item">
                    <a class="page-link" href="#" data-page="${data.current_page + 1}">
                        <i class="fas fa-chevron-left"></i>
                    </a>
                </li>
            `;
        }
        
        paginationContainer.innerHTML = paginationHtml;
        
        // Add event listeners to pagination links
        paginationContainer.querySelectorAll('a').forEach(link => {
            link.addEventListener('click', function(e) {
                e.preventDefault();
                currentPage = parseInt(this.getAttribute('data-page'));
                performSearch();
            });
        });
    }
    
    function showLoading() {
        hideAllContainers();
        loadingContainer.style.display = 'block';
    }
    
    function showError(message) {
        hideAllContainers();
        document.getElementById('errorMessage').textContent = message;
        errorContainer.style.display = 'block';
    }
    
    function hideAllContainers() {
        loadingContainer.style.display = 'none';
        errorContainer.style.display = 'none';
        resultsContainer.style.display = 'none';
        emptyContainer.style.display = 'none';
    }
    
    // Select employee functionality
    document.addEventListener('click', function(e) {
        if (e.target.closest('.select-employee')) {
            const button = e.target.closest('.select-employee');
            const employeeId = button.getAttribute('data-id');
            const employeeName = button.getAttribute('data-name');
            const employeePosition = button.getAttribute('data-position');
            const employeeDepartment = button.getAttribute('data-department');
            
            // Set the selected employee in the main input
            document.getElementById('{{ $id }}').value = employeeName;
            document.getElementById('{{ $id }}_id').value = employeeId;
            
            // Show selected employee info
            document.getElementById('selectedEmployeeName').textContent = employeeName;
            document.getElementById('selectedEmployeeDetails').textContent = 
                ` - ${employeePosition || ''} ${employeeDepartment ? `(${employeeDepartment})` : ''}`;
            document.getElementById('selectedEmployeeInfo').style.display = 'block';
            
            // Call custom callback if defined
            if (typeof window.onEmployeeSelected === 'function') {
                window.onEmployeeSelected(employeeId, employeeName, {
                    position: employeePosition,
                    department: employeeDepartment
                });
            }
            
            // Close modal
            const modal = bootstrap.Modal.getInstance(document.getElementById('employeeSearchModal'));
            modal.hide();
            
            // Clear search
            searchInput.value = '';
            currentQuery = '';
        }
    });
    
    // Clear selected employee
    window.clearSelectedEmployee = function() {
        document.getElementById('{{ $id }}').value = '';
        document.getElementById('{{ $id }}_id').value = '';
        document.getElementById('selectedEmployeeInfo').style.display = 'none';
        
        if (typeof window.onEmployeeCleared === 'function') {
            window.onEmployeeCleared();
        }
    };
    
    // Initialize with some results if needed
    // performSearch();
});
</script>
@endpush