<li class="nav-item dropdown">
    <a class="nav-link dropdown-toggle d-flex align-items-center" data-bs-toggle="dropdown" href="#" role="button">
        <div class="position-relative">
            <i class="fas fa-bell fa-lg"></i>
            @if($count > 0)
            <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                {{ $count }}
                <span class="visually-hidden">إشعارات غير مقروءة</span>
            </span>
            @endif
        </div>
    </a>
    
    <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow shadow-lg mt-2" style="min-width: 300px;">
        <!-- Header -->
        <div class="dropdown-header bg-light rounded-top">
            <div class="d-flex justify-content-between align-items-center">
                <span class="fw-bold">
                    @if($count > 0)
                        <i class="fas fa-bell text-warning me-2"></i>
                        لديك {{ $count }} إشعار{{ $count == 1 ? '' : 'ات' }}
                    @else
                        <i class="fas fa-bell-slash text-muted me-2"></i>
                        لا توجد إشعارات
                    @endif
                </span>
                @if($count > 0)
                <a href="{{ route('notifications.read-all') }}" 
                   class="btn btn-sm btn-outline-primary py-0" 
                   title="تعليم الكل كمقروء">
                    <i class="fas fa-check-double"></i>
                </a>
                @endif
            </div>
        </div>
        
        <div class="dropdown-divider my-0"></div>
        
        <!-- Notifications List -->
        <div class="notifications-list" style="max-height: 300px; overflow-y: auto;">
            @if($count > 0)
                @foreach($recentNotifications as $notification)
                <a href="{{ $notification->data['url'] ?? '#' }}" 
                   class="dropdown-item d-flex align-items-start py-2 border-bottom {{ $notification->read_at ? 'read' : 'unread bg-light' }}">
                    <div class="me-3">
                        @if(isset($notification->data['type']))
                            @switch($notification->data['type'])
                                @case('leave')
                                    <div class="avatar-sm bg-warning rounded-circle d-flex align-items-center justify-content-center">
                                        <i class="fas fa-umbrella-beach text-white"></i>
                                    </div>
                                    @break
                                @case('loan')
                                    <div class="avatar-sm bg-info rounded-circle d-flex align-items-center justify-content-center">
                                        <i class="fas fa-credit-card text-white"></i>
                                    </div>
                                    @break
                                @case('payroll')
                                    <div class="avatar-sm bg-success rounded-circle d-flex align-items-center justify-content-center">
                                        <i class="fas fa-money-bill-wave text-white"></i>
                                    </div>
                                    @break
                                @case('attendance')
                                    <div class="avatar-sm bg-primary rounded-circle d-flex align-items-center justify-content-center">
                                        <i class="fas fa-clock text-white"></i>
                                    </div>
                                    @break
                                @case('employee')
                                    <div class="avatar-sm bg-secondary rounded-circle d-flex align-items-center justify-content-center">
                                        <i class="fas fa-user text-white"></i>
                                    </div>
                                    @break
                                @default
                                    <div class="avatar-sm bg-dark rounded-circle d-flex align-items-center justify-content-center">
                                        <i class="fas fa-bell text-white"></i>
                                    </div>
                            @endswitch
                        @else
                            <div class="avatar-sm bg-secondary rounded-circle d-flex align-items-center justify-content-center">
                                <i class="fas fa-bell text-white"></i>
                            </div>
                        @endif
                    </div>
                    
                    <div class="flex-grow-1">
                        <div class="d-flex justify-content-between align-items-center">
                            <h6 class="mb-1 small fw-bold">
                                {{ $notification->data['title'] ?? 'إشعار جديد' }}
                            </h6>
                            @if(!$notification->read_at)
                                <span class="badge bg-danger rounded-pill" style="font-size: 0.6rem;">جديد</span>
                            @endif
                        </div>
                        <p class="mb-1 small text-muted">
                            {{ Str::limit($notification->data['message'] ?? 'لديك إشعار جديد', 50) }}
                        </p>
                        <small class="text-muted">
                            <i class="fas fa-clock me-1"></i>
                            {{ $notification->created_at->diffForHumans() }}
                        </small>
                    </div>
                </a>
                @endforeach
            @else
                <div class="dropdown-item-text text-center py-4">
                    <i class="fas fa-bell-slash fa-2x text-muted mb-2"></i>
                    <p class="mb-0 text-muted">لا توجد إشعارات حالياً</p>
                    <small class="text-muted">ستظهر الإشعارات هنا عند توفرها</small>
                </div>
            @endif
        </div>
        
        <div class="dropdown-divider my-0"></div>
        
        <!-- Footer Actions -->
        <div class="dropdown-footer bg-light rounded-bottom p-2">
            <div class="d-grid gap-2">
                <a href="{{ route('notifications.index') }}" class="btn btn-primary btn-sm">
                    <i class="fas fa-list me-1"></i>
                    عرض جميع الإشعارات
                </a>
                <div class="d-flex gap-2">
                    <a href="{{ route('notifications.settings') }}" class="btn btn-outline-secondary btn-sm flex-fill">
                        <i class="fas fa-cog"></i>
                    </a>
                    @if($count > 0)
                    <a href="{{ route('notifications.read-all') }}" 
                       class="btn btn-outline-danger btn-sm flex-fill"
                       onclick="return confirm('{{ addslashes(__('app.confirm_clear_all_notifications')) }}')">
                        <i class="fas fa-trash"></i>
                    </a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</li>

<style>
.dropdown-menu-arrow {
    border: none;
    border-radius: 10px;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
}

.dropdown-menu-arrow::before {
    content: '';
    position: absolute;
    top: -8px;
    right: 20px;
    border-left: 8px solid transparent;
    border-right: 8px solid transparent;
    border-bottom: 8px solid white;
}

.notifications-list .dropdown-item {
    transition: all 0.2s;
    border-radius: 0;
}

.notifications-list .dropdown-item:hover {
    background-color: rgba(102, 126, 234, 0.1);
    transform: translateX(-3px);
}

.notifications-list .dropdown-item.unread {
    border-right: 3px solid #667eea;
}

.notifications-list .dropdown-item.read {
    opacity: 0.8;
}

.avatar-sm {
    width: 36px;
    height: 36px;
    font-size: 0.8rem;
}

.dropdown-header {
    padding: 0.75rem 1rem;
}

.dropdown-footer {
    padding: 0.75rem;
}

/* Scrollbar styling */
.notifications-list::-webkit-scrollbar {
    width: 6px;
}

.notifications-list::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 10px;
}

.notifications-list::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 10px;
}

.notifications-list::-webkit-scrollbar-thumb:hover {
    background: #a8a8a8;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add hover effect to notification items
    const notificationItems = document.querySelectorAll('.notifications-list .dropdown-item');
    notificationItems.forEach(item => {
        item.addEventListener('mouseenter', function() {
            this.style.transform = 'translateX(-3px)';
        });
        
        item.addEventListener('mouseleave', function() {
            this.style.transform = 'translateX(0)';
        });
    });
    
    // Auto hide dropdown when clicking outside
    document.addEventListener('click', function(event) {
        const dropdown = document.querySelector('.nav-item.dropdown');
        if (!dropdown.contains(event.target)) {
            const bsDropdown = bootstrap.Dropdown.getInstance(dropdown.querySelector('[data-bs-toggle="dropdown"]'));
            if (bsDropdown) {
                bsDropdown.hide();
            }
        }
    });
});
</script>