@extends('layouts.auth')

@section('title', 'إنشاء حساب جديد - نظام إدارة الموارد البشرية نواتِك')

@section('welcome_title', 'مرحباً بك!')
@section('welcome_text', 'نظام إدارة الموارد البشرية نواتِك المتكامل يوفر لك جميع الأدوات اللازمة لإدارة الموظفين والحضور والإجازات والرواتب بكفاءة عالية.')
@section('form_title', 'إنشاء حساب جديد')

@section('content')
    <!-- Display Errors -->
    @if($errors->any())
        <div class="alert alert-danger animate-fade-in">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    
    @if(session('error'))
        <div class="alert alert-danger animate-fade-in">
            {{ session('error') }}
        </div>
    @endif
    
    @if(session('success'))
        <div class="alert alert-success animate-fade-in">
            {{ session('success') }}
        </div>
    @endif

    <form method="POST" action="{{ route('register') }}" class="login-form animate-fade-in animate-delay-1 needs-validation" novalidate>
        @csrf
        
        <div class="form-group">
            <div class="input-group">
                <span class="input-group-text bg-transparent border-0">
                    <i class="fas fa-user"></i>
                </span>
                <input id="name" type="text"
                    class="form-control @error('name') is-invalid @enderror"
                    name="name" value="{{ old('name') }}" required
                    placeholder="الاسم الكامل" autocomplete="name">
            </div>
             @error('name')
                <div class="invalid-feedback d-block">{{ $message }}</div>
            @enderror
        </div>
        
        <div class="form-group">
            <div class="input-group">
                <span class="input-group-text bg-transparent border-0">
                    <i class="fas fa-envelope"></i>
                </span>
                <input id="email" type="email"
                    class="form-control @error('email') is-invalid @enderror"
                    name="email" value="{{ old('email') }}" required
                    placeholder="البريد الإلكتروني" autocomplete="email">
            </div>
             @error('email')
                <div class="invalid-feedback d-block">{{ $message }}</div>
            @enderror
        </div>
        
        <div class="form-group">
            <div class="input-group">
                <span class="input-group-text bg-transparent border-0">
                    <i class="fas fa-lock"></i>
                </span>
                <input id="password" type="password"
                    class="form-control @error('password') is-invalid @enderror"
                    name="password" required
                    placeholder="كلمة المرور">
            </div>
             @error('password')
                <div class="invalid-feedback d-block">{{ $message }}</div>
            @enderror
        </div>
        
        <div class="form-group">
            <div class="input-group">
                <span class="input-group-text bg-transparent border-0">
                    <i class="fas fa-lock"></i>
                </span>
                <input id="password-confirm" type="password"
                    class="form-control"
                    name="password_confirmation" required
                    placeholder="تأكيد كلمة المرور">
            </div>
        </div>
        
        <button type="submit" class="btn btn-login w-100 animate-fade-in animate-delay-3">
            <i class="fas fa-user-plus me-2"></i>
            إنشاء الحساب
        </button>
    </form>
    
    <div class="divider animate-fade-in animate-delay-3">
        <span>أو استمر مع</span>
    </div>
    
    <div class="social-login animate-fade-in animate-delay-3">
        <button class="social-btn btn-google">
            <i class="fab fa-google"></i>
        </button>
        <button class="social-btn btn-facebook">
            <i class="fab fa-facebook-f"></i>
        </button>
        <button class="social-btn btn-twitter">
            <i class="fab fa-twitter"></i>
        </button>
    </div>
    
    <div class="signup-link animate-fade-in animate-delay-3">
        <p>لديك حساب بالفعل؟ <a href="{{ route('login') }}">تسجيل الدخول</a></p>
    </div>
@endsection