{{-- resources/views/auth/login.blade.php --}}
@extends('layouts.login')

@section('title', __('app.login') . ' - ' . __('app.app_name'))
@section('form_title', __('custom.login_prompt'))

@section('content')
<div class="container">
    <div class="row g-0">
        <!-- Left Column: Login Form -->
        <div class="col-lg-6 d-flex flex-column justify-content-center p-4 p-md-5" style="background-color: #f8f9fa;">
            <div class="text-center mb-4">
                <!-- ✅ شعار صغير بجانب الاسم -->
                <div class="d-flex justify-content-center align-items-center mb-3">
                    <img src="{{ asset('images/codehorizon-bg.png') }}" alt="{{ __('app.app_name') }}"
                         class="me-3" style="height: 48px; width: auto; object-fit: contain;">
                    <h2 class="fw-bold m-0" style="color: #0072ff;">{{ __('app.app_name') }}</h2>
                </div>
                <p class="text-muted">{{ __('custom.login_prompt') }}</p>
            </div>

            <form method="POST" action="{{ route('login') }}" id="loginForm" class="w-100">
                @csrf

                <div class="mb-3">
                    <label for="email" class="form-label">{{ __('app.email') }}</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                           <input id="email" type="email" class="form-control @error('email') is-invalid @enderror"
                               name="email" value="{{ old('email') }}" required autocomplete="email"
                               autofocus placeholder="{{ __('custom.email_placeholder') }}">
                    </div>
                    @error('email')
                        <div class="invalid-feedback d-block mt-1">
                            <strong>{{ $message }}</strong>
                        </div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="password" class="form-label">{{ __('custom.password_label') }}</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-lock"></i></span>
                           <input id="password" type="password" class="form-control @error('password') is-invalid @enderror"
                               name="password" required autocomplete="current-password" placeholder="{{ __('custom.password_placeholder') }}">
                        <button type="button" class="btn btn-outline-secondary" id="togglePassword">
                            <i class="fas fa-eye-slash" id="eyeIcon"></i>
                        </button>
                    </div>
                    @error('password')
                        <div class="invalid-feedback d-block mt-1">
                            <strong>{{ $message }}</strong>
                        </div>
                    @enderror
                </div>

                <div class="mb-3 form-check">
                    <input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                    <label class="form-check-label" for="remember">
                        {{ __('custom.remember') }}
                    </label>
                </div>

                <div class="d-grid gap-2 mb-3">
                    <button type="submit" class="btn btn-login">
                        <i class="fas fa-sign-in-alt me-2"></i> {{ __('app.login') }}
                    </button>
                </div>

                <div class="text-center mb-4">
                    <a href="{{ route('password.request') }}" class="text-decoration-none text-primary">
                        {{ __('custom.forgot_password') }}
                    </a>
                </div>

                <!-- Trigger Button for Quick Login Modal -->
                <div class="text-center mb-4">
                    <button type="button" class="btn btn-primary btn-lg" id="showPasswordModal" title="{{ __('custom.demo_version') }}" style="font-size: 1.5rem; width: 50px; height: 50px; padding: 0; display: inline-flex; align-items: center; justify-content: center;">
                        <i class="fas fa-home"></i>
                    </button>
                </div>

                <!-- Brand + Tagline -->
                <div class="text-center mb-5">
                    <img src="{{ asset('images/codehorizon-bg.png') }}" alt="{{ __('app.app_name') }}"
                         class="me-3" style="height: 48px; width: auto; object-fit: contain;">
                    <h2 class="fw-bold m-0" style="color: #0072ff;">{{ __('app.app_name') }}</h2>
                    <p class="text-muted">{{ __('custom.tagline') }}</p>
                </div>
            </form>
        </div>

        <!-- Right Column: Features -->
        <div class="col-lg-6 d-flex flex-column justify-content-center p-5"
             style="background: linear-gradient(135deg, #00c6ff, #0072ff); color: white; padding: 3rem 2rem;">
            <!-- ✅ شعار كبير في الأعلى (مركز مع تعديلات احترافية) -->
            <div class="text-center mb-5">
                    <img src="{{ asset('images/codehorizon-bg.png') }}" alt="{{ __('app.app_name') }}"
                     style="height: 80px; width: auto; filter: drop-shadow(0 4px 8px rgba(0,0,0,0.2)); opacity: 0.95;">
            </div>

            <div class="text-center text-white w-100">
                <h3 class="fw-bold mb-4">{{ __('custom.tagline') }}</h3>

                <div class="features-list text-start mx-auto" style="max-width: 480px; font-size: 0.95rem; line-height: 1.6;">
                    <div class="d-flex align-items-start mb-3">
                        <i class="fas fa-users-cog text-success me-3 mt-1" style="font-size: 1.2rem;"></i>
                        <div>
                            <strong style="font-weight: 600; font-size: 1.05rem;">{{ __('custom.features.management_title') }}</strong>
                            <div class="text-white opacity-80 small">{{ __('custom.features.management_desc') }}</div>
                        </div>
                    </div>

                    <div class="d-flex align-items-start mb-3">
                        <i class="fas fa-clock text-info me-3 mt-1" style="font-size: 1.2rem;"></i>
                        <div>
                            <strong style="font-weight: 600; font-size: 1.05rem;">{{ __('custom.features.attendance_title') }}</strong>
                            <div class="text-white opacity-80 small">{{ __('custom.features.attendance_desc') }}</div>
                        </div>
                    </div>

                    <div class="d-flex align-items-start mb-3">
                        <i class="fas fa-umbrella-beach text-warning me-3 mt-1" style="font-size: 1.2rem;"></i>
                        <div>
                            <strong style="font-weight: 600; font-size: 1.05rem;">{{ __('custom.features.leaves_title') }}</strong>
                            <div class="text-white opacity-80 small">{{ __('custom.features.leaves_desc') }}</div>
                        </div>
                    </div>

                    <div class="d-flex align-items-start mb-3">
                        <i class="fas fa-money-bill-wave text-primary me-3 mt-1" style="font-size: 1.2rem;"></i>
                        <div>
                            <strong style="font-weight: 600; font-size: 1.05rem;">{{ __('custom.features.payroll_title') }}</strong>
                            <div class="text-white opacity-80 small">{{ __('custom.features.payroll_desc') }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Password Modal -->
<div class="modal fade" id="passwordModal" tabindex="-1" aria-labelledby="passwordModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="passwordModalLabel">{{ __('custom.quick_login_title') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="accessPassword" class="form-label">{{ __('custom.quick_login_password_label') }}</label>
                    <input type="password" class="form-control" id="accessPassword" placeholder="{{ __('custom.quick_login_password_placeholder') }}">
                    <div id="passwordError" class="text-danger mt-2" style="display: none;">{{ __('custom.quick_login_invalid') }}</div>
                </div>
                <button type="button" class="btn btn-primary w-100" id="verifyPassword">{{ __('custom.verify_password_button') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Quick Login Modal -->
<div class="modal fade" id="quickLoginModal" tabindex="-1" aria-labelledby="quickLoginModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="quickLoginModalLabel">{{ __('custom.quick_login_modal_title') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- Quick Login Form -->
                <form method="POST" action="{{ route('login') }}" id="quickLoginForm" class="w-100">
                    @csrf

                    <div class="mb-3">
                        <label for="quickEmail" class="form-label">{{ __('app.email') }}</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                            <input id="quickEmail" type="email" class="form-control" name="email"
                                required autocomplete="email" placeholder="{{ __('custom.email_placeholder') }}">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="quickPassword" class="form-label">{{ __('custom.password_label') }}</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-lock"></i></span>
                            <input id="quickPassword" type="password" class="form-control" name="password"
                                required autocomplete="current-password" placeholder="{{ __('custom.password_placeholder') }}">
                            <button type="button" class="btn btn-outline-secondary" id="togglePasswordQuick">
                                <i class="fas fa-eye-slash"></i>
                            </button>
                        </div>
                    </div>

                    <div class="d-grid gap-2 mb-3">
                        <button type="submit" class="btn btn-login">
                            <i class="fas fa-sign-in-alt me-2"></i> {{ __('app.login') }}
                        </button>
                    </div>

                    <!-- أزرار الدخول السريع داخل الـ Modal -->
                    <div class="text-center my-4">
                        <h6 class="text-muted mb-3">{{ __('custom.quick_login_or') }}</h6>
                        <div class="d-grid gap-2">
                            <button type="button" class="btn btn-danger w-100" onclick="fillAndSubmit('admin@dashboard.com', 'Admin@123456')">
                                <i class="fas fa-crown me-1"></i> مدير لوحة التحكم المركزية
                            </button>
                            <button type="button" class="btn btn-success w-100" onclick="fillAndSubmit('admin1@company.com', 'password')">
                                <i class="fas fa-user-shield me-1"></i> {{ __('custom.role_admin') }}
                            </button>
                            <button type="button" class="btn btn-info w-100" onclick="fillAndSubmit('hr1@company.com', 'password')">
                                <i class="fas fa-users me-1"></i> {{ __('custom.role_hr') }}
                            </button>
                            <button type="button" class="btn btn-warning w-100" onclick="fillAndSubmit('employee1@company.com', 'password')">
                                <i class="fas fa-user me-1"></i> {{ __('custom.role_employee') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('custom.close') }}</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Toggle password visibility (main form)
        const toggleMain = document.getElementById('togglePassword');
        const pwdMain = document.getElementById('password');
        if (toggleMain && pwdMain) {
            toggleMain.addEventListener('click', function () {
                const type = pwdMain.type === 'password' ? 'text' : 'password';
                pwdMain.type = type;
                this.querySelector('i').classList.toggle('fa-eye-slash');
                this.querySelector('i').classList.toggle('fa-eye');
            });
        }

        // Toggle password visibility (modal form)
        const toggleModal = document.getElementById('togglePasswordQuick');
        const pwdModal = document.getElementById('quickPassword');
        if (toggleModal && pwdModal) {
            toggleModal.addEventListener('click', function () {
                const type = pwdModal.type === 'password' ? 'text' : 'password';
                pwdModal.type = type;
                this.querySelector('i').classList.toggle('fa-eye-slash');
                this.querySelector('i').classList.toggle('fa-eye');
            });
        }

        // Show password modal when clicking "النسخة التجريبية"
        const showPasswordModalBtn = document.getElementById('showPasswordModal');
        const passwordModal = new bootstrap.Modal(document.getElementById('passwordModal'));
        const quickLoginModal = new bootstrap.Modal(document.getElementById('quickLoginModal'));
        
        showPasswordModalBtn.addEventListener('click', function() {
            passwordModal.show();
        });

        // Verify password
        document.getElementById('verifyPassword').addEventListener('click', function() {
            const enteredPassword = document.getElementById('accessPassword').value;
            const passwordError = document.getElementById('passwordError');
            
            if (enteredPassword === '1111111111') {
                // Correct password, hide error and show quick login modal
                passwordError.style.display = 'none';
                passwordModal.hide();
                
                // Clear password field
                document.getElementById('accessPassword').value = '';
                
                // Show quick login modal after a short delay to allow password modal to close
                setTimeout(function() {
                    quickLoginModal.show();
                }, 300);
            } else {
                // Incorrect password, show error
                passwordError.style.display = 'block';
            }
        });

        // Clear password field when modal is closed
        document.getElementById('passwordModal').addEventListener('hidden.bs.modal', function() {
            document.getElementById('accessPassword').value = '';
            document.getElementById('passwordError').style.display = 'none';
        });

        // Fill fields AND optionally auto-submit
        window.fillAndSubmit = function(email, password, autoSubmit = true) {
            document.getElementById('quickEmail').value = email;
            document.getElementById('quickPassword').value = password;

            if (autoSubmit) {
                document.getElementById('quickLoginForm').submit();
            }
        };
    });
</script>
@endpush

@push('styles')
<style>
    .btn-login {
        background: linear-gradient(135deg, #00c6ff, #0072ff);
        border: none;
        padding: 14px;
        border-radius: 10px;
        color: white;
        font-weight: 600;
        font-size: 1.1rem;
        box-shadow: 0 4px 12px rgba(0, 198, 255, 0.3);
        transition: all 0.3s;
    }
    .btn-login:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 16px rgba(0, 198, 255, 0.4);
    }
</style>
@endpush