<!-- resources/views/attendance/show.blade.php -->

@extends('layouts.app')
@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('attendance.show_title') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('attendance.breadcrumb_home') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('attendance.index') }}">{{ __('attendance.breadcrumb_attendance') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('attendance.show_title') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">{{ __('attendance.attendance_log') }} - {{ $attendance->employee->name }}</h4>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <p><strong>{{ __('attendance.date') }}:</strong> {{ $attendance->date->format('Y-m-d') }}</p>
                            <p><strong>{{ __('attendance.status') }}:</strong>
                                @if($attendance->status == 'present')
                                    <span class="badge badge-success">{{ __('attendance.status_present') }}</span>
                                @elseif($attendance->status == 'absent')
                                    <span class="badge badge-danger">{{ __('attendance.status_absent') }}</span>
                                @elseif($attendance->status == 'late')
                                    <span class="badge badge-warning">{{ __('attendance.status_late') }}</span>
                                @elseif($attendance->status == 'early_departure')
                                    <span class="badge badge-info">{{ __('attendance.status_early_leave') }}</span>
                                @else
                                    <span class="badge badge-secondary">{{ __('attendance.unknown') }}</span>
                                @endif
                            </p>
                            <p><strong>{{ __('attendance.notes') }}:</strong> {{ $attendance->notes ?? __('attendance.no_notes') }}</p>
                        </div>
                        <div class="col-md-6">
                             <p><strong>{{ __('attendance.scheduled_check_in') }}:</strong>
                                @if($attendance->scheduled_check_in)
                                    {{ $attendance->scheduled_check_in->format('H:i:s') }}
                                @else
                                    <span class="text-muted">{{ __('attendance.not_scheduled') }}</span>
                                @endif
                            </p>
                            <p><strong>{{ __('attendance.scheduled_check_out') }}:</strong>
                                @if($attendance->scheduled_check_out)
                                    {{ $attendance->scheduled_check_out->format('H:i:s') }}
                                @else
                                    <span class="text-muted">{{ __('attendance.not_scheduled') }}</span>
                                @endif
                            </p>
                             <p><strong>{{ __('attendance.scheduled_work_duration') ?? 'مدة العمل المجدولة' }}:</strong>
                                @if($attendance->scheduled_work_duration)
                                    {{ $attendance->scheduled_work_duration }}
                                @else
                                     <span class="text-muted">{{ __('attendance.not_scheduled') }}</span>
                                @endif
                            </p>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <p><strong>{{ __('attendance.actual_check_in') }}:</strong>
                                @if($attendance->check_in)
                                    {{ $attendance->check_in->format('H:i:s') }}
                                @else
                                    <span class="text-muted">{{ __('attendance.not_checked_in') }}</span>
                                @endif
                            </p>
                            <p><strong>{{ __('attendance.actual_check_out') }}:</strong>
                                @if($attendance->check_out)
                                    {{ $attendance->check_out->format('H:i:s') }}
                                @else
                                    <span class="text-muted">{{ __('attendance.not_checked_out') }}</span>
                                @endif
                            </p>
                            <p><strong>{{ __('attendance.work_duration') }}:</strong>
                                @if($attendance->work_duration)
                                    {{ $attendance->work_duration }}
                                @else
                                    <span class="text-muted">{{ __('attendance.not_scheduled') }}</span>
                                @endif
                            </p>
                        </div>
                        <div class="col-md-6">
                            <!-- اختياري: مقارنة المدة أو الحالة -->
                            @if($attendance->scheduled_work_duration && preg_match('/^[0-2][0-9]:[0-5][0-9]:[0-5][0-9]$/', $attendance->scheduled_work_duration) && $attendance->work_duration && preg_match('/^[0-2][0-9]:[0-5][0-9]:[0-5][0-9]$/', $attendance->work_duration))
                                @php
                                    try {
                                        // تحويل المدة المجدولة إلى ثوانٍ
                                        $scheduledDurationSeconds = \Carbon\Carbon::createFromFormat('H:i:s', $attendance->scheduled_work_duration)->secondsSinceMidnight();
                                        // تحويل المدة الفعلية إلى ثوانٍ
                                        $actualDurationSeconds = \Carbon\Carbon::createFromFormat('H:i:s', $attendance->work_duration)->secondsSinceMidnight();
                                        $comparison = $actualDurationSeconds - $scheduledDurationSeconds;
                                        echo '<p><strong>' . __('attendance.duration_comparison') . ':</strong>';
                                        if($comparison >= 0) {
                                            echo '<span class="text-success">+'.gmdate('H:i:s', abs($comparison)).' ' . __('attendance.more_than_scheduled') . '</span>';
                                        } else {
                                            echo '<span class="text-warning">'.gmdate('H:i:s', abs($comparison)).' ' . __('attendance.less_than_scheduled') . '</span>';
                                        }
                                        echo '</p>';
                                    } catch (\Exception $e) {
                                        // في حالة حدوث خطأ في التحويل، لا تظهر مقارنة
                                        echo '<p><strong>' . __('attendance.duration_comparison') . ':</strong> <span class="text-muted">' . __('attendance.invalid_data') . '</span></p>';
                                    }
                                @endphp
                            @elseif($attendance->scheduled_work_duration)
                                <p><strong>{{ __('attendance.duration_comparison') }}:</strong> <span class="text-muted">{{ __('attendance.invalid_data') }}</span></p>
                            @endif

                            @if($attendance->scheduled_check_in && $attendance->check_in)
                                @php
                                    try {
                                        $scheduledIn = \Carbon\Carbon::createFromFormat('H:i:s', $attendance->scheduled_check_in->format('H:i:s'));
                                        $actualIn = \Carbon\Carbon::createFromFormat('H:i:s', $attendance->check_in->format('H:i:s'));
                                        $lateBy = $actualIn->diffInSeconds($scheduledIn, false); // سالب إذا كان متاخراً
                                        echo '<p><strong>' . __('attendance.early_late') . ':</strong>';
                                        if($lateBy > 0) {
                                            echo '<span class="text-success">' . __('attendance.early_by') . ' ' . gmdate('H:i:s', $lateBy) . '</span>';
                                        } elseif($lateBy < 0) {
                                            echo '<span class="text-warning">' . __('attendance.late_by') . ' ' . gmdate('H:i:s', abs($lateBy)) . '</span>';
                                        } else {
                                            echo '<span class="text-info">' . __('attendance.on_time') . '</span>';
                                        }
                                        echo '</p>';
                                    } catch (\Exception $e) {
                                        // في حالة حدوث خطأ في التحويل، لا تظهر مقارنة
                                        echo '<p><strong>' . __('attendance.early_late') . ':</strong> <span class="text-muted">' . __('attendance.invalid_data') . '</span></p>';
                                    }
                                @endphp
                            @endif
                        </div>
                    </div>

                    <div class="d-flex gap-2 mt-3">
                        @can('edit attendance')
                        <a href="{{ route('attendance.edit', $attendance) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> {{ __('attendance.edit') }}
                        </a>
                        @endcan
                        @can('viewAny', App\Models\Attendance::class)
                        <a href="{{ route('attendance.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> {{ __('attendance.back') }}
                        </a>
                        @endcan
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- بطاقة معلومات الموظف -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">{{ __('attendance.employee_info') }}</h5>
                    <div class="d-flex align-items-center mb-3">
                        @if($attendance->employee->photo)
                            <img src="{{ asset('storage/' . $attendance->employee->photo) }}" alt="صورة الموظف" class="rounded-circle me-3" width="60" height="60">
                        @else
                            <div class="avatar-md me-3">
                                <span class="avatar-title bg-primary text-white rounded-circle">
                                    {{ substr($attendance->employee->name, 0, 1) }}
                                </span>
                            </div>
                        @endif
                        <div>
                            <h6 class="mb-1">{{ $attendance->employee->name }}</h6>
                            <p class="mb-0 text-muted">{{ $attendance->employee->position?->name ?? __('attendance.not_scheduled') }}</p>
                            <p class="mb-0 text-muted">{{ $attendance->employee->department?->name ?? __('attendance.not_scheduled') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- سجلات الحضور السابقة (اختياري) -->
    @if(isset($relatedAttendances) && $relatedAttendances->count() > 0)
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title mb-4">{{ __('attendance.previous_records') }}</h5>
                     <div class="table-responsive">
                        <table class="table table-centered table-nowrap">
                            <thead class="thead-light">
                                <tr>
                                    <th>{{ __('attendance.date') }}</th>
                                    <th>{{ __('attendance.actual_check_in') }}</th>
                                    <th>{{ __('attendance.actual_check_out') }}</th>
                                    <th>{{ __('attendance.work_duration') }}</th>
                                    <th>{{ __('attendance.status') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                 @foreach($relatedAttendances as $related)
                                <tr>
                                    <td>{{ $related->date->format('Y-m-d') }}</td>
                                    <td>{{ $related->check_in ? $related->check_in->format('H:i:s') : __('attendance.not_checked_in') }}</td>
                                    <td>{{ $related->check_out ? $related->check_out->format('H:i:s') : __('attendance.not_checked_out') }}</td>
                                    <td>{{ $related->work_duration ?? __('attendance.not_scheduled') }}</td>
                                    <td>
                                        @if($related->status == 'present')
                                            <span class="badge badge-success">{{ __('attendance.status_present') }}</span>
                                        @elseif($related->status == 'absent')
                                            <span class="badge badge-danger">{{ __('attendance.status_absent') }}</span>
                                        @elseif($related->status == 'late')
                                            <span class="badge badge-warning">{{ __('attendance.status_late') }}</span>
                                        @elseif($related->status == 'early_departure')
                                            <span class="badge badge-info">{{ __('attendance.status_early_leave') }}</span>
                                        @else
                                            <span class="badge badge-secondary">{{ __('attendance.unknown') }}</span>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

</div>
@endsection