<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <title>سجل حضور {{ $employee->name }}</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .header { text-align: center; margin-bottom: 20px; }
        .info-section { margin-bottom: 15px; }
        .info-section h3 { border-bottom: 1px solid #ccc; padding-bottom: 3px; }
        .info-table { width: 100%; border-collapse: collapse; }
        .info-table td { border: 1px solid #ccc; padding: 5px; vertical-align: top; }
        .info-table th { background-color: #f2f2f2; border: 1px solid #ccc; padding: 5px; text-align: right; }
        .attendance-row { font-size: 0.9em; }
        .status-badge { padding: 2px 5px; border-radius: 3px; font-size: 0.8em; }
        .badge-success { background-color: #d4edda; color: #155724; }
        .badge-warning { background-color: #fff3cd; color: #856404; }
        .badge-danger { background-color: #f8d7da; color: #721c24; }
        .badge-info { background-color: #d1ecf1; color: #0c5460; }
        .badge-secondary { background-color: #d6d8db; color: #383d41; }
        .text-danger { color: #dc3545; }
        .text-success { color: #28a745; }
        .text-warning { color: #ffc107; }
        /* أضف CSS إضافي للطباعة */
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>سجل حضور الموظف: {{ $employee->name }}</h2>
        <h3>رقم الموظف: {{ $employee->employee_id }}</h3>
    </div>

    <div class="info-section">
        <h3>تفاصيل الحضور (من {{ $attendances->last()?->date->format('Y-m-d') ?? 'N/A' }} إلى {{ $attendances->first()?->date->format('Y-m-d') ?? 'N/A' }})</h3>
        <table class="info-table">
            <thead>
                <tr>
                    <th>التاريخ</th>
                    <th>الحضور المجدول</th>
                    <th>الانصراف المجدول</th>
                    <th>الحضور الفعلي</th>
                    <th>الانصراف الفعلي</th>
                    <th>المدة المجدولة</th>
                    <th>المدة الفعلية</th>
                    <th>الحالة</th>
                    <th>ملاحظات</th>
                </tr>
            </thead>
            <tbody>
                @forelse($attendances as $attendance)
                <tr class="attendance-row">
                    <td>{{ $attendance->date->format('Y-m-d') }}</td>
                    <td>{{ $attendance->scheduled_check_in }}</td>
                    <td>{{ $attendance->scheduled_check_out }}</td>
                    <td>{{ $attendance->check_in }}</td>
                    <td>{{ $attendance->check_out }}</td>
                    <td>{{ $attendance->scheduled_work_duration }}</td>
                    <td>{{ $attendance->work_duration }}</td>
                    <td>
                        @if($attendance->status == 'present')
                            <span class="status-badge badge-success">حاضر</span>
                        @elseif($attendance->status == 'absent')
                            <span class="status-badge badge-danger">غائب</span>
                        @elseif($attendance->status == 'late')
                            <span class="status-badge badge-warning">متأخر</span>
                        @elseif($attendance->status == 'early_departure')
                            <span class="status-badge badge-info">انصراف مبكر</span>
                        @else
                            <span class="status-badge badge-secondary">{{ $attendance->status }}</span>
                        @endif
                    </td>
                    <td>
                        @if($attendance->leave)
                            @php
                                $li = $attendance->leave;
                                $badgeText = ($li->is_unpaid_deduction_applied ?? false) ? 'خصم مادي' : 'خصم من الرصيد';
                                $reason = $li->reason ?? '-';
                            @endphp
                            <div style="margin-bottom:6px;">
                                <strong>{{ $badgeText }}</strong> (ID: {{ $li->id }})
                                <br>
                                <small class="text-muted">{{ $reason }}</small>
                                <br>
                                <small class="text-muted">{{ url('/leaves/' . $li->id) }}</small>
                            </div>
                        @endif

                        {{ $attendance->notes }}
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="9" class="text-center py-3">لا توجد سجلات حضور خلال هذه الفترة.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <script>
        // طباعة الصفحة مباشرة عند التحميل
        window.onload = function() {
            window.print();
        };
    </script>
</body>
</html>