@extends('layouts.app')

@section('content')
<div class="container">
    <h1>{{ __('attendance.import_title') }}</h1>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach($errors->all() as $e)
                    <li>{{ $e }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card mb-3">
        <div class="card-body">
            <p>{{ __('attendance.import_instructions') }}</p>
            <ul>
                <li><strong>employee_id</strong> {{ __('attendance.or') }} <strong>national_id</strong> ({{ __('attendance.identifier_description') }})</li>
                <li><strong>date</strong> {{ __('attendance.format') }} <code>YYYY-MM-DD</code></li>
                <li><strong>check_in</strong> {{ __('attendance.format_time') }} <code>HH:MM</code> ({{ __('attendance.optional') }})</li>
                <li><strong>check_out</strong> {{ __('attendance.format_time') }} <code>HH:MM</code> ({{ __('attendance.optional') }})</li>
            </ul>
            <p>{{ __('attendance.example_headers') }}: <code>employee_id,date,check_in,check_out</code></p>
        </div>
    </div>

    <form action="{{ route('attendance.import') }}" method="post" enctype="multipart/form-data">
        @csrf
        <div class="mb-3">
            <label for="file" class="form-label">{{ __('attendance.choose_file') }}</label>
            <input type="file" name="file" id="file" accept=".csv" class="form-control" required>
        </div>

        <div class="mb-3">
            <label for="identifier" class="form-label">{{ __('attendance.identifier_label') }}</label>
            <select name="identifier" id="identifier" class="form-control">
                <option value="employee_id">{{ __('attendance.identifier_option_employee_id') }}</option>
                <option value="national_id">{{ __('attendance.identifier_option_national_id') }}</option>
            </select>
        </div>

        <button class="btn btn-primary">{{ __('attendance.import_submit') }}</button>
    </form>
</div>
@endsection
