@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('attendance.edit_title') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('attendance.breadcrumb_home') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('attendance.index') }}">{{ __('attendance.breadcrumb_attendance') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('attendance.edit_title') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">{{ __('attendance.edit_form_title') }}</h4>

                    <form action="{{ route('attendance.update', $attendance) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="employee_id" class="form-label">{{ __('attendance.employee') }} <span class="text-danger">*</span></label>
                                <select class="form-control" id="employee_id" name="employee_id" required disabled>
                                    <option value="{{ $attendance->employee->id }}" selected>
                                        {{ $attendance->employee->name }} - {{ $attendance->employee->employee_id }}
                                    </option>
                                </select>
                                <input type="hidden" name="employee_id" value="{{ $attendance->employee_id }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="date" class="form-label">{{ __('attendance.date') }} <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="date" name="date" value="{{ old('date', $attendance->date->format('Y-m-d')) }}" required>
                                @error('date')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- أوقات الحضور والانصراف المجدولة -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="scheduled_check_in" class="form-label">{{ __('attendance.scheduled_check_in') }}</label>
                                <input type="time" class="form-control" id="scheduled_check_in" name="scheduled_check_in" value="{{ old('scheduled_check_in', $attendance->scheduled_check_in ? $attendance->scheduled_check_in->format('H:i') : '') }}">
                                @error('scheduled_check_in')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="scheduled_check_out" class="form-label">{{ __('attendance.scheduled_check_out') }}</label>
                                <input type="time" class="form-control" id="scheduled_check_out" name="scheduled_check_out" value="{{ old('scheduled_check_out', $attendance->scheduled_check_out ? $attendance->scheduled_check_out->format('H:i') : '') }}">
                                @error('scheduled_check_out')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- أوقات الحضور والانصراف الفعلية -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="check_in" class="form-label">{{ __('attendance.actual_check_in') }}</label>
                                <input type="time" class="form-control" id="check_in" name="check_in" value="{{ old('check_in', $attendance->check_in ? $attendance->check_in->format('H:i') : '') }}">
                                @error('check_in')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="check_out" class="form-label">{{ __('attendance.actual_check_out') }}</label>
                                <input type="time" class="form-control" id="check_out" name="check_out" value="{{ old('check_out', $attendance->check_out ? $attendance->check_out->format('H:i') : '') }}">
                                @error('check_out')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="status" class="form-label">{{ __('attendance.status') }}</label>
                                <select class="form-control" id="status" name="status">
                                    <option value="present" {{ old('status', $attendance->status) == 'present' ? 'selected' : '' }}>{{ __('attendance.status_present') }}</option>
                                    <option value="absent" {{ old('status', $attendance->status) == 'absent' ? 'selected' : '' }}>{{ __('attendance.status_absent') }}</option>
                                    <option value="late" {{ old('status', $attendance->status) == 'late' ? 'selected' : '' }}>{{ __('attendance.status_late') }}</option>
                                    <option value="early_departure" {{ old('status', $attendance->status) == 'early_departure' ? 'selected' : '' }}>{{ __('attendance.status_early_leave') }}</option>
                                </select>
                                @error('status')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="work_duration" class="form-label">{{ __('attendance.work_duration') }} (hh:mm:ss)</label>
                                <input type="text" class="form-control" id="work_duration" name="work_duration" value="{{ old('work_duration', $attendance->work_duration) }}" placeholder="08:00:00">
                                @error('work_duration')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="notes" class="form-label">{{ __('attendance.notes') }}</label>
                            <textarea class="form-control" id="notes" name="notes" rows="3" placeholder="{{ __('attendance.notes_placeholder') }}">
                                @if(trim(old('notes', $attendance->notes)) === __('attendance.quick_check_in') || trim(old('notes', $attendance->notes)) === 'تسجيل حضور سريع')
                                    {{ __('attendance.quick_check_in') }}
                                @else
                                    {{ old('notes', $attendance->notes) }}
                                @endif
                            </textarea>
                            @error('notes')
                                <div class="text-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-warning">
                                <i class="fas fa-save"></i> {{ __('attendance.update_record') }}
                            </button>
                            <a href="{{ route('attendance.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> {{ __('attendance.back') }}
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Employee Info Card -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">{{ __('attendance.employee_info') }}</h5>
                    <div class="d-flex align-items-center mb-3">
                        @if($attendance->employee->photo)
                            <img src="{{ asset('storage/' . $attendance->employee->photo) }}" alt="صورة الموظف" class="rounded-circle me-3" width="60" height="60">
                        @else
                            <div class="avatar-md me-3">
                                <span class="avatar-title bg-primary text-white rounded-circle">
                                    {{ substr($attendance->employee->name, 0, 1) }}
                                </span>
                            </div>
                        @endif
                        <div>
                            <h6 class="mb-1">{{ $attendance->employee->name }}</h6>
                            <p class="mb-0 text-muted">{{ $attendance->employee->position?->name ?? __('attendance.not_scheduled') }}</p>
                            <p class="mb-0 text-muted">{{ $attendance->employee->department?->name ?? __('attendance.not_scheduled') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto calculate work duration when both check_in and check_out are filled
    const checkInInput = document.getElementById('check_in');
    const checkOutInput = document.getElementById('check_out');
    const workDurationInput = document.getElementById('work_duration');

    function calculateWorkDuration() {
        if (checkInInput.value && checkOutInput.value) {
            const [checkInHours, checkInMinutes] = checkInInput.value.split(':').map(Number);
            const [checkOutHours, checkOutMinutes] = checkOutInput.value.split(':').map(Number);
            
            const checkInTotalMinutes = checkInHours * 60 + checkInMinutes;
            const checkOutTotalMinutes = checkOutHours * 60 + checkOutMinutes;
            
            if (checkOutTotalMinutes > checkInTotalMinutes) {
                const diffMinutes = checkOutTotalMinutes - checkInTotalMinutes;
                const hours = Math.floor(diffMinutes / 60);
                const minutes = diffMinutes % 60;
                
                workDurationInput.value = `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:00`;
            }
        }
    }

    if (checkInInput) checkInInput.addEventListener('change', calculateWorkDuration);
    if (checkOutInput) checkOutInput.addEventListener('change', calculateWorkDuration);
});
</script>
@endpush
@endsection