@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">تسجيل حضور جديد</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('attendance.index') }}">الحضور والإنصراف</a></li>
                        <li class="breadcrumb-item active">تسجيل حضور</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">نموذج تسجيل الحضور</h4>

                    <form action="{{ route('attendance.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <!-- اختيار الموظف -->
                            <div class="col-md-6 mb-3">
                                <label for="employee_id" class="form-label">اختر الموظف <span class="text-danger">*</span></label>
                                <select class="form-control select2" id="employee_id" name="employee_id" required>
                                    <option value="">اختر موظفاً</option>
                                    @foreach($employees as $employee)
                                        <option value="{{ $employee->id }}"
                                                data-checkin="{{ $employee->scheduled_check_in ?? '09:00' }}"
                                                data-checkout="{{ $employee->scheduled_check_out ?? '17:00' }}"
                                                {{ old('employee_id') == $employee->id ? 'selected' : '' }}>
                                            {{ $employee->name }} - {{ $employee->employee_id }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('employee_id')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- التاريخ -->
                            <div class="col-md-6 mb-3">
                                <label for="date" class="form-label">التاريخ <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="date" name="date"
                                       value="{{ old('date', date('Y-m-d')) }}" required>
                                @error('date')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- أوقات الحضور والانصراف المجدولة -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="scheduled_check_in" class="form-label">وقت الحضور المجدول</label>
                                <input type="time" class="form-control" id="scheduled_check_in"
                                       name="scheduled_check_in" value="" readonly required>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="scheduled_check_out" class="form-label">وقت الانصراف المجدول</label>
                                <input type="time" class="form-control" id="scheduled_check_out"
                                       name="scheduled_check_out" value="" readonly required>
                            </div>
                        </div>

                        <!-- أوقات الحضور والانصراف الفعلية -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="check_in" class="form-label">وقت الحضور الفعلي</label>
                                <input type="time" class="form-control" id="check_in" name="check_in"
                                       value="{{ old('check_in') }}">
                                @error('check_in')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="check_out" class="form-label">وقت الانصراف الفعلي</label>
                                <input type="time" class="form-control" id="check_out" name="check_out"
                                       value="{{ old('check_out') }}">
                                @error('check_out')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- الحالة ومدة العمل -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="status" class="form-label">الحالة</label>
                                <select class="form-control" id="status" name="status">
                                    <option value="present" {{ old('status') == 'present' ? 'selected' : '' }}>حاضر</option>
                                    <option value="absent" {{ old('status') == 'absent' ? 'selected' : '' }}>غائب</option>
                                    <option value="late" {{ old('status') == 'late' ? 'selected' : '' }}>متأخر</option>
                                    <option value="early_departure" {{ old('status') == 'early_departure' ? 'selected' : '' }}>مغادر مبكر</option>
                                </select>
                                @error('status')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="work_duration" class="form-label">مدة العمل الفعلية (hh:mm:ss)</label>
                                <input type="text" class="form-control" id="work_duration" name="work_duration"
                                       value="{{ old('work_duration') }}" placeholder="08:00:00" readonly>
                            </div>
                        </div>

                        <!-- ملاحظات -->
                        <div class="mb-3">
                            <label for="notes" class="form-label">ملاحظات</label>
                            <textarea class="form-control" id="notes" name="notes" rows="3"
                                      placeholder="أدخل أي ملاحظات إضافية">{{ old('notes') }}</textarea>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save"></i> تسجيل الحضور
                            </button>
                            <a href="{{ route('attendance.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> رجوع
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// ✅ الحل: الاعتماد على حدث فتح الـ Modal بدل تحميل الصفحة
document.addEventListener('DOMContentLoaded', function () {
    const modalElement = document.querySelector('#attendanceModal'); // ⚠️ تأكد من اسم الـ Modal

    if (modalElement) {
        modalElement.addEventListener('show.bs.modal', function () {
            // استدعاء الدالة الجاهزة مع تحديد الـ Modal
            bindEmployeeSelect('employee_id', 'scheduled_check_in', 'scheduled_check_out', 'attendanceModal');
            
            // إعادة تهيئة Select2 إذا لزم الأمر
            $('.select2').select2({
                dropdownParent: $('#attendanceModal'),
                dir: 'rtl',
                language: 'ar'
            });
        });
    } else {
        // إذا كانت الصفحة مستقلة (غير Modal)، نفذ مباشرة
        bindEmployeeSelect('employee_id', 'scheduled_check_in', 'scheduled_check_out');
    }
});

// ⚙️ دالة حساب مدة العمل (يمكن نقلها إلى ملف عام)
(function calculateWorkDuration() {
    const checkIn = document.getElementById('check_in');
    const checkOut = document.getElementById('check_out');
    const duration = document.getElementById('work_duration');

    if (!checkIn || !checkOut || !duration) return;

    function updateDuration() {
        if (!checkIn.value || !checkOut.value) {
            duration.value = '';
            return;
        }

        const [inH, inM] = checkIn.value.split(':').map(Number);
        const [outH, outM] = checkOut.value.split(':').map(Number);

        let totalIn  = inH * 60 + inM;
        let totalOut = outH * 60 + outM;

        if (totalOut < totalIn) totalOut += 1440; // +24 ساعة بالدقائق

        const diff = totalOut - totalIn;
        const h = Math.floor(diff / 60);
        const m = diff % 60;

        duration.value = `${String(h).padStart(2, '0')}:${String(m).padStart(2, '0')}:00`;
    }

    checkIn?.addEventListener('change', updateDuration);
    checkOut?.addEventListener('change', updateDuration);
})();
</script>
@endpush
@endsection