@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">تفاصيل الأصل</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('assets.index') }}">الأصول</a></li>
                        <li class="breadcrumb-item active">تفاصيل الأصل</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-4">
                        <div>
                            <h4 class="card-title">{{ $asset->name }}</h4>
                            <p class="text-muted">{{ $asset->description ?? 'لا يوجد وصف' }}</p>
                        </div>
                        <div>
                            @if($asset->status == 'available')
                                <span class="badge badge-success fs-6">متاح</span>
                            @elseif($asset->status == 'assigned')
                                <span class="badge badge-primary fs-6">مُسنَد</span>
                            @elseif($asset->status == 'maintenance')
                                <span class="badge badge-warning fs-6">صيانة</span>
                            @elseif($asset->status == 'retired')
                                <span class="badge badge-secondary fs-6">متقاعد</span>
                            @elseif($asset->status == 'damaged')
                                <span class="badge badge-danger fs-6">تالف</span>
                            @endif
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <h5 class="mb-3">معلومات الأصل</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th>الفئة:</th>
                                    <td>
                                        @switch($asset->category)
                                            @case('electronic')
                                                <span class="badge badge-soft-primary">إلكترونيات</span>
                                                @break
                                            @case('furniture')
                                                <span class="badge badge-soft-success">أثاث</span>
                                                @break
                                            @case('vehicle')
                                                <span class="badge badge-soft-warning">مركبات</span>
                                                @break
                                            @case('equipment')
                                                <span class="badge badge-soft-danger">معدات</span>
                                                @break
                                            @case('software')
                                                <span class="badge badge-soft-info">برمجيات</span>
                                                @break
                                            @default
                                                <span class="badge badge-soft-secondary">{{ $asset->category }}</span>
                                        @endswitch
                                    </td>
                                </tr>
                                <tr>
                                    <th>الرقم التسلسلي:</th>
                                    <td>{{ $asset->serial_number ?? 'غير متوفر' }}</td>
                                </tr>
                                <tr>
                                    <th>القيمة:</th>
                                    <td>{{ number_format($asset->value ?? 0, 2) }} د.ك</td>
                                </tr>
                                <tr>
                                    <th>تاريخ الشراء:</th>
                                    <td>{{ $asset->purchase_date ? $asset->purchase_date->format('Y-m-d') : 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>انتهاء الضمان:</th>
                                    <td>{{ $asset->warranty_expiry ? $asset->warranty_expiry->format('Y-m-d') : 'غير محدد' }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h5 class="mb-3">الموقع والحالة</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th>الموقع:</th>
                                    <td>{{ $asset->location ?? 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>الحالة:</th>
                                    <td>
                                        @if($asset->status == 'available')
                                            <span class="badge badge-success">متاح</span>
                                        @elseif($asset->status == 'assigned')
                                            <span class="badge badge-primary">مُسنَد</span>
                                        @elseif($asset->status == 'maintenance')
                                            <span class="badge badge-warning">صيانة</span>
                                        @elseif($asset->status == 'retired')
                                            <span class="badge badge-secondary">متقاعد</span>
                                        @elseif($asset->status == 'damaged')
                                            <span class="badge badge-danger">تالف</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>تاريخ الإنشاء:</th>
                                    <td>{{ $asset->created_at->format('Y-m-d H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>آخر تحديث:</th>
                                    <td>{{ $asset->updated_at->format('Y-m-d H:i') }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <div class="d-flex gap-2 flex-wrap">
                        @can('edit asset')
                        <a href="{{ route('assets.edit', $asset) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        @endcan

                        @if($asset->status == 'available')
                            @can('assign asset')
                            <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#assignAssetModal">
                                <i class="fas fa-user-plus"></i> إسناد الأصل
                            </button>
                            @endcan
                        @elseif($asset->status == 'assigned')
                            @can('unassign asset')
                            <form action="{{ route('assets.unassign', $asset) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-secondary" onclick="return confirm('{{ addslashes(__('app.confirm_unassign_asset')) }}')">
                                    <i class="fas fa-user-minus"></i> إلغاء الإسناد
                                </button>
                            </form>
                            @endcan
                        @endif

                        @can('delete asset')
                        <form action="{{ route('assets.destroy', $asset) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger" onclick="return confirm('{{ addslashes(__('app.confirm_delete_asset')) }}')">
                                <i class="fas fa-trash"></i> حذف
                            </button>
                        </form>
                        @endcan

                        <a href="{{ route('assets.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> رجوع
                        </a>
                    </div>
                </div>
            </div>

            <!-- Assignment History -->
            <div class="card mt-4">
                <div class="card-body">
                    <h5 class="card-title mb-4">سجل الإسناد</h5>
                    @if($asset->assignments && $asset->assignments->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-centered">
                            <thead class="thead-light">
                                <tr>
                                    <th>الموظف</th>
                                    <th>تاريخ الإسناد</th>
                                    <th>تاريخ الإلغاء</th>
                                    <th>المدة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($asset->assignments as $assignment)
                                <tr>
                                    <td>{{ $assignment->employee->name ?? 'غير محدد' }}</td>
                                    <td>{{ $assignment->assigned_at->format('Y-m-d') }}</td>
                                    <td>{{ $assignment->returned_at ? $assignment->returned_at->format('Y-m-d') : '-' }}</td>
                                    <td>
                                        @if($assignment->returned_at)
                                            {{ $assignment->assigned_at->diffInDays($assignment->returned_at) }} يوم
                                        @else
                                            {{ $assignment->assigned_at->diffInDays(now()) }} يوم
                                        @endif
                                    </td>
                                    <td>
                                        <a href="#" class="btn btn-info btn-sm" title="عرض التفاصيل">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <div class="text-center py-4">
                        <i class="fas fa-history fa-2x text-muted mb-2"></i>
                        <p class="text-muted">لا يوجد سجل إسناد لهذا الأصل</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    @if($asset->photo)
                        <img src="{{ asset('storage/' . $asset->photo) }}" alt="صورة الأصل" class="img-fluid rounded mb-3">
                    @else
                        <div class="avatar-lg mx-auto mb-3">
                            <span class="avatar-title bg-primary text-white rounded-circle">
                                <i class="fas fa-box"></i>
                            </span>
                        </div>
                    @endif
                    <h4>{{ $asset->name }}</h4>
                    <p class="text-muted">{{ $asset->category_name ?? 'غير محدد' }}</p>
                    <hr>
                    <div class="row text-center">
                        <div class="col-6">
                            <h5>{{ number_format($asset->value ?? 0, 2) }}</h5>
                            <p class="text-muted mb-0">القيمة (د.ك)</p>
                        </div>
                        <div class="col-6">
                            <h5>{{ $asset->serial_number ?? 'غير متوفر' }}</h5>
                            <p class="text-muted mb-0">الرقم التسلسلي</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Assigned To -->
            @if($asset->assignedTo)
            <div class="card mt-4">
                <div class="card-body">
                    <h5 class="card-title mb-3">مُسنَد إلى</h5>
                    <div class="d-flex align-items-center">
                        @if($asset->assignedTo->photo)
                            <img src="{{ asset('storage/' . $asset->assignedTo->photo) }}" alt="صورة الموظف" class="rounded-circle me-3" width="60" height="60">
                        @else
                            <div class="avatar-md me-3">
                                <span class="avatar-title bg-info text-white rounded-circle">
                                    {{ substr($asset->assignedTo->name ?? '', 0, 1) }}
                                </span>
                            </div>
                        @endif
                        <div>
                            <h6 class="mb-1">{{ $asset->assignedTo->name }}</h6>
                            <p class="mb-0 text-muted">{{ $asset->assignedTo->position?->name ?? 'غير محدد' }}</p>
                            <p class="mb-0 text-muted">{{ $asset->assignedTo->department?->name ?? 'غير محدد' }}</p>
                        </div>
                    </div>
                    <hr>
                    <div class="text-center">
                        <small class="text-muted">مُسنَد منذ {{ $asset->assignments->first()->assigned_at->diffForHumans() }}</small>
                    </div>
                </div>
            </div>
            @endif

            <!-- Maintenance History -->
            <div class="card mt-4">
                <div class="card-body">
                    <h5 class="card-title mb-3">سجل الصيانة</h5>
                    <div class="text-center py-3">
                        <i class="fas fa-wrench fa-2x text-muted mb-2"></i>
                        <p class="text-muted">لا توجد سجلات صيانة</p>
                        <button class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة سجل صيانة
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Assign Asset Modal -->
<div class="modal fade" id="assignAssetModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">إسناد الأصل</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('assets.assign', $asset) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <input type="hidden" name="asset_id" value="{{ $asset->id }}">
                    <div class="mb-3">
                        <label class="form-label">الأصل</label>
                        <input type="text" class="form-control" value="{{ $asset->name }}" readonly>
                    </div>
                    <div class="mb-3">
                        <label for="employee_id" class="form-label">اختر الموظف <span class="text-danger">*</span></label>
                        <select class="form-control select2" id="employee_id" name="employee_id" required>
                            <option value="">اختر موظفاً</option>
                            @foreach($employees as $employee)
                                <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                            @endforeach
                        </select>
                        @error('employee_id')
                            <div class="text-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="assigned_at" class="form-label">تاريخ الإسناد</label>
                        <input type="date" class="form-control" id="assigned_at" name="assigned_at" value="{{ date('Y-m-d') }}">
                        @error('assigned_at')
                            <div class="text-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="notes" class="form-label">ملاحظات</label>
                        <textarea class="form-control" id="notes" name="notes" rows="2"></textarea>
                        @error('notes')
                            <div class="text-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-success">إسناد الأصل</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection