@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">إدارة الأصول</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item active">الأصول</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">إجمالي الأصول</p>
                            <h4 class="mb-0">{{ $totalAssets ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-boxes fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">المُسندة</p>
                            <h4 class="mb-0">{{ $assignedAssets ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-user-check fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">المتاحة</p>
                            <h4 class="mb-0">{{ $availableAssets ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-box-open fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">القيمة الإجمالية</p>
                            <h4 class="mb-0">{{ number_format($totalValue ?? 0, 2) }} د.ك</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-money-bill-wave fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h4 class="card-title">قائمة الأصول</h4>
                        <div class="btn-group">
                            @can('create asset')
                            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createAssetModal">
                                <i class="fas fa-plus"></i> أصل جديد
                            </button>
                            @endcan
                            @can('import asset')
                            <button class="btn btn-success">
                                <i class="fas fa-file-import"></i> استيراد أصول
                            </button>
                            @endcan
                        </div>
                    </div>

                    <!-- Search and Filter -->
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <input type="text" id="searchInput" class="form-control" placeholder="البحث عن أصل...">
                        </div>
                        <div class="col-md-2">
                            <select id="categoryFilter" class="form-control">
                                <option value="">جميع الفئات</option>
                                <option value="electronic">إلكترونيات</option>
                                <option value="furniture">أثاث</option>
                                <option value="vehicle">مركبات</option>
                                <option value="equipment">معدات</option>
                                <option value="software">برمجيات</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="statusFilter" class="form-control">
                                <option value="">جميع الحالات</option>
                                <option value="available">متاح</option>
                                <option value="assigned">مُسنَد</option>
                                <option value="maintenance">صيانة</option>
                                <option value="retired">متقاعد</option>
                                <option value="damaged">تالف</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="assignedToFilter" class="form-control">
                                <option value="">جميع الموظفين</option>
                                @foreach($employees as $employee)
                                    <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <div class="input-group">
                                <input type="date" id="purchaseFrom" class="form-control" placeholder="من تاريخ الشراء">
                                <input type="date" id="purchaseTo" class="form-control" placeholder="إلى تاريخ الشراء">
                            </div>
                        </div>
                    </div>

                    <!-- Assets Table -->
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>الأصل</th>
                                    <th>الفئة</th>
                                    <th>الرقم التسلسلي</th>
                                    <th>القيمة</th>
                                    <th>تاريخ الشراء</th>
                                    <th>الحالة</th>
                                    <th>مُسنَد إلى</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($assets as $asset)
                                <tr>
                                    <td>{{ $asset->id }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if($asset->photo)
                                                <img src="{{ asset('storage/' . $asset->photo) }}" alt="صورة الأصل" class="rounded me-2" width="40" height="40">
                                            @else
                                                <div class="avatar-sm me-2">
                                                    <span class="avatar-title bg-primary text-white rounded-circle">
                                                        <i class="fas fa-box"></i>
                                                    </span>
                                                </div>
                                            @endif
                                            <div>
                                                <h5 class="font-size-14 mb-0">{{ $asset->name }}</h5>
                                                <p class="text-muted mb-0">{{ Str::limit($asset->description, 30) }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        @switch($asset->category)
                                            @case('electronic')
                                                <span class="badge badge-soft-primary">إلكترونيات</span>
                                                @break
                                            @case('furniture')
                                                <span class="badge badge-soft-success">أثاث</span>
                                                @break
                                            @case('vehicle')
                                                <span class="badge badge-soft-warning">مركبات</span>
                                                @break
                                            @case('equipment')
                                                <span class="badge badge-soft-danger">معدات</span>
                                                @break
                                            @case('software')
                                                <span class="badge badge-soft-info">برمجيات</span>
                                                @break
                                            @default
                                                <span class="badge badge-soft-secondary">{{ $asset->category }}</span>
                                        @endswitch
                                    </td>
                                    <td>
                                        <span class="font-monospace">{{ $asset->serial_number ?? 'غير متوفر' }}</span>
                                    </td>
                                    <td>
                                        <strong>{{ number_format($asset->value ?? 0, 2) }} د.ك</strong>
                                    </td>
                                    <td>{{ $asset->purchase_date ? $asset->purchase_date->format('Y-m-d') : 'غير محدد' }}</td>
                                    <td>
                                        @if($asset->status == 'available')
                                            <span class="badge badge-success">متاح</span>
                                        @elseif($asset->status == 'assigned')
                                            <span class="badge badge-primary">مُسنَد</span>
                                        @elseif($asset->status == 'maintenance')
                                            <span class="badge badge-warning">صيانة</span>
                                        @elseif($asset->status == 'retired')
                                            <span class="badge badge-secondary">متقاعد</span>
                                        @elseif($asset->status == 'damaged')
                                            <span class="badge badge-danger">تالف</span>
                                        @else
                                            <span class="badge badge-dark">غير معروف</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($asset->assignedTo)
                                            <div class="d-flex align-items-center">
                                                @if($asset->assignedTo->photo)
                                                    <img src="{{ asset('storage/' . $asset->assignedTo->photo) }}" alt="صورة الموظف" class="rounded-circle me-2" width="24" height="24">
                                                @else
                                                    <div class="avatar-xs me-2">
                                                        <span class="avatar-title bg-info text-white rounded-circle">
                                                            {{ substr($asset->assignedTo->name, 0, 1) }}
                                                        </span>
                                                    </div>
                                                @endif
                                                <span>{{ $asset->assignedTo->name }}</span>
                                            </div>
                                        @else
                                            <span class="text-muted">غير مُسنَد</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            @can('view asset')
                                            <a href="{{ route('assets.show', $asset) }}" class="btn btn-info btn-sm" title="عرض التفاصيل">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @endcan

                                            @can('edit asset')
                                            <button class="btn btn-warning btn-sm" title="تعديل" 
                                                    data-bs-toggle="modal" data-bs-target="#editAssetModal"
                                                    data-id="{{ $asset->id }}"
                                                    data-name="{{ $asset->name }}"
                                                    data-category="{{ $asset->category }}"
                                                    data-value="{{ $asset->value }}"
                                                    data-status="{{ $asset->status }}">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            @endcan

                                            @if($asset->status == 'available')
                                                @can('assign asset')
                                                <button class="btn btn-success btn-sm" title="إسناد" 
                                                        data-bs-toggle="modal" data-bs-target="#assignAssetModal"
                                                        data-asset-id="{{ $asset->id }}"
                                                        data-asset-name="{{ $asset->name }}">
                                                    <i class="fas fa-user-plus"></i>
                                                </button>
                                                @endcan
                                            @elseif($asset->status == 'assigned')
                                                @can('unassign asset')
                                                <form action="{{ route('assets.unassign', $asset) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-secondary btn-sm" title="إلغاء الإسناد" 
                                                            onclick="return confirm('{{ addslashes(__('app.confirm_unassign_asset')) }}')">
                                                        <i class="fas fa-user-minus"></i>
                                                    </button>
                                                </form>
                                                @endcan
                                            @endif

                                            @can('delete asset')
                                            <form action="{{ route('assets.destroy', $asset) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" title="حذف" 
                                                        onclick="return confirm('{{ addslashes(__('app.confirm_delete_asset')) }}')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">
                                        <i class="fas fa-boxes fa-3x mb-3"></i>
                                        <h5>لا توجد أصول مسجلة</h5>
                                        <p class="text-muted">ابدأ بإضافة أصل جديد</p>
                                        @can('create asset')
                                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createAssetModal">
                                            <i class="fas fa-plus"></i> أصل جديد
                                        </button>
                                        @endcan
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if(isset($assets) && $assets->hasPages())
                    <div class="d-flex justify-content-center mt-4">
                        {{ $assets->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Stats and Charts -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">توزيع الأصول حسب الفئة</h4>
                    <canvas id="assetCategoriesChart" height="300"></canvas>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">حالة الأصول</h4>
                    <canvas id="assetStatusChart" height="300"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Asset Assignment History -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">سجل إسناد الأصول</h4>
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap">
                            <thead class="thead-light">
                                <tr>
                                    <th>الأصل</th>
                                    <th>الموظف</th>
                                    <th>تاريخ الإسناد</th>
                                    <th>تاريخ الإلغاء</th>
                                    <th>المدة</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>حاسوب محمول - Dell XPS 13</td>
                                    <td>أحمد محمد</td>
                                    <td>2025-08-01</td>
                                    <td>-</td>
                                    <td>22 يوم</td>
                                </tr>
                                <tr>
                                    <td>كرسي مكتب - Herman Miller</td>
                                    <td>سارة علي</td>
                                    <td>2025-07-15</td>
                                    <td>2025-08-20</td>
                                    <td>36 يوم</td>
                                </tr>
                                <tr>
                                    <td>هاتف ذكي - iPhone 14</td>
                                    <td>خالد حسن</td>
                                    <td>2025-08-10</td>
                                    <td>-</td>
                                    <td>12 يوم</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Asset Activities -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">الأنشطة الأخيرة للأصول</h4>
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap">
                            <thead class="thead-light">
                                <tr>
                                    <th>النشاط</th>
                                    <th>المستخدم</th>
                                    <th>الأصل</th>
                                    <th>الوصف</th>
                                    <th>التاريخ</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><span class="badge badge-primary">إضافة أصل</span></td>
                                    <td>مدير الأصول</td>
                                    <td>حاسوب محمول جديد</td>
                                    <td>إضافة حاسوب محمول Dell XPS 15</td>
                                    <td>2025-08-22 16:30</td>
                                </tr>
                                <tr>
                                    <td><span class="badge badge-success">إسناد أصل</span></td>
                                    <td>مدير الأصول</td>
                                    <td>iPhone 14</td>
                                    <td>إسناد الهاتف للمستخدم أحمد محمد</td>
                                    <td>2025-08-22 15:45</td>
                                </tr>
                                <tr>
                                    <td><span class="badge badge-warning">تعديل أصل</span></td>
                                    <td>مدير الأصول</td>
                                    <td>كرسي مكتب</td>
                                    <td>تحديث حالة الكرسي إلى صيانة</td>
                                    <td>2025-08-22 14:20</td>
                                </tr>
                                <tr>
                                    <td><span class="badge badge-info">صيانة أصل</span></td>
                                    <td>فني الصيانة</td>
                                    <td>طابعة ليزر</td>
                                    <td>إكمال صيانة الطابعة</td>
                                    <td>2025-08-22 13:15</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Create Asset Modal -->
<div class="modal fade" id="createAssetModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">إضافة أصل جديد</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('assets.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="assetName" class="form-label">اسم الأصل</label>
                                <input type="text" class="form-control" id="assetName" name="name" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="assetCategory" class="form-label">الفئة</label>
                                <select class="form-control" id="assetCategory" name="category" required>
                                    <option value="">اختر الفئة</option>
                                    <option value="electronic">إلكترونيات</option>
                                    <option value="furniture">أثاث</option>
                                    <option value="vehicle">مركبات</option>
                                    <option value="equipment">معدات</option>
                                    <option value="software">برمجيات</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="assetDescription" class="form-label">الوصف</label>
                        <textarea class="form-control" id="assetDescription" name="description" rows="2"></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="assetSerialNumber" class="form-label">الرقم التسلسلي</label>
                                <input type="text" class="form-control" id="assetSerialNumber" name="serial_number">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="assetValue" class="form-label">القيمة (د.ك)</label>
                                <input type="number" class="form-control" id="assetValue" name="value" step="0.01" min="0">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="assetPurchaseDate" class="form-label">تاريخ الشراء</label>
                                <input type="date" class="form-control" id="assetPurchaseDate" name="purchase_date">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="assetWarrantyExpiry" class="form-label">انتهاء الضمان</label>
                                <input type="date" class="form-control" id="assetWarrantyExpiry" name="warranty_expiry">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="assetLocation" class="form-label">الموقع</label>
                                <input type="text" class="form-control" id="assetLocation" name="location">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="assetStatus" class="form-label">الحالة</label>
                                <select class="form-control" id="assetStatus" name="status">
                                    <option value="available">متاح</option>
                                    <option value="assigned">مُسنَد</option>
                                    <option value="maintenance">صيانة</option>
                                    <option value="retired">متقاعد</option>
                                    <option value="damaged">تالف</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="assetPhoto" class="form-label">صورة الأصل</label>
                        <input type="file" class="form-control" id="assetPhoto" name="photo" accept="image/*">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">إضافة الأصل</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Asset Modal -->
<div class="modal fade" id="editAssetModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تعديل الأصل</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="editAssetForm" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <input type="hidden" id="editAssetId" name="id">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="editAssetName" class="form-label">اسم الأصل</label>
                                <input type="text" class="form-control" id="editAssetName" name="name" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="editAssetCategory" class="form-label">الفئة</label>
                                <select class="form-control" id="editAssetCategory" name="category" required>
                                    <option value="electronic">إلكترونيات</option>
                                    <option value="furniture">أثاث</option>
                                    <option value="vehicle">مركبات</option>
                                    <option value="equipment">معدات</option>
                                    <option value="software">برمجيات</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="editAssetDescription" class="form-label">الوصف</label>
                        <textarea class="form-control" id="editAssetDescription" name="description" rows="2"></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="editAssetSerialNumber" class="form-label">الرقم التسلسلي</label>
                                <input type="text" class="form-control" id="editAssetSerialNumber" name="serial_number">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="editAssetValue" class="form-label">القيمة (د.ك)</label>
                                <input type="number" class="form-control" id="editAssetValue" name="value" step="0.01" min="0">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="editAssetPurchaseDate" class="form-label">تاريخ الشراء</label>
                                <input type="date" class="form-control" id="editAssetPurchaseDate" name="purchase_date">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="editAssetWarrantyExpiry" class="form-label">انتهاء الضمان</label>
                                <input type="date" class="form-control" id="editAssetWarrantyExpiry" name="warranty_expiry">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="editAssetLocation" class="form-label">الموقع</label>
                                <input type="text" class="form-control" id="editAssetLocation" name="location">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="editAssetStatus" class="form-label">الحالة</label>
                                <select class="form-control" id="editAssetStatus" name="status">
                                    <option value="available">متاح</option>
                                    <option value="assigned">مُسنَد</option>
                                    <option value="maintenance">صيانة</option>
                                    <option value="retired">متقاعد</option>
                                    <option value="damaged">تالف</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="editAssetPhoto" class="form-label">صورة الأصل (اختياري)</label>
                        <input type="file" class="form-control" id="editAssetPhoto" name="photo" accept="image/*">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-warning">تحديث الأصل</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Assign Asset Modal -->
<div class="modal fade" id="assignAssetModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">إسناد الأصل</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="assignAssetForm" method="POST">
                @csrf
                <div class="modal-body">
                    <input type="hidden" id="assignAssetId" name="asset_id">
                    <div class="mb-3">
                        <label class="form-label">الأصل</label>
                        <input type="text" class="form-control" id="assignAssetName" readonly>
                    </div>
                    <div class="mb-3">
                        <label for="assignEmployee" class="form-label">اختر الموظف</label>
                        <select class="form-control" id="assignEmployee" name="employee_id" required>
                            <option value="">اختر موظفاً</option>
                            @foreach($employees as $employee)
                                <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="assignDate" class="form-label">تاريخ الإسناد</label>
                        <input type="date" class="form-control" id="assignDate" name="assign_date" value="{{ date('Y-m-d') }}" required>
                    </div>
                    <div class="mb-3">
                        <label for="assignNotes" class="form-label">ملاحظات</label>
                        <textarea class="form-control" id="assignNotes" name="notes" rows="2"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-success">إسناد الأصل</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Chart Scripts -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Asset Categories Chart
    var ctx1 = document.getElementById('assetCategoriesChart').getContext('2d');
    var assetCategoriesChart = new Chart(ctx1, {
        type: 'doughnut',
         {
            labels: ['إلكترونيات', 'أثاث', 'مركبات', 'معدات', 'برمجيات'],
            datasets: [{
                 [35, 25, 10, 20, 10],
                backgroundColor: [
                    '#4361ee',
                    '#3a0ca3',
                    '#4cc9f0',
                    '#f72585',
                    '#7209b7'
                ]
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });

    // Asset Status Chart
    var ctx2 = document.getElementById('assetStatusChart').getContext('2d');
    var assetStatusChart = new Chart(ctx2, {
        type: 'bar',
         {
            labels: ['متاح', 'مُسنَد', 'صيانة', 'متقاعد', 'تالف'],
            datasets: [{
                label: 'عدد الأصول',
                 [45, 35, 8, 5, 7],
                backgroundColor: [
                    '#20bf6b',
                    '#4361ee',
                    '#f7b84b',
                    '#6c757d',
                    '#f06595'
                ]
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Edit Asset Modal
    var editAssetModal = document.getElementById('editAssetModal');
    editAssetModal.addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var assetId = button.getAttribute('data-id');
        var assetName = button.getAttribute('data-name');
        var assetCategory = button.getAttribute('data-category');
        var assetValue = button.getAttribute('data-value');
        var assetStatus = button.getAttribute('data-status');
        
        var modal = this;
        modal.querySelector('#editAssetId').value = assetId;
        modal.querySelector('#editAssetName').value = assetName;
        modal.querySelector('#editAssetCategory').value = assetCategory;
        modal.querySelector('#editAssetValue').value = assetValue;
        modal.querySelector('#editAssetStatus').value = assetStatus;
        
        // Update form action
        var form = modal.querySelector('#editAssetForm');
        form.action = '/assets/' + assetId;
    });

    // Assign Asset Modal
    var assignAssetModal = document.getElementById('assignAssetModal');
    assignAssetModal.addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var assetId = button.getAttribute('data-asset-id');
        var assetName = button.getAttribute('data-asset-name');
        
        var modal = this;
        modal.querySelector('#assignAssetId').value = assetId;
        modal.querySelector('#assignAssetName').value = assetName;
        
        // Update form action
        var form = modal.querySelector('#assignAssetForm');
        form.action = '/assets/' + assetId + '/assign';
    });

    // Search and Filter Functionality
    const searchInput = document.getElementById('searchInput');
    const categoryFilter = document.getElementById('categoryFilter');
    const statusFilter = document.getElementById('statusFilter');
    const assignedToFilter = document.getElementById('assignedToFilter');
    const purchaseFrom = document.getElementById('purchaseFrom');
    const purchaseTo = document.getElementById('purchaseTo');

    function filterTable() {
        // Implementation for filtering table rows
        console.log('Filtering assets table...');
    }

    if (searchInput) searchInput.addEventListener('keyup', filterTable);
    if (categoryFilter) categoryFilter.addEventListener('change', filterTable);
    if (statusFilter) statusFilter.addEventListener('change', filterTable);
    if (assignedToFilter) assignedToFilter.addEventListener('change', filterTable);
    if (purchaseFrom) purchaseFrom.addEventListener('change', filterTable);
    if (purchaseTo) purchaseTo.addEventListener('change', filterTable);
});
</script>
@endsection