@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">تعديل الأصل</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('assets.index') }}">الأصول</a></li>
                        <li class="breadcrumb-item active">تعديل الأصل</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">نموذج تعديل الأصل</h4>

                    <form action="{{ route('assets.update', $asset) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="name" class="form-label">اسم الأصل <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $asset->name) }}" required>
                                @error('name')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="category" class="form-label">الفئة <span class="text-danger">*</span></label>
                                <select class="form-control" id="category" name="category" required>
                                    <option value="">اختر الفئة</option>
                                    <option value="electronic" {{ old('category', $asset->category) == 'electronic' ? 'selected' : '' }}>إلكترونيات</option>
                                    <option value="furniture" {{ old('category', $asset->category) == 'furniture' ? 'selected' : '' }}>أثاث</option>
                                    <option value="vehicle" {{ old('category', $asset->category) == 'vehicle' ? 'selected' : '' }}>مركبات</option>
                                    <option value="equipment" {{ old('category', $asset->category) == 'equipment' ? 'selected' : '' }}>معدات</option>
                                    <option value="software" {{ old('category', $asset->category) == 'software' ? 'selected' : '' }}>برمجيات</option>
                                </select>
                                @error('category')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">الوصف</label>
                            <textarea class="form-control" id="description" name="description" rows="3" placeholder="وصف الأصل">{{ old('description', $asset->description) }}</textarea>
                            @error('description')
                                <div class="text-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="serial_number" class="form-label">الرقم التسلسلي</label>
                                <input type="text" class="form-control" id="serial_number" name="serial_number" value="{{ old('serial_number', $asset->serial_number) }}">
                                @error('serial_number')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="value" class="form-label">القيمة (د.ك) <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="number" class="form-control" id="value" name="value" value="{{ old('value', $asset->value) }}" step="0.01" min="0" required>
                                    <span class="input-group-text">د.ك</span>
                                </div>
                                @error('value')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="purchase_date" class="form-label">تاريخ الشراء</label>
                                <input type="date" class="form-control" id="purchase_date" name="purchase_date" value="{{ old('purchase_date', $asset->purchase_date ? $asset->purchase_date->format('Y-m-d') : '') }}">
                                @error('purchase_date')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="warranty_expiry" class="form-label">انتهاء الضمان</label>
                                <input type="date" class="form-control" id="warranty_expiry" name="warranty_expiry" value="{{ old('warranty_expiry', $asset->warranty_expiry ? $asset->warranty_expiry->format('Y-m-d') : '') }}">
                                @error('warranty_expiry')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="location" class="form-label">الموقع</label>
                                <input type="text" class="form-control" id="location" name="location" value="{{ old('location', $asset->location) }}">
                                @error('location')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="status" class="form-label">الحالة <span class="text-danger">*</span></label>
                                <select class="form-control" id="status" name="status" required>
                                    <option value="available" {{ old('status', $asset->status) == 'available' ? 'selected' : '' }}>متاح</option>
                                    <option value="assigned" {{ old('status', $asset->status) == 'assigned' ? 'selected' : '' }}>مُسنَد</option>
                                    <option value="maintenance" {{ old('status', $asset->status) == 'maintenance' ? 'selected' : '' }}>صيانة</option>
                                    <option value="retired" {{ old('status', $asset->status) == 'retired' ? 'selected' : '' }}>متقاعد</option>
                                    <option value="damaged" {{ old('status', $asset->status) == 'damaged' ? 'selected' : '' }}>تالف</option>
                                </select>
                                @error('status')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="photo" class="form-label">صورة الأصل (اختياري)</label>
                            <input type="file" class="form-control" id="photo" name="photo" accept="image/*">
                            @if($asset->photo)
                                <div class="mt-2">
                                    <img src="{{ asset('storage/' . $asset->photo) }}" alt="صورة الأصل الحالية" class="img-thumbnail" width="100">
                                    <small class="text-muted d-block">اتركه فارغاً إذا لم ترد تغيير الصورة</small>
                                </div>
                            @endif
                            @error('photo')
                                <div class="text-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-warning">
                                <i class="fas fa-save"></i> تحديث الأصل
                            </button>
                            <a href="{{ route('assets.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> رجوع
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Asset Info Card -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">معلومات الأصل</h5>
                    <table class="table table-borderless">
                        <tr>
                            <th>الحالة الحالية:</th>
                            <td>
                                @if($asset->status == 'available')
                                    <span class="badge badge-success">متاح</span>
                                @elseif($asset->status == 'assigned')
                                    <span class="badge badge-primary">مُسنَد</span>
                                @elseif($asset->status == 'maintenance')
                                    <span class="badge badge-warning">صيانة</span>
                                @elseif($asset->status == 'retired')
                                    <span class="badge badge-secondary">متقاعد</span>
                                @elseif($asset->status == 'damaged')
                                    <span class="badge badge-danger">تالف</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>تاريخ الإنشاء:</th>
                            <td>{{ $asset->created_at->format('Y-m-d H:i') }}</td>
                        </tr>
                        <tr>
                            <th>آخر تحديث:</th>
                            <td>{{ $asset->updated_at->format('Y-m-d H:i') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection