<?php /* Blade view - permission report */ ?>
@extends('layouts.app')

@section('content')
<div class="container">
    <h2>Permission Report</h2>

    <p>Showing users and their effective permissions with reasons (Explicit Allow / Explicit Deny / Via Role).</p>

    @foreach($report as $row)
        <div class="card mb-3">
            <div class="card-header">
                {{ $row['user']->name }} &lt;{{ $row['user']->email }}&gt; — Roles: {{ implode(', ', $row['user']->roles->pluck('name')->toArray()) }}
            </div>
            <div class="card-body">
                <div class="row">
                    @foreach($row['permissions'] as $p)
                        <div class="col-md-4 mb-1">
                            <strong>{{ $p['perm'] }}</strong>
                            <div>{{ $p['status'] }}</div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endforeach

    {{ $users->links() }}
</div>

@endsection
