@extends('layouts.app')

@section('content')
<div class="container">
    <h2>Manage Users Permissions</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="mb-3 row">
        <div class="col-md-6">
            <input id="search" class="form-control" placeholder="Search users by name or email..." />
        </div>
    </div>

    <table class="table table-hover">
        <thead>
            <tr>
                <th>#</th>
                <th>User</th>
                <th>Email</th>
                <th>Role</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
        @foreach($users as $user)
            <tr>
                <td>{{ $user->id }}</td>
                <td>{{ $user->name }}</td>
                <td>{{ $user->email }}</td>
                <td>
                    @php
                        $role = \Illuminate\Support\Facades\DB::table('user_role')->join('roles','user_role.role_id','=','roles.id')
                            ->where('user_role.user_id', $user->id)->value('roles.name');
                    @endphp
                    <span class="badge badge-secondary">{{ $role ?? '-' }}</span>
                </td>
                <td>
                    <a href="{{ route('admin.permissions.edit', $user->id) }}" class="btn btn-sm btn-outline-primary">Edit</a>
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>

    <div class="d-flex justify-content-center">{{ $users->links() }}</div>

@push('scripts')
<script>
const searchInput = document.getElementById('search');
let timeout = null;
searchInput.addEventListener('input', function(){
    clearTimeout(timeout);
    timeout = setTimeout(()=> doSearch(this.value), 300);
});

async function doSearch(q){
    const tbody = document.querySelector('table.table tbody');
    const url = `{{ url('/admin/permissions') }}?q=${encodeURIComponent(q)}`;
    const res = await fetch(url, { headers: { 'Accept': 'application/json' } });
    if (!res.ok) return;
    const data = await res.json();
    tbody.innerHTML = '';
    data.data.forEach(u => {
        const role = u.roles.length ? u.roles[0].name : '-';
        const tr = document.createElement('tr');
        tr.innerHTML = `
            <td>${u.id}</td>
            <td>${u.name}</td>
            <td>${u.email}</td>
            <td><span class="badge bg-secondary">${role}</span></td>
            <td><a href="/admin/permissions/${u.id}/edit" class="btn btn-sm btn-outline-primary">Edit</a></td>
        `;
        tbody.appendChild(tr);
    });
}
</script>
@endpush
</div>
@endsection
