@extends('layouts.app')

@section('content')
@php use Illuminate\Support\Facades\URL; @endphp
<div class="container">
    <h2>Edit Permissions for {{ $user->name }} &lt;{{ $user->email }}&gt;</h2>

    <div id="alert" style="display:none" class="alert" role="alert"></div>

    <form id="permissionsForm">
        @csrf
        <div class="row">
            <div class="col-md-4">
                <label for="role">Role</label>
                <select id="role" name="role" class="form-control">
                    <option value="">-- keep current --</option>
                    @foreach($roles as $r)
                        <option value="{{ $r->name }}" {{ ($userRole === $r->name) ? 'selected' : '' }}>{{ $r->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-8 text-right">
                <button id="saveBtn" class="btn btn-primary mt-4">Save</button>
                <a href="{{ route('admin.permissions.index') }}" class="btn btn-secondary mt-4">Back</a>
            </div>
        </div>

        <hr />

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body" style="max-height:420px; overflow:auto;">
                        @foreach($permissions as $perm)
                            @php
                                $isAllowed = in_array($perm->id, $userPermissions);
                                $isDenied = in_array($perm->id, $userDeniedPermissions ?? []);
                                $state = $isAllowed ? 'allow' : ($isDenied ? 'deny' : 'default');
                            @endphp
                            <div class="form-group row align-items-center">
                                <label class="col-6 col-form-label">
                                    {{ $perm->name }}
                                    @php
                                        $viaRole = false;
                                        $userRolesForCheck = $user->roles ?? [];
                                        foreach($userRolesForCheck as $r) {
                                            $roleName = is_object($r) ? ($r->name ?? null) : ($r['name'] ?? null);
                                            $rolePermIds = [];

                                            // role permissions may be a Collection, an array of models/arrays, or not present
                                            if (is_object($r) && isset($r->permissions)) {
                                                if (is_object($r->permissions) && method_exists($r->permissions, 'pluck')) {
                                                    $rolePermIds = $r->permissions->pluck('id')->toArray();
                                                } elseif (is_array($r->permissions)) {
                                                    foreach ($r->permissions as $rp) {
                                                        if (is_object($rp)) $rolePermIds[] = $rp->id ?? null;
                                                        elseif (is_array($rp)) $rolePermIds[] = $rp['id'] ?? null;
                                                    }
                                                }
                                            } elseif (is_array($r) && isset($r['permissions']) && is_array($r['permissions'])) {
                                                foreach ($r['permissions'] as $rp) {
                                                    if (is_array($rp)) $rolePermIds[] = $rp['id'] ?? null;
                                                    elseif (is_object($rp)) $rolePermIds[] = $rp->id ?? null;
                                                    else $rolePermIds[] = $rp;
                                                }
                                            }

                                            if (!empty($rolePermIds) && in_array($perm->id, array_filter($rolePermIds))) {
                                                $viaRole = $roleName ?: true;
                                                break;
                                            }
                                        }
                                    @endphp
                                    @if($isAllowed)
                                        <span class="badge bg-success ms-2">Allowed</span>
                                    @elseif($isDenied)
                                        <span class="badge bg-danger ms-2">Denied</span>
                                    @elseif($viaRole)
                                        <span class="badge bg-info text-dark ms-2">Via role: {{ $viaRole }}</span>
                                    @else
                                        <span class="badge bg-secondary ms-2">Not granted</span>
                                    @endif
                                </label>
                                <div class="col-6 d-flex">
                                    <div class="form-check me-2">
                                        <input class="form-check-input" type="radio" name="permissions[{{ $perm->id }}]" id="perm_{{ $perm->id }}_allow" value="allow" {{ $state === 'allow' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="perm_{{ $perm->id }}_allow">Allow</label>
                                    </div>
                                    <div class="form-check me-2">
                                        <input class="form-check-input" type="radio" name="permissions[{{ $perm->id }}]" id="perm_{{ $perm->id }}_default" value="default" {{ $state === 'default' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="perm_{{ $perm->id }}_default">Default</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="permissions[{{ $perm->id }}]" id="perm_{{ $perm->id }}_deny" value="deny" {{ $state === 'deny' ? 'checked' : '' }}>
                                        <label class="form-check-label text-danger" for="perm_{{ $perm->id }}_deny">Deny</label>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

@push('scripts')
<script>
document.getElementById('permissionsForm').addEventListener('submit', async function(e){
    e.preventDefault();
    const btn = document.getElementById('saveBtn');
    btn.disabled = true; btn.textContent = 'Saving...';

    const form = e.target;
    const data = new FormData(form);

    const url = '{{ route("admin.permissions.update", ["user" => $user->id]) }}';

    try {
        const res = await fetch(url, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value,
                'Accept': 'application/json'
            },
            body: data
        });

        if (!res.ok) throw res;

        const json = await res.json();
        showAlert('success', json.message || 'Saved');
    } catch (err) {
        let text = 'An error occurred';
        try { const j = await err.json(); text = j.message || JSON.stringify(j); } catch(e) {}
        showAlert('danger', text);
    } finally {
        btn.disabled = false; btn.textContent = 'Save';
    }
});

function showAlert(type, message) {
    const a = document.getElementById('alert');
    a.className = 'alert alert-' + type;
    a.textContent = message;
    a.style.display = 'block';
    setTimeout(()=> a.style.display = 'none', 4000);
}
</script>
@endpush

@endsection
