<?php

return [
    'breadcrumb' => [
        'home' => 'Accueil',
        'leaves' => 'Congés',
    ],

    'unknown_employee' => 'Employé inconnu',
    'not_specified' => 'Non spécifié',
    'no_reason' => 'Aucune raison fournie',
    'days_unit' => 'jours',

    'show' => [
        'title' => 'Détails de la demande de congé',
        'breadcrumb' => 'Détails de la demande',
        'request' => 'Demande de congé n°:id',
        'submitted_by' => 'Soumis par',
        'leave_info' => 'Informations sur le congé',
        'request_details' => 'Détails de la demande',
        'monthly_accumulation' => 'Accumulation mensuelle (:year)',
        'overdrawn' => '⚠️ L\'employé a dépassé son solde de :days jours — une retenue peut être recommandée.',
        'total_remaining' => '✅ Solde restant total à ce jour : :days jours.',
    ],

    'create' => [
        'title' => 'Créer une demande de congé',
        'breadcrumb' => 'Créer la demande',
        'form_title' => 'Formulaire de demande de congé',
    ],

    'edit' => [
        'title' => 'Modifier la demande de congé',
        'breadcrumb' => 'Modifier la demande',
        'form_title' => 'Formulaire de modification',
    ],

    'fields' => [
        'type' => 'Type de congé :',
        'from' => 'De',
        'to' => 'À',
        'days' => 'Jours',
        'requested_at' => 'Date de la demande',
        'updated_at' => 'Dernière mise à jour',
        'contact' => 'Coordonnées',
        'reason' => 'Motif',
        'rejection_reason' => 'Motif du refus',
    ],

    'monthly_headers' => [
        'month' => 'Mois',
        'granted' => 'Attribué',
        'used' => 'Utilisé',
        'remaining' => 'Solde cumulatif',
    ],

    'index' => [
        'title' => 'Gestion des congés',
        'stats' => [
            'total_requests' => 'Total des demandes',
            'approved' => 'Approuvées',
            'pending' => 'En attente',
            'rejected' => 'Refusées',
            'cancelled' => 'Annulées',
            'modified' => 'Modifiées',
        ],
        'requests_title' => 'Demandes de congé',
        'new_request_button' => 'Nouvelle demande',
        'empty' => 'Aucune demande de congé trouvée',
    ],

    'filters' => [
        'search_placeholder' => 'Rechercher un employé...',
        'all_employees' => 'Tous les employés',
        'all_statuses' => 'Tous les statuts',
        'all_types' => 'Tous les types',
        'all_months' => 'Tous les mois',
        'all_years' => 'Toutes les années',
        'apply' => 'Appliquer',
        'reset' => 'Réinitialiser',
    ],

    'table' => [
        'employee_name' => 'Nom de l\'employé',
        'type' => 'Type',
        'from' => 'De',
        'to' => 'À',
        'days' => 'Jours',
        'reason' => 'Motif',
        'requested_at' => 'Date',
        'status' => 'Statut',
        'actions' => 'Actions',
    ],

    'rules' => [
        'title' => 'Règles générales des congés',
        'html' => '<p class="text-muted mb-3">Ces règles expliquent le fonctionnement du système de congés. Veuillez les lire attentivement avant de soumettre une demande.</p>
<ul class="list-unstyled">
<li class="mb-2"><strong>1. Types de congés :</strong> Le système prend en charge plusieurs types : annuel, maladie, urgence, maternité, paternité, sans solde.</li>
<li class="mb-2"><strong>2. Congés annuels :</strong> Ils sont accordés mensuellement selon l\'allocation définie pour l\'employé.</li>
<li class="mb-2"><strong>3. Accumulation :</strong> Les jours non utilisés sont reportés et ajoutés au solde du mois suivant.</li>
<li class="mb-2"><strong>4. Déduction de salaire :</strong> Si le congé dépasse le solde disponible, les jours supplémentaires peuvent être déduits du salaire.</li>
<li class="mb-2"><strong>5. Statut de la demande :</strong> Les demandes peuvent être <span class="badge bg-warning text-dark">en attente</span>, <span class="badge bg-success">approuvées</span>, <span class="badge bg-danger">refusées</span> ou <span class="badge bg-secondary">annulées</span>.</li>
<li class="mb-2"><strong>6. Modification/Annulation :</strong> Les employés peuvent modifier ou annuler une demande tant qu\'elle est en attente.</li>
<li class="mb-2"><strong>9. Congés sans solde :</strong> N\'affectent pas le salaire ; les congés maladie sont enregistrés mais non déduits.</li>
<li class="mb-2"><strong>10. Impression :</strong> Vous pouvez imprimer les détails depuis la page de visualisation.</li>
</ul>',
    ],

    'types' => [
        'annual' => 'Congé annuel',
        'sick' => 'Congé maladie',
        'emergency' => 'Congé d\'urgence',
        'maternity' => 'Congé maternité',
        'paternity' => 'Congé paternité',
        'unpaid' => 'Congé sans solde',
    ],

    'status' => [
        'pending' => 'En attente',
        'approved' => 'Approuvé',
        'rejected' => 'Refusé',
        'cancelled' => 'Annulé',
        'modified' => 'Modifié',
    ],

    'actions' => [
        'view' => 'Voir',
        'edit' => 'Modifier',
        'cancel' => 'Annuler',
    ],

    'confirm' => [
        'cancel' => 'Êtes-vous sûr de vouloir annuler ce congé ?',
        'approve' => 'Êtes-vous sûr de vouloir approuver cette demande ?',
        'reject' => 'Êtes-vous sûr de vouloir refuser cette demande ?',
        'delete' => 'Êtes-vous sûr de vouloir supprimer cette demande ?',
    ],

    'form' => [
        'employee' => 'Employé',
        'select_employee' => 'Sélectionner un employé',
        'leave_type' => 'Type de congé',
        'select_type' => 'Sélectionner un type',
        'start_date' => 'Date de début',
        'end_date' => 'Date de fin',
        'days_count' => 'Nombre de jours',
        'reason' => 'Motif',
        'reason_placeholder' => 'Veuillez décrire le motif du congé en détail',
        'contact_details' => 'Coordonnées pendant le congé',
        'contact_placeholder' => 'Téléphone ou e-mail',
        'submit' => 'Soumettre la demande',
        'back' => 'Retour',
        'save_changes' => 'Enregistrer les modifications',
    ],
];
