<?php

return [
    'stats' => [
        'inactive_title' => 'Employés désactivés / sortants',
        'inactive_subtitle' => 'Dernière mise à jour des données',
        'active_title' => 'Employés actifs',
        'active_subtitle' => 'Effectif actuel',
        'pending_title' => 'Employés en attente',
        'pending_subtitle' => 'En attente d’examen ou d’intégration',
        'total_title' => 'Total des employés',
        'total_subtitle' => 'Toutes les fiches du système',
    ],

    'filters' => [
        'quick_search_label' => 'Recherche rapide (nom/email)',
        'search_placeholder' => 'Tapez pour rechercher...',
        'department_label' => 'Filtrer par département',
        'department_all' => 'Tous les départements',
        'position_label' => 'Filtrer par poste',
        'position_all' => 'Tous les postes',
        'status_label' => 'Filtrer par statut',
        'status_all' => 'Tous les statuts',
        'reset_button' => 'Effacer les filtres',
        'reset_title' => 'Réinitialiser les filtres',
    ],

    'table' => [
        'photo' => 'Photo',
        'name' => 'Nom (#ID)',
        'email' => 'Courriel',
        'department' => 'Département',
        'salary' => 'Salaire de base (:currency)',
        'incentives' => 'Primes (:currency)',
        'status' => 'Statut',
        'position' => 'Poste',
        'actions' => 'Actions',
        'not_specified' => 'Non spécifié',
        'actions_view' => 'Voir les détails',
        'actions_edit' => 'Modifier',
        'actions_delete' => 'Supprimer',
    ],

    'messages' => [
        'delete_confirm' => 'Voulez-vous vraiment supprimer cet employé ? Il ne pourra plus se connecter.',
    ],

    'status_unknown' => 'Inconnu',

    'show' => [
        'jump_description' => 'Utilisez ces boutons rapides pour naviguer entre les sections de la page.',
        'buttons' => [
            'personal_info' => 'Informations personnelles',
            'salary_components' => 'Composants du salaire',
            'leave_accrual' => 'Détails de la déduction des congés (mensuel et annuel)',
            'attendance' => 'Présences',
            'leave_requests' => 'Demandes de congé',
            'loans' => 'Prêts',
            'deductions' => 'Déductions',
            'payroll_summary' => 'Résumé des paies',
            'paid_salaries' => 'Salaires payés',
        ],
        'profile' => [
            'position_placeholder' => 'Non spécifié',
            'department_placeholder' => 'Non spécifié',
            'badges' => [
                'id' => 'ID',
                'email' => 'Courriel',
                'phone' => 'Téléphone',
            ],
        ],
        'actions' => [
            'edit' => 'Modifier',
            'delete' => 'Supprimer',
            'delete_confirm' => 'Voulez-vous vraiment supprimer cet employé ?',
            'back' => 'Retour',
        ],
        'sections' => [
            'personal_info' => 'Informations personnelles',
            'salary_components' => 'Composants du salaire',
            'leave_accrual' => 'Détails de la déduction des congés (mensuel et annuel)',
            'attendance' => 'Présences',
            'leave_requests' => 'Demandes de congé',
            'loan_records' => 'Historique des prêts',
            'deduction_records' => 'Historique des déductions',
            'payroll_summary' => 'Résumé des paies (10 dernières)',
            'paid_salaries' => 'Salaires payés',
        ],
        'personal' => [
            'birth_date' => 'Date de naissance',
            'age' => 'Âge',
            'age_unit' => 'ans',
            'national_id' => 'Numéro national',
            'qualification' => 'Qualification',
            'address' => 'Adresse',
            'status' => 'Statut',
            'status_labels' => [
                'active' => 'Actif',
                'inactive' => 'Inactif',
                'pending' => 'En cours d’embauche',
                'unknown' => 'Non spécifié',
            ],
        ],
        'salary' => [
            'name' => 'Nom',
            'value' => 'Montant',
            'no_components' => 'Aucun composant salarial supplémentaire.',
            'total' => 'Salaire total estimé :',
        ],
        'leave_accrual' => [
            'title' => 'Détails de la déduction des congés (mensuel et annuel)',
            'labels' => [
                'monthly' => 'Mensuel',
                'annual' => 'Annuel',
            ],
            'print' => 'Imprimer les détails',
            'columns' => [
                'year' => 'Année',
                'month' => 'Mois',
                'granted' => 'Crédité ce mois',
                'used' => 'Utilisé ce mois',
                'excess' => 'Excès (jours)',
                'balance_before' => 'Solde avant déduction',
                'balance_after' => 'Solde après déduction',
                'amount' => 'Déduction congés (:currency)',
                'annual_entitlement' => 'Droit annuel',
                'annual_granted' => 'Total accordé cette année',
                'annual_used' => 'Total utilisé cette année',
                'annual_excess' => 'Excès annuel (jours)',
                'annual_remaining' => 'Solde restant annuel',
                'annual_amount' => 'Déduction annuelle (:currency)',
            ],
            'no_data' => 'Aucune donnée mensuelle pour le moment.',
        ],
        'filters' => [
            'all_months' => 'Tous les mois',
            'all_years' => 'Toutes les années',
            'apply' => 'Appliquer',
            'print_record' => 'Imprimer le registre',
            'print_summary' => 'Imprimer le résumé',
        ],
        'attendance' => [
            'title' => 'Présences',
            'columns' => [
                'date' => 'Date',
                'check_in' => 'Arrivée',
                'check_out' => 'Départ',
                'duration' => 'Durée',
                'status' => 'Statut',
                'actions' => 'Actions',
            ],
            'no_records' => 'Aucun enregistrement de présence.',
        ],
        'leaves' => [
            'title' => 'Demandes de congé',
            'columns' => [
                'id' => '#',
                'type' => 'Type de congé',
                'start' => 'Date de début',
                'end' => 'Date de fin',
                'days' => 'Nombre de jours',
                'reason' => 'Motif',
                'status' => 'Statut',
                'actions' => 'Actions',
            ],
            'statuses' => [
                'pending' => 'En attente',
                'approved' => 'Approuvé',
                'rejected' => 'Rejeté',
            ],
            'no_records' => 'Aucune demande de congé.',
            'delete_confirm' => 'Voulez-vous vraiment supprimer cette demande de congé ?',
        ],
        'loans' => [
            'title' => 'Historique des prêts',
            'columns' => [
                'id' => '#',
                'amount' => 'Montant',
                'interest' => 'Intérêt (%)',
                'total' => 'Montant total',
                'installments' => 'Nombre d’échéances',
                'monthly' => 'Échéance mensuelle',
                'date' => 'Date de demande',
                'status' => 'Statut',
                'actions' => 'Actions',
            ],
            'statuses' => [
                'pending' => 'En attente',
                'approved' => 'Approuvé',
                'active' => 'Actif',
                'rejected' => 'Rejeté',
                'paid' => 'Payé intégralement',
                'cancelled' => 'Annulé',
                'unknown' => 'Non spécifié',
            ],
            'no_records' => 'Aucun prêt.',
            'delete_confirm' => 'Voulez-vous vraiment supprimer ce prêt ?',
        ],
        'deductions' => [
            'title' => 'Historique des déductions',
            'columns' => [
                'id' => '#',
                'description' => 'Description',
                'amount' => 'Montant',
                'type' => 'Type',
                'date' => 'Date de déduction',
                'status' => 'Statut',
                'actions' => 'Actions',
            ],
            'statuses' => [
                'applied' => 'Appliqué',
                'pending' => 'En attente',
                'cancelled' => 'Annulé',
                'unknown' => 'Non spécifié',
            ],
            'no_records' => 'Aucune déduction.',
            'delete_confirm' => 'Voulez-vous vraiment supprimer cette déduction ?',
        ],
        'payroll_summary' => [
            'title' => 'Résumé des paies (10 dernières)',
            'columns' => [
                'month' => 'Mois',
                'gross' => 'Salaire brut',
                'other_deductions' => 'Autres déductions',
                'loans' => 'Échéances de prêt',
                'leave' => 'Déduction congés',
                'net' => 'Salaire net',
                'actions' => 'Actions',
            ],
            'view' => 'Voir',
            'no_records' => 'Aucune paie.',
        ],
        'paid_salaries' => [
            'title' => 'Salaires payés',
            'columns' => [
                'month' => 'Mois',
                'gross' => 'Salaire total',
                'deductions' => 'Déductions',
                'loans' => 'Prêts',
                'leave' => 'Déduction congés',
                'net' => 'Salaire net',
                'paid_at' => 'Date de paiement',
            ],
            'no_records' => 'Aucun salaire payé.',
            'not_paid' => 'Pas encore payé',
        ],
        'deduction_types' => [
            'tax' => 'Impôt',
            'insurance' => 'Assurance',
            'loan' => 'Prêt',
            'fine' => 'Amende',
            'other' => 'Autre',
            'cash' => 'Espèces',
            'in_kind' => 'En nature',
            'deduction' => 'Déduction',
            'penalty' => 'Pénalité',
            'subscription' => 'Abonnement',
            'absence' => 'Absence',
            'cash_deduction' => 'Déduction en espèces',
            'in_kind_deduction' => 'Déduction en nature',
        ],
    ],
    'salary_histories' => [
        'title' => 'سجل الرواتب',
        'no_records' => 'Aucun enregistrement trouvé.',
        'add_new' => 'Ajouter un Nouvel Enregistrement',
        'edit_record' => 'Modifier l\'Enregistrement',
        'table' => [
            'effective_from' => 'Effectif À Partir De',
            'base_salary' => 'Salaire de Base',
            'incentives' => 'Incitations',
            'overtime_rate' => 'Heures Supplémentaires/Heure',
            'monthly_leave' => 'Congé Mensuel',
            'annual_leave' => 'Congé Annuel',
            'components' => 'Composants Supplémentaires',
            'note' => 'Notes',
            'actions' => 'Actions',
        ],
        'form' => [
            'effective_from' => 'Date d\'Entrée en Vigueur',
            'effective_from_hint' => 'Sera automatiquement converti au début du mois',
            'base_salary' => 'Salaire de Base',
            'incentives' => 'Incitations',
            'overtime_rate' => 'Taux d\'Heures Supplémentaires (par heure)',
            'monthly_leave_entitlement' => 'Droit aux Congés Mensuels',
            'annual_leave_entitlement' => 'Droit aux Congés Annuels',
            'components' => 'Composants Salariaux Supplémentaires',
            'component_name_placeholder' => 'Nom du composant (ex: Allocation de Logement)',
            'component_value_placeholder' => 'Valeur',
            'add_component' => 'Ajouter un Nouveau Composant',
            'remove_component' => 'Supprimer',
            'note' => 'Notes',
            'save' => 'Enregistrer les Modifications',
            'add' => 'Ajouter',
        ],
        'messages' => [
            'delete_confirm' => 'Êtes-vous sûr?',
        ],
    ],
];

