<?php

return [
    'breadcrumb' => [
        'home' => 'Inicio',
        'leaves' => 'Permisos',
    ],

    'unknown_employee' => 'Empleado desconocido',
    'not_specified' => 'No especificado',
    'no_reason' => 'Sin motivo proporcionado',
    'days_unit' => 'días',

    'show' => [
        'title' => 'Detalles de la solicitud de permiso',
        'breadcrumb' => 'Detalles de la solicitud',
        'request' => 'Solicitud de permiso #:id',
        'submitted_by' => 'Enviado por',
        'leave_info' => 'Información del permiso',
        'request_details' => 'Detalles de la solicitud',
        'monthly_accumulation' => 'Acumulado mensual (:year)',
        'overdrawn' => '⚠️ El empleado excedió su saldo por :days días — se recomienda deducción.',
        'total_remaining' => '✅ Saldo total restante hasta ahora: :days días.',
    ],

    'create' => [
        'title' => 'Crear solicitud de permiso',
        'breadcrumb' => 'Crear solicitud',
        'form_title' => 'Formulario de solicitud de permiso',
    ],

    'edit' => [
        'title' => 'Editar solicitud de permiso',
        'breadcrumb' => 'Editar solicitud',
        'form_title' => 'Formulario de edición',
    ],

    'fields' => [
        'type' => 'Tipo de permiso:',
        'from' => 'Desde',
        'to' => 'Hasta',
        'days' => 'Días',
        'requested_at' => 'Fecha de solicitud',
        'updated_at' => 'Última actualización',
        'contact' => 'Datos de contacto',
        'reason' => 'Motivo',
        'rejection_reason' => 'Motivo del rechazo',
    ],

    'monthly_headers' => [
        'month' => 'Mes',
        'granted' => 'Otorgado',
        'used' => 'Usado',
        'remaining' => 'Saldo acumulado',
    ],

    'index' => [
        'title' => 'Gestión de permisos',
        'stats' => [
            'total_requests' => 'Solicitudes totales',
            'approved' => 'Aprobadas',
            'pending' => 'Pendientes',
            'rejected' => 'Rechazadas',
            'cancelled' => 'Canceladas',
            'modified' => 'Modificadas',
        ],
        'requests_title' => 'Solicitudes de permiso',
        'new_request_button' => 'Nueva solicitud',
        'empty' => 'No se encontraron solicitudes de permiso',
    ],

    'filters' => [
        'search_placeholder' => 'Buscar empleado...',
        'all_employees' => 'Todos los empleados',
        'all_statuses' => 'Todos los estados',
        'all_types' => 'Todos los tipos',
        'all_months' => 'Todos los meses',
        'all_years' => 'Todos los años',
        'apply' => 'Aplicar',
        'reset' => 'Restablecer',
    ],

    'table' => [
        'employee_name' => 'Nombre del empleado',
        'type' => 'Tipo',
        'from' => 'Desde',
        'to' => 'Hasta',
        'days' => 'Días',
        'reason' => 'Motivo',
        'requested_at' => 'Fecha',
        'status' => 'Estado',
        'actions' => 'Acciones',
    ],

    'rules' => [
        'title' => 'Reglas generales de permisos',
        'html' => '<p class="text-muted mb-3">Estas reglas explican cómo funciona el sistema de permisos. Léalas antes de enviar una solicitud.</p>
<ul class="list-unstyled">
<li class="mb-2"><strong>1. Tipos de permisos:</strong> El sistema admite: anual, enfermedad, emergencia, maternidad, paternidad, sin sueldo.</li>
<li class="mb-2"><strong>2. Permisos anuales:</strong> Se otorgan mensualmente según la asignación del empleado.</li>
<li class="mb-2"><strong>3. Acumulación:</strong> Los días no usados se acumulan y se añaden al mes siguiente.</li>
<li class="mb-2"><strong>4. Deducción salarial:</strong> Si se excede el saldo disponible, los días extra pueden deducirse del salario.</li>
<li class="mb-2"><strong>5. Estado de la solicitud:</strong> Las solicitudes pueden estar <span class="badge bg-warning text-dark">pendientes</span>, <span class="badge bg-success">aprobadas</span>, <span class="badge bg-danger">rechazadas</span> o <span class="badge bg-secondary">canceladas</span>.</li>
<li class="mb-2"><strong>6. Modificar/Cancelar:</strong> Los empleados pueden modificar o cancelar una solicitud mientras esté pendiente.</li>
<li class="mb-2"><strong>9. Permisos sin sueldo:</strong> No afectan el salario; los permisos por enfermedad se registran pero no se deducen.</li>
<li class="mb-2"><strong>10. Impresión:</strong> Puede imprimir los detalles desde la página de visualización.</li>
</ul>',
    ],

    'types' => [
        'annual' => 'Permiso anual',
        'sick' => 'Permiso por enfermedad',
        'emergency' => 'Permiso de emergencia',
        'maternity' => 'Permiso de maternidad',
        'paternity' => 'Permiso de paternidad',
        'unpaid' => 'Permiso sin sueldo',
    ],

    'status' => [
        'pending' => 'Pendiente',
        'approved' => 'Aprobado',
        'rejected' => 'Rechazado',
        'cancelled' => 'Cancelado',
        'modified' => 'Modificado',
    ],

    'actions' => [
        'view' => 'Ver',
        'edit' => 'Editar',
        'cancel' => 'Cancelar',
    ],

    'confirm' => [
        'cancel' => '¿Está seguro de que desea cancelar este permiso?',
        'approve' => '¿Está seguro de que desea aprobar esta solicitud?',
        'reject' => '¿Está seguro de que desea rechazar esta solicitud?',
        'delete' => '¿Está seguro de que desea eliminar esta solicitud?',
    ],

    'form' => [
        'employee' => 'Empleado',
        'select_employee' => 'Seleccione un empleado',
        'leave_type' => 'Tipo de permiso',
        'select_type' => 'Seleccione un tipo',
        'start_date' => 'Fecha de inicio',
        'end_date' => 'Fecha de fin',
        'days_count' => 'Número de días',
        'reason' => 'Motivo',
        'reason_placeholder' => 'Describa el motivo del permiso con detalle',
        'contact_details' => 'Detalles de contacto durante el permiso',
        'contact_placeholder' => 'Teléfono o correo electrónico',
        'submit' => 'Enviar solicitud',
        'back' => 'Volver',
        'save_changes' => 'Guardar cambios',
    ],
];
