<?php

return [
    'stats' => [
        'inactive_title' => 'Empleados inactivos / dados de baja',
        'inactive_subtitle' => 'Última actualización de datos',
        'active_title' => 'Empleados activos',
        'active_subtitle' => 'Fuerza laboral actual',
        'pending_title' => 'Empleados pendientes',
        'pending_subtitle' => 'En espera de revisión o incorporación',
        'total_title' => 'Total de empleados',
        'total_subtitle' => 'Todos los registros del sistema',
    ],

    'filters' => [
        'quick_search_label' => 'Búsqueda rápida (nombre/correo)',
        'search_placeholder' => 'Escribe para buscar...',
        'department_label' => 'Filtrar por departamento',
        'department_all' => 'Todos los departamentos',
        'position_label' => 'Filtrar por puesto',
        'position_all' => 'Todos los puestos',
        'status_label' => 'Filtrar por estado',
        'status_all' => 'Todos los estados',
        'reset_button' => 'Limpiar filtros',
        'reset_title' => 'Restablecer filtros',
    ],

    'table' => [
        'photo' => 'Foto',
        'name' => 'Nombre (#ID)',
        'email' => 'Correo electrónico',
        'department' => 'Departamento',
        'salary' => 'Salario base (:currency)',
        'incentives' => 'Incentivos (:currency)',
        'status' => 'Estado',
        'position' => 'Puesto',
        'actions' => 'Acciones',
        'not_specified' => 'No especificado',
        'actions_view' => 'Ver detalles',
        'actions_edit' => 'Editar',
        'actions_delete' => 'Eliminar',
    ],

    'messages' => [
        'delete_confirm' => '¿Está seguro de que desea eliminar a este empleado? No podrá iniciar sesión nuevamente.',
    ],

    'status_unknown' => 'Desconocido',

    'show' => [
        'jump_description' => 'Utiliza estos botones rápidos para saltar entre las secciones de la página.',
        'buttons' => [
            'personal_info' => 'Información personal',
            'salary_components' => 'Componentes salariales',
            'leave_accrual' => 'Detalle de descuento por permisos (mensual y anual)',
            'attendance' => 'Registros de asistencia',
            'leave_requests' => 'Solicitudes de permisos',
            'loans' => 'Historial de préstamos',
            'deductions' => 'Historial de deducciones',
            'payroll_summary' => 'Resumen de nóminas',
            'paid_salaries' => 'Nóminas pagadas',
        ],
        'profile' => [
            'position_placeholder' => 'No especificado',
            'department_placeholder' => 'No especificado',
            'badges' => [
                'id' => 'ID',
                'email' => 'Correo',
                'phone' => 'Teléfono',
            ],
        ],
        'actions' => [
            'edit' => 'Editar',
            'delete' => 'Eliminar',
            'delete_confirm' => '¿Seguro que deseas eliminar a este empleado?',
            'back' => 'Volver',
        ],
        'sections' => [
            'personal_info' => 'Información personal',
            'salary_components' => 'Componentes salariales',
            'leave_accrual' => 'Detalle de descuento por permisos (mensual y anual)',
            'attendance' => 'Registros de asistencia',
            'leave_requests' => 'Solicitudes de permisos',
            'loan_records' => 'Historial de préstamos',
            'deduction_records' => 'Historial de deducciones',
            'payroll_summary' => 'Resumen de nóminas (últimas 10)',
            'paid_salaries' => 'Nóminas pagadas',
        ],
        'personal' => [
            'birth_date' => 'Fecha de nacimiento',
            'age' => 'Edad',
            'age_unit' => 'años',
            'national_id' => 'Identificación nacional',
            'qualification' => 'Formación',
            'address' => 'Dirección',
            'status' => 'Estado',
            'status_labels' => [
                'active' => 'Activo',
                'inactive' => 'Inactivo',
                'pending' => 'En proceso de contratación',
                'unknown' => 'No especificado',
            ],
        ],
        'salary' => [
            'name' => 'Nombre',
            'value' => 'Monto',
            'no_components' => 'No hay componentes salariales adicionales.',
            'total' => 'Salario total estimado:',
        ],
        'leave_accrual' => [
            'title' => 'Detalle de descuento por permisos (mensual y anual)',
            'labels' => [
                'monthly' => 'Mensual',
                'annual' => 'Anual',
            ],
            'print' => 'Imprimir detalles',
            'columns' => [
                'year' => 'Año',
                'month' => 'Mes',
                'granted' => 'Otorgado este mes',
                'used' => 'Usado este mes',
                'excess' => 'Exceso (días)',
                'balance_before' => 'Saldo antes del descuento',
                'balance_after' => 'Saldo después del descuento',
                'amount' => 'Descuento por permisos (:currency)',
                'annual_entitlement' => 'Derecho anual',
                'annual_granted' => 'Total concedido este año',
                'annual_used' => 'Total usado este año',
                'annual_excess' => 'Exceso anual (días)',
                'annual_remaining' => 'Saldo anual restante',
                'annual_amount' => 'Descuento anual (:currency)',
            ],
            'no_data' => 'Aún no hay datos mensuales de acumulación.',
        ],
        'filters' => [
            'all_months' => 'Todos los meses',
            'all_years' => 'Todos los años',
            'apply' => 'Aplicar',
            'print_record' => 'Imprimir registro',
            'print_summary' => 'Imprimir resumen',
        ],
        'attendance' => [
            'title' => 'Registros de asistencia',
            'columns' => [
                'date' => 'Fecha',
                'check_in' => 'Hora de entrada',
                'check_out' => 'Hora de salida',
                'duration' => 'Duración',
                'status' => 'Estado',
                'actions' => 'Acciones',
            ],
            'no_records' => 'No hay registros de asistencia.',
        ],
        'leaves' => [
            'title' => 'Solicitudes de permisos',
            'columns' => [
                'id' => '#',
                'type' => 'Tipo de permiso',
                'start' => 'Fecha de inicio',
                'end' => 'Fecha de fin',
                'days' => 'Días',
                'reason' => 'Motivo',
                'status' => 'Estado',
                'actions' => 'Acciones',
            ],
            'statuses' => [
                'pending' => 'Pendiente',
                'approved' => 'Aprobado',
                'rejected' => 'Rechazado',
            ],
            'no_records' => 'No hay solicitudes de permisos.',
            'delete_confirm' => '¿Seguro que deseas eliminar esta solicitud?',
        ],
        'loans' => [
            'title' => 'Historial de préstamos',
            'columns' => [
                'id' => '#',
                'amount' => 'Monto',
                'interest' => 'Interés (%)',
                'total' => 'Monto total',
                'installments' => 'Cuotas',
                'monthly' => 'Cuota mensual',
                'date' => 'Fecha de solicitud',
                'status' => 'Estado',
                'actions' => 'Acciones',
            ],
            'statuses' => [
                'pending' => 'Pendiente',
                'approved' => 'Aprobado',
                'active' => 'Activo',
                'rejected' => 'Rechazado',
                'paid' => 'Pagado totalmente',
                'cancelled' => 'Cancelado',
                'unknown' => 'No especificado',
            ],
            'no_records' => 'No hay préstamos.',
            'delete_confirm' => '¿Seguro que deseas eliminar este préstamo?',
        ],
        'deductions' => [
            'title' => 'Historial de deducciones',
            'columns' => [
                'id' => '#',
                'description' => 'Descripción',
                'amount' => 'Monto',
                'type' => 'Tipo',
                'date' => 'Fecha de deducción',
                'status' => 'Estado',
                'actions' => 'Acciones',
            ],
            'statuses' => [
                'applied' => 'Aplicada',
                'pending' => 'Pendiente',
                'cancelled' => 'Cancelada',
                'unknown' => 'No especificado',
            ],
            'no_records' => 'No hay deducciones.',
            'delete_confirm' => '¿Seguro que deseas eliminar esta deducción?',
        ],
        'payroll_summary' => [
            'title' => 'Resumen de nóminas (últimas 10)',
            'columns' => [
                'month' => 'Mes',
                'gross' => 'Salario bruto',
                'other_deductions' => 'Otras deducciones',
                'loans' => 'Cuotas de préstamo',
                'leave' => 'Descuento por permisos',
                'net' => 'Salario neto',
                'actions' => 'Acciones',
            ],
            'view' => 'Ver',
            'no_records' => 'No hay registros de nóminas.',
        ],
        'paid_salaries' => [
            'title' => 'Nóminas pagadas',
            'columns' => [
                'month' => 'Mes',
                'gross' => 'Salario total',
                'deductions' => 'Deducciones',
                'loans' => 'Préstamos',
                'leave' => 'Descuento por permisos',
                'net' => 'Salario neto',
                'paid_at' => 'Fecha de pago',
            ],
            'no_records' => 'No hay nóminas pagadas.',
            'not_paid' => 'Aún no pagado',
        ],
        'deduction_types' => [
            'tax' => 'Impuesto',
            'insurance' => 'Seguro',
            'loan' => 'Préstamo',
            'fine' => 'Multa',
            'other' => 'Otro',
            'cash' => 'Efectivo',
            'in_kind' => 'En especie',
            'deduction' => 'Deducción',
            'penalty' => 'Penalización',
            'subscription' => 'Suscripción',
            'absence' => 'Ausencia',
            'cash_deduction' => 'Deducción en efectivo',
            'in_kind_deduction' => 'Deducción en especie',
        ],
    ],
    'salary_histories' => [
        'title' => 'سجل الرواتب',
        'no_records' => 'No se encontraron registros.',
        'add_new' => 'Agregar Nuevo Registro',
        'edit_record' => 'Editar Registro',
        'table' => [
            'effective_from' => 'Vigente Desde',
            'base_salary' => 'Salario Base',
            'incentives' => 'Incentivos',
            'overtime_rate' => 'Horas Extras/Hora',
            'monthly_leave' => 'Permiso Mensual',
            'annual_leave' => 'Permiso Anual',
            'components' => 'Componentes Adicionales',
            'note' => 'Notas',
            'actions' => 'Acciones',
        ],
        'form' => [
            'effective_from' => 'Fecha de Vigencia',
            'effective_from_hint' => 'Se convertirá automáticamente al inicio del mes',
            'base_salary' => 'Salario Base',
            'incentives' => 'Incentivos',
            'overtime_rate' => 'Tarifa de Horas Extras (por hora)',
            'monthly_leave_entitlement' => 'Derecho a Permiso Mensual',
            'annual_leave_entitlement' => 'Derecho a Permiso Anual',
            'components' => 'Componentes Salariales Adicionales',
            'component_name_placeholder' => 'Nombre del componente (ej: Subsidio de Vivienda)',
            'component_value_placeholder' => 'Valor',
            'add_component' => 'Agregar Nuevo Componente',
            'remove_component' => 'Eliminar',
            'note' => 'Notas',
            'save' => 'Guardar Cambios',
            'add' => 'Agregar',
        ],
        'messages' => [
            'delete_confirm' => '¿Estás seguro?',
        ],
    ],
];

