<?php

return [
    'page_title' => 'Loans Management',
    'breadcrumb_home' => 'Home',
    'breadcrumb_loans' => 'Loans',

    'cards' => [
        'total_loans' => 'Total Loans',
        'active' => 'Active',
        'pending' => 'Pending',
        'paid' => 'Paid',
    ],

    'stats' => [
        'payments_this_month' => 'Payments This Month',
        'payments_this_year' => 'Payments This Year',
        'deductions_this_month' => 'Deductions This Month',
        'deductions_this_year' => 'Deductions This Year',
    ],

    'buttons' => [
        'create' => 'Request New Loan',
        'reset_filters' => 'Reset',
    ],

    'filters' => [
        'search_placeholder' => 'Search by employee...',
        'all_employees' => 'All employees',
        'all_statuses' => 'All statuses',
        'all_types' => 'All types',
    ],

    'types' => [
        'personal' => 'Personal',
        'housing' => 'Housing',
        'car' => 'Car',
        'emergency' => 'Emergency',
        'education' => 'Education',
    ],

    'type_labels' => [
        'personal' => 'Personal',
        'housing' => 'Housing',
        'car' => 'Car',
        'emergency' => 'Emergency',
        'education' => 'Education',
        'unknown' => 'Not specified',
    ],

    'status' => [
        'pending' => 'Pending',
        'approved' => 'Approved',
        'active' => 'Active',
        'rejected' => 'Rejected',
        'paid' => 'Paid',
        'cancelled' => 'Cancelled',
        'unknown' => 'Unknown',
    ],

    'table' => [
        'id' => '#',
        'employee_name' => 'Employee Name',
        'type' => 'Loan Type',
        'amount_requested' => 'Amount Requested',
        'amount_paid' => 'Amount Paid',
        'remaining' => 'Remaining',
        'installments_count' => 'Installments',
        'installment_amount' => 'Installment Amount',
        'request_date' => 'Request Date',
        'status' => 'Status',
        'actions' => 'Actions',
    ],

    'not_specified' => 'Not specified',

    'empty' => [
        'title' => 'No loans recorded',
        'subtitle' => 'Start by requesting a new loan',
    ],

    'show' => [
        'title' => 'Loan Details',
        'requested_by' => 'Requested by :name',
    ],

    'headings' => [
        'loan_info' => 'Loan Information',
        'repayment' => 'Repayment Details',
        'purpose' => 'Purpose of the Loan',
        'additional_notes' => 'Additional Notes',
        'rejection_reason' => 'Rejection Reason',
        'payment_history' => 'Payment History',
    ],
    'preview' => [
        'title' => 'Loan Calculation Preview',
        'principal' => 'Principal',
        'interest' => 'Interest',
        'total' => 'Total Amount',
        'monthly' => 'Monthly Installment',
    ],

    'form' => [
        'create_title' => 'Loan Request Form',
        'label_type' => 'Loan Type',
        'label_amount' => 'Amount Requested',
        'label_installments' => 'Installments Count',
        'label_interest_rate' => 'Interest Rate',
        'label_paid_amount' => 'Amount Paid',
        'label_remaining' => 'Remaining Amount',
        'label_installment_amount' => 'Installment Amount',
        'label_start_date' => 'Repayment Start Date',
        'label_reason' => 'Loan Reason',
        'label_notes' => 'Notes',
        'approve' => 'Approve',
        'reject' => 'Reject',
        'edit' => 'Edit',
        'activate' => 'Activate',
        'cancel' => 'Cancel',
        'pay_installment' => 'Pay Installment',
        'print' => 'Print',
        'back' => 'Back',
    ],

    'installment' => [
        'number' => 'Installment #',
        'due_date' => 'Due Date',
        'paid_date' => 'Paid Date',
        'amount' => 'Amount',
        'payment_method' => 'Payment Method',
        'status' => 'Status',
    ],
    'installment_status' => [
        'pending' => 'Pending',
        'paid' => 'Paid',
        'overdue' => 'Overdue',
        'cancelled' => 'Cancelled',
    ],
    'form_placeholders' => [
        'reason' => 'Please describe the purpose of the loan in detail',
        'notes' => 'Any additional notes',
    ],

    'form_extra' => [
        'select_installment' => 'Choose installment',
        'payment_date' => 'Payment Date',
    ],

    'empty' => [
        'title' => 'No loans recorded',
        'subtitle' => 'Start by requesting a new loan',
        'payment_history' => 'No payments recorded yet',
    ],

    'sidebar' => [
        'annual_salary' => 'Annual Salary',
        'active_loans' => 'Active Loans',
        'repayment_progress' => 'Repayment Progress',
        'paid' => 'Paid',
        'remaining' => 'Remaining',
    ],

    'summary' => [
        'installments_paid' => 'Installments Paid',
    ],

    'modal' => [
        'reject_title' => 'Reject Loan Request',
        'reject_reason_label' => 'Rejection Reason',
        'cancel' => 'Cancel',
        'confirm_reject' => 'Reject Request',
    ],
];
