<?php

return [
    'breadcrumb' => [
        'home' => 'Home',
        'leaves' => 'Leaves',
    ],

    'unknown_employee' => 'Unknown employee',
    'not_specified' => 'Not specified',
    'no_reason' => 'No reason provided',
    'days_unit' => 'days',

    'show' => [
        'title' => 'Leave Request Details',
        'breadcrumb' => 'Request Details',
        'request' => 'Leave Request #:id',
        'submitted_by' => 'Submitted by',
        'leave_info' => 'Leave Information',
        'request_details' => 'Request Details',
        'monthly_accumulation' => 'Monthly Accumulation (:year)',
        'overdrawn' => '⚠️ The employee exceeded their balance by :days days — financial deduction is recommended.',
        'total_remaining' => '✅ Total remaining balance so far: :days days.',
    ],

    'create' => [
        'title' => 'Create Leave Request',
        'breadcrumb' => 'Create Request',
        'form_title' => 'Leave Request Form',
    ],

    'edit' => [
        'title' => 'Edit Leave Request',
        'breadcrumb' => 'Edit Request',
        'form_title' => 'Edit Leave Form',
    ],

    'fields' => [
        'type' => 'Leave Type:',
        'from' => 'From',
        'to' => 'To',
        'days' => 'Days',
        'excluded_days' => 'Excluded Days',
        'deductible_days' => 'Deductible Days',
        'unpaid_deducted_days' => 'Days Deducted from Salary',
        'requested_at' => 'Requested At',
        'updated_at' => 'Last Updated',
        'contact' => 'Contact Details',
        'reason' => 'Reason',
        'rejection_reason' => 'Rejection Reason',
    ],

    'monthly_headers' => [
        'month' => 'Month',
        'granted' => 'Granted',
        'used' => 'Used',
        'remaining' => 'Cumulative Remaining',
    ],

    'index' => [
        'title' => 'Leave Management',
        'stats' => [
            'total_requests' => 'Total Requests',
            'approved' => 'Approved',
            'pending' => 'Pending',
            'rejected' => 'Rejected',
            'cancelled' => 'Cancelled',
            'modified' => 'Modified',
        ],
        'requests_title' => 'Leave Requests',
        'new_request_button' => 'New Leave Request',
        'empty' => 'No leave requests found',
    ],

    'filters' => [
        'search_placeholder' => 'Search employee...',
        'all_employees' => 'All employees',
        'all_statuses' => 'All statuses',
        'all_types' => 'All types',
        'all_months' => 'All months',
        'all_years' => 'All years',
        'apply' => 'Apply',
        'reset' => 'Reset',
    ],

    'table' => [
        'employee_name' => 'Employee Name',
        'type' => 'Type',
        'from' => 'From',
        'to' => 'To',
        'days' => 'Days',
        'reason' => 'Reason',
        'requested_at' => 'Requested At',
        'status' => 'Status',
        'actions' => 'Actions',
    ],

    'rules' => [
        'title' => 'General Leave Rules',
        'html' => '<p class="text-muted mb-3">These rules explain how the leave system works. Please read them carefully before submitting any request.</p>
<ul class="list-unstyled">
<li class="mb-2"><strong>1. Leave Types:</strong> The system supports several types: annual, sick, emergency, maternity, paternity, unpaid.</li>
<li class="mb-2"><strong>2. Annual Leaves:</strong> Granted monthly according to the employee allowance set on the employee record.</li>
<li class="mb-2"><strong>3. Accumulation:</strong> Unused days roll over and are added to the next month balance.</li>
<li class="mb-2"><strong>4. Salary Deduction:</strong> If annual or emergency leave exceeds available balance, extra days may be deducted from salary.</li>
<li class="mb-2"><strong>5. Request Status:</strong> Requests can be <span class="badge bg-warning text-dark">pending</span>, <span class="badge bg-success">approved</span>, <span class="badge bg-danger">rejected</span>, or <span class="badge bg-secondary">cancelled</span>.</li>
<li class="mb-2"><strong>6. Modify / Cancel:</strong> Employees can modify or cancel a request while it is pending.</li>
<li class="mb-2"><strong>9. Unpaid Leaves:</strong> Do not affect salary; sick leaves are recorded but not deducted.</li>
<li class="mb-2"><strong>10. Printing:</strong> You can print request details from the show page.</li>
</ul>',
    ],

    'types' => [
        'annual' => 'Annual Leave',
        'sick' => 'Sick Leave',
        'emergency' => 'Emergency Leave',
        'maternity' => 'Maternity Leave',
        'paternity' => 'Paternity Leave',
        'unpaid' => 'Unpaid Leave',
    ],

    'status' => [
        'pending' => 'Pending',
        'approved' => 'Approved',
        'rejected' => 'Rejected',
        'cancelled' => 'Cancelled',
        'modified' => 'Modified',
    ],

    'actions' => [
        'view' => 'View',
        'edit' => 'Edit',
        'cancel' => 'Cancel',
    ],

    'confirm' => [
        'cancel' => 'Are you sure you want to cancel this leave?',
        'approve' => 'Are you sure you want to approve this request?',
        'reject' => 'Are you sure you want to reject this request?',
        'delete' => 'Are you sure you want to delete this request?',
    ],

    'form' => [
        'employee' => 'Employee',
        'select_employee' => 'Select an employee',
        'leave_type' => 'Leave Type',
        'select_type' => 'Select a leave type',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'days_count' => 'Days Count',
        'reason' => 'Reason',
        'reason_placeholder' => 'Please describe the reason for the leave in detail',
        'contact_details' => 'Contact details during leave',
        'contact_placeholder' => 'Phone number or email',
        'submit' => 'Submit Request',
        'back' => 'Back',
        'save_changes' => 'Save Changes',
    ],
];
