<?php

return [
    'stats' => [
        'inactive_title' => 'Offboarded / inactive employees',
        'inactive_subtitle' => 'Last data refresh',
        'active_title' => 'Active employees',
        'active_subtitle' => 'Current workforce',
        'pending_title' => 'Employees pending',
        'pending_subtitle' => 'Awaiting review or onboarding',
        'total_title' => 'Total employees',
        'total_subtitle' => 'All records in the system',
    ],

    'filters' => [
        'quick_search_label' => 'Quick search (name/email)',
        'search_placeholder' => 'Type to search...',
        'department_label' => 'Filter by department',
        'department_all' => 'All departments',
        'position_label' => 'Filter by position',
        'position_all' => 'All positions',
        'status_label' => 'Filter by status',
        'status_all' => 'All statuses',
        'reset_button' => 'Clear filters',
        'reset_title' => 'Reset filters',
    ],

    'table' => [
        'photo' => 'Photo',
        'name' => 'Name (#ID)',
        'email' => 'Email',
        'department' => 'Department',
        'salary' => 'Basic salary (:currency)',
        'incentives' => 'Incentives (:currency)',
        'status' => 'Status',
        'position' => 'Position',
        'actions' => 'Actions',
        'not_specified' => 'Not specified',
        'actions_view' => 'View details',
        'actions_edit' => 'Edit',
        'actions_delete' => 'Delete',
    ],

    'messages' => [
        'delete_confirm' => 'Are you sure you want to delete this employee? They will no longer be able to sign in.',
    ],

    'status_unknown' => 'Unknown',

    'show' => [
        'jump_description' => 'Use these quick buttons to jump between sections on this page.',
            'buttons' => [
            'personal_info' => 'Personal information',
            'salary_components' => 'Salary components',
            'leave_accrual' => 'Leave deduction details (monthly & annual)',
            'attendance' => 'Attendance records',
            'leave_requests' => 'Leave requests',
            'loans' => 'Loan records',
            'deductions' => 'Deduction records',
            'payroll_summary' => 'Payroll summary',
            'paid_salaries' => 'Paid salaries',
        ],
        'profile' => [
            'position_placeholder' => 'Not specified',
            'department_placeholder' => 'Not specified',
            'badges' => [
                'id' => 'ID',
                'email' => 'Email',
                'phone' => 'Phone',
            ],
        ],
        'actions' => [
            'edit' => 'Edit',
            'delete' => 'Delete',
            'delete_confirm' => 'Are you sure you want to delete this employee?',
            'back' => 'Back',
        ],
        'sections' => [
            'personal_info' => 'Personal information',
            'salary_components' => 'Salary components',
            'leave_accrual' => 'Leave deduction details (monthly & annual)',
            'attendance' => 'Attendance records',
            'leave_requests' => 'Leave requests',
            'loan_records' => 'Loan records',
            'deduction_records' => 'Deduction records',
            'payroll_summary' => 'Payroll summary (last 10 payrolls)',
            'paid_salaries' => 'Paid salaries',
        ],
        'personal' => [
            'birth_date' => 'Birth date',
            'age' => 'Age',
            'age_unit' => 'years',
            'national_id' => 'National ID',
            'qualification' => 'Qualification',
            'address' => 'Address',
            'status' => 'Status',
            'status_labels' => [
                'active' => 'Active',
                'inactive' => 'Inactive',
                'pending' => 'Pending employment',
                'unknown' => 'Not specified',
            ],
        ],
        'salary' => [
            'name' => 'Name',
            'value' => 'Amount',
            'no_components' => 'No additional salary components.',
            'total' => 'Estimated total salary:',
        ],
        'leave_accrual' => [
            'title' => 'Leave deduction details (monthly & annual)',
            'labels' => [
                'monthly' => 'Monthly',
                'annual' => 'Annual',
            ],
            'print' => 'Print details',
            'columns' => [
                'year' => 'Year',
                'month' => 'Month',
                'granted' => 'Granted this month',
                'used' => 'Used this month',
                'excess' => 'Excess (days)',
                'balance_before' => 'Balance before deduction',
                'balance_after' => 'Balance after deduction',
                'amount' => 'Leave deduction (:currency)',
                'annual_entitlement' => 'Annual entitlement',
                'annual_granted' => 'Total granted this year',
                'annual_used' => 'Total used this year',
                'annual_excess' => 'Annual excess (days)',
                'annual_remaining' => 'Annual remaining balance',
                'annual_amount' => 'Annual deduction (:currency)',
            ],
            'no_data' => 'No monthly accrual data yet.',
        ],
        'filters' => [
            'all_months' => 'All months',
            'all_years' => 'All years',
            'apply' => 'Apply',
            'print_record' => 'Print record',
            'print_summary' => 'Print summary',
        ],
        'attendance' => [
            'title' => 'Attendance records',
            'columns' => [
                'date' => 'Date',
                'check_in' => 'Check-in',
                'check_out' => 'Check-out',
                'duration' => 'Duration',
                'status' => 'Status',
                'actions' => 'Actions',
            ],
            'no_records' => 'No attendance records.',
        ],
        'leaves' => [
            'title' => 'Leave requests',
            'columns' => [
                'id' => '#',
                'type' => 'Leave type',
                'start' => 'Start date',
                'end' => 'End date',
                'days' => 'Days',
                'reason' => 'Reason',
                'status' => 'Status',
                'actions' => 'Actions',
            ],
            'statuses' => [
                'pending' => 'Pending',
                'approved' => 'Approved',
                'rejected' => 'Rejected',
            ],
            'no_records' => 'No leave requests.',
            'delete_confirm' => 'Are you sure you want to delete this leave request?',
        ],
        'loans' => [
            'title' => 'Loan records',
            'columns' => [
                'id' => '#',
                'amount' => 'Amount',
                'interest' => 'Interest (%)',
                'total' => 'Total amount',
                'installments' => 'Installments',
                'monthly' => 'Monthly installment',
                'date' => 'Request date',
                'status' => 'Status',
                'actions' => 'Actions',
            ],
            'statuses' => [
                'pending' => 'Pending',
                'approved' => 'Approved',
                'active' => 'Active',
                'rejected' => 'Rejected',
                'paid' => 'Paid in full',
                'cancelled' => 'Cancelled',
                'unknown' => 'Not specified',
            ],
            'no_records' => 'No loans.',
            'delete_confirm' => 'Are you sure you want to delete this loan?',
        ],
        'deductions' => [
            'title' => 'Deduction records',
            'columns' => [
                'id' => '#',
                'description' => 'Description',
                'amount' => 'Amount',
                'type' => 'Type',
                'date' => 'Deduction date',
                'status' => 'Status',
                'actions' => 'Actions',
            ],
            'statuses' => [
                'applied' => 'Applied',
                'pending' => 'Pending',
                'cancelled' => 'Cancelled',
                'unknown' => 'Not specified',
            ],
            'no_records' => 'No deductions.',
            'delete_confirm' => 'Are you sure you want to delete this deduction?',
        ],
        'payroll_summary' => [
            'title' => 'Payroll summary (last 10 payrolls)',
            'columns' => [
                'month' => 'Month',
                'gross' => 'Gross salary',
                'other_deductions' => 'Other deductions',
                'loans' => 'Loan installments',
                'leave' => 'Leave deduction',
                'net' => 'Net salary',
                'actions' => 'Actions',
            ],
            'view' => 'View',
            'no_records' => 'No payroll records.',
        ],
        'paid_salaries' => [
            'title' => 'Paid salaries',
            'columns' => [
                'month' => 'Month',
                'gross' => 'Total salary',
                'deductions' => 'Deductions',
                'loans' => 'Loans',
                'leave' => 'Leave deduction',
                'net' => 'Net salary',
                'paid_at' => 'Payment date',
            ],
            'no_records' => 'No paid salaries.',
            'not_paid' => 'Not paid yet',
        ],
        'deduction_types' => [
            'tax' => 'Tax',
            'insurance' => 'Insurance',
            'loan' => 'Loan',
            'fine' => 'Fine',
            'other' => 'Other',
            'cash' => 'Cash',
            'in_kind' => 'In kind',
            'deduction' => 'Deduction',
            'penalty' => 'Penalty',
            'subscription' => 'Subscription',
            'absence' => 'Absence',
            'cash_deduction' => 'Cash deduction',
            'in_kind_deduction' => 'In-kind deduction',
        ],
    ],
    'salary_histories' => [
        'title' => 'سجل الرواتب',
        'no_records' => 'No records found.',
        'add_new' => 'Add New Record',
        'edit_record' => 'Edit Record',
        'table' => [
            'effective_from' => 'Effective From',
            'base_salary' => 'Base Salary',
            'incentives' => 'Incentives',
            'overtime_rate' => 'Overtime/Hour',
            'monthly_leave' => 'Monthly Leave',
            'annual_leave' => 'Annual Leave',
            'components' => 'Additional Components',
            'note' => 'Notes',
            'actions' => 'Actions',
        ],
        'form' => [
            'effective_from' => 'Effective Date',
            'effective_from_hint' => 'Will be automatically converted to the beginning of the month',
            'base_salary' => 'Base Salary',
            'incentives' => 'Incentives',
            'overtime_rate' => 'Overtime Rate (per hour)',
            'monthly_leave_entitlement' => 'Monthly Leave Entitlement',
            'annual_leave_entitlement' => 'Annual Leave Entitlement',
            'components' => 'Additional Salary Components',
            'component_name_placeholder' => 'Component name (e.g., Housing Allowance)',
            'component_value_placeholder' => 'Value',
            'add_component' => 'Add New Component',
            'remove_component' => 'Remove',
            'note' => 'Notes',
            'save' => 'Save Changes',
            'add' => 'Add',
        ],
        'messages' => [
            'delete_confirm' => 'Are you sure?',
        ],
    ],
];

