<?php

$langPath = __DIR__ . '/resources/lang';
$languages = ['ar', 'en', 'es', 'fr'];
$fileNames = [
    'activity.php', 'app.php', 'attendance.php', 'auth.php', 'custom.php',
    'dashboard.php', 'deductions.php', 'employees.php', 'leaves.php', 'loans.php',
    'notifications.php', 'payroll.php', 'settings.php', 'users.php', 'validation.php'
];

$allData = [];

foreach ($languages as $lang) {
    foreach ($fileNames as $file) {
        $filePath = $langPath . '/' . $lang . '/' . $file;
        if (file_exists($filePath)) {
            $content = require $filePath;
            if (is_array($content)) {
                $allData[$file][$lang] = extractKeys($content);
            }
        }
    }
}

$results = [];

foreach ($fileNames as $file) {
    if (!isset($allData[$file])) continue;
    
    $fileData = $allData[$file];
    $results[$file] = ['ar_missing_in_others' => [], 'missing_in_ar' => []];
    
    if (isset($fileData['ar'])) {
        foreach ($fileData['ar'] as $key) {
            foreach (['en', 'es', 'fr'] as $lang) {
                if (!isset($fileData[$lang]) || !in_array($key, $fileData[$lang])) {
                    if (!isset($results[$file]['ar_missing_in_others'][$key])) {
                        $results[$file]['ar_missing_in_others'][$key] = [];
                    }
                    $results[$file]['ar_missing_in_others'][$key][] = $lang;
                }
            }
        }
    }
    
    foreach (['en', 'es', 'fr'] as $lang) {
        if (isset($fileData[$lang])) {
            foreach ($fileData[$lang] as $key) {
                if (!isset($fileData['ar']) || !in_array($key, $fileData['ar'])) {
                    if (!isset($results[$file]['missing_in_ar'][$key])) {
                        $results[$file]['missing_in_ar'][$key] = [];
                    }
                    if (!in_array($lang, $results[$file]['missing_in_ar'][$key])) {
                        $results[$file]['missing_in_ar'][$key][] = $lang;
                    }
                }
            }
        }
    }
}

$totalMissingInOthers = 0;
$totalMissingInAr = 0;
$filesWithIssues = 0;

foreach ($results as $file => $fileResults) {
    if (!empty($fileResults['ar_missing_in_others']) || !empty($fileResults['missing_in_ar'])) {
        $filesWithIssues++;
        $totalMissingInOthers += count($fileResults['ar_missing_in_others']);
        $totalMissingInAr += count($fileResults['missing_in_ar']);
    }
}

$generatedDate = date('Y-m-d H:i:s');

ob_start();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تقرير مقارنة ملفات الترجمة</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI', Arial, sans-serif; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: #333; line-height: 1.6; padding: 20px; }
        .container { max-width: 1200px; margin: 0 auto; background: white; border-radius: 10px; box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3); overflow: hidden; }
        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 40px; text-align: center; }
        .header h1 { font-size: 2.5em; margin-bottom: 10px; text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3); }
        .header p { font-size: 1.1em; opacity: 0.9; }
        .content { padding: 40px; }
        .file-section { margin-bottom: 40px; border: 2px solid #e0e0e0; border-radius: 8px; overflow: hidden; }
        .file-header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 15px 20px; font-weight: bold; font-size: 1.2em; }
        .file-content { padding: 20px; }
        .issue-category { margin-bottom: 30px; }
        .issue-category h3 { margin-bottom: 15px; padding-bottom: 10px; border-bottom: 3px solid; font-size: 1.1em; }
        .issue-category.missing-in-others h3 { border-bottom-color: #f44336; color: #f44336; }
        .issue-category.missing-in-ar h3 { border-bottom-color: #ff9800; color: #ff9800; }
        .key-item { background: #f5f5f5; padding: 12px 15px; margin-bottom: 8px; border-left: 4px solid #667eea; border-radius: 4px; font-family: 'Courier New', monospace; font-size: 0.95em; }
        .issue-category.missing-in-others .key-item { border-left-color: #f44336; }
        .issue-category.missing-in-ar .key-item { border-left-color: #ff9800; }
        .key-name { font-weight: bold; color: #333; margin-bottom: 5px; }
        .missing-langs { color: #666; font-size: 0.9em; }
        .badge { display: inline-block; padding: 3px 8px; border-radius: 12px; font-size: 0.85em; margin-right: 5px; font-weight: bold; }
        .badge-ar { background: #e3f2fd; color: #1976d2; }
        .badge-en { background: #fff3e0; color: #f57c00; }
        .badge-es { background: #fce4ec; color: #c2185b; }
        .badge-fr { background: #f3e5f5; color: #7b1fa2; }
        .no-issues { background: #c8e6c9; color: #2e7d32; padding: 15px; border-radius: 5px; text-align: center; font-weight: bold; }
        .summary { background: #f5f5f5; padding: 20px; border-radius: 8px; margin-bottom: 30px; }
        .summary h2 { margin-bottom: 15px; color: #333; }
        .summary-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; }
        .summary-card { background: white; padding: 15px; border-radius: 5px; border-left: 4px solid; }
        .summary-card h4 { margin-bottom: 8px; font-size: 0.95em; color: #666; }
        .summary-card .count { font-size: 1.8em; font-weight: bold; }
        .summary-card.errors { border-left-color: #f44336; }
        .summary-card.warnings { border-left-color: #ff9800; }
        .footer { background: #f5f5f5; padding: 20px; text-align: center; color: #666; border-top: 1px solid #e0e0e0; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>📊 تقرير مقارنة ملفات الترجمة</h1>
            <p>Language Files Comparison Report</p>
            <p style="margin-top: 10px; font-size: 0.9em;">Generated on: <?php echo $generatedDate; ?></p>
        </div>
        
        <div class="content">
            <div class="summary">
                <h2>📈 ملخص التقرير | Summary</h2>
                <div class="summary-grid">
                    <div class="summary-card errors">
                        <h4>❌ مفاتيح مفقودة في لغات أخرى</h4>
                        <div class="count"><?php echo $totalMissingInOthers; ?></div>
                    </div>
                    <div class="summary-card warnings">
                        <h4>⚠️ مفاتيح مفقودة في AR</h4>
                        <div class="count"><?php echo $totalMissingInAr; ?></div>
                    </div>
                    <div class="summary-card">
                        <h4>📁 الملفات بها مشاكل</h4>
                        <div class="count"><?php echo $filesWithIssues; ?></div>
                    </div>
                </div>
            </div>
            
            <?php
            $hasAnyIssues = false;
            
            foreach ($fileNames as $file) {
                if (!isset($results[$file])) continue;
                
                $fileResults = $results[$file];
                $hasMissingInAr = !empty($fileResults['ar_missing_in_others']);
                $hasMissingFromAr = !empty($fileResults['missing_in_ar']);
                
                if (!$hasMissingInAr && !$hasMissingFromAr) continue;
                
                $hasAnyIssues = true;
                ?>
                <div class="file-section">
                    <div class="file-header">📄 <?php echo htmlspecialchars($file); ?></div>
                    <div class="file-content">
                        <?php if ($hasMissingInAr) { ?>
                        <div class="issue-category missing-in-others">
                            <h3>❌ مفاتيح موجودة في AR لكن مفقودة في لغات أخرى</h3>
                            <p style="margin-bottom: 15px; color: #666;">Keys in AR but MISSING in other languages:</p>
                            <?php foreach ($fileResults['ar_missing_in_others'] as $key => $missingLangs) {
                                sort($missingLangs);
                                ?>
                                <div class="key-item">
                                    <div class="key-name"><?php echo htmlspecialchars($key); ?></div>
                                    <div class="missing-langs">Missing in: 
                                        <?php foreach ($missingLangs as $lang) {
                                            $badges = ['ar' => 'badge-ar', 'en' => 'badge-en', 'es' => 'badge-es', 'fr' => 'badge-fr'];
                                            ?>
                                            <span class="badge <?php echo $badges[$lang]; ?>"><?php echo strtoupper($lang); ?></span>
                                        <?php } ?>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                        <?php } ?>
                        
                        <?php if ($hasMissingFromAr) { ?>
                        <div class="issue-category missing-in-ar">
                            <h3>⚠️ مفاتيح موجودة في لغات أخرى لكن مفقودة في AR</h3>
                            <p style="margin-bottom: 15px; color: #666;">Keys in OTHER languages but MISSING in AR:</p>
                            <?php foreach ($fileResults['missing_in_ar'] as $key => $langs) {
                                sort($langs);
                                ?>
                                <div class="key-item">
                                    <div class="key-name"><?php echo htmlspecialchars($key); ?></div>
                                    <div class="missing-langs">Found in: 
                                        <?php foreach ($langs as $lang) {
                                            $badges = ['ar' => 'badge-ar', 'en' => 'badge-en', 'es' => 'badge-es', 'fr' => 'badge-fr'];
                                            ?>
                                            <span class="badge <?php echo $badges[$lang]; ?>"><?php echo strtoupper($lang); ?></span>
                                        <?php } ?>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
            
            <?php if (!$hasAnyIssues) { ?>
                <div class="no-issues">✅ جميع ملفات الترجمة متطابقة! All translation files are in sync!</div>
            <?php } ?>
        </div>
        
        <div class="footer">
            <p>تم إنشاء هذا التقرير تلقائياً | Auto-generated Report</p>
        </div>
    </div>
</body>
</html>
<?php

$html = ob_get_clean();
$reportPath = __DIR__ . '/translation_report.html';
file_put_contents($reportPath, $html);

echo "✅ تم إنشاء التقرير بنجاح!\n";
echo "Report generated successfully!\n\n";
echo "📄 Path: " . $reportPath . "\n";

function extractKeys($array, $prefix = '') {
    $keys = [];
    foreach ($array as $key => $value) {
        $fullKey = $prefix ? $prefix . '.' . $key : $key;
        if (is_array($value)) {
            $keys = array_merge($keys, extractKeys($value, $fullKey));
        } else {
            $keys[] = $fullKey;
        }
    }
    return $keys;
}
?>
