<?php

$langPath = __DIR__ . '/resources/lang';
$languages = ['ar', 'en', 'es', 'fr'];
$fileNames = [
    'activity.php', 'app.php', 'attendance.php', 'auth.php', 'custom.php',
    'dashboard.php', 'deductions.php', 'employees.php', 'leaves.php', 'loans.php',
    'notifications.php', 'payroll.php', 'settings.php', 'users.php', 'validation.php'
];

$allData = [];

foreach ($languages as $lang) {
    foreach ($fileNames as $file) {
        $filePath = $langPath . '/' . $lang . '/' . $file;
        if (file_exists($filePath)) {
            $content = require $filePath;
            if (is_array($content)) {
                $allData[$file][$lang] = extractKeys($content);
            }
        }
    }
}

$csvData = [];
$csvData[] = ['File', 'Key', 'Issue Type', 'Missing In/Found In', 'Priority'];

foreach ($fileNames as $file) {
    if (!isset($allData[$file])) continue;
    
    $fileData = $allData[$file];
    
    // Keys in AR but missing in others
    if (isset($fileData['ar'])) {
        foreach ($fileData['ar'] as $key) {
            foreach (['en', 'es', 'fr'] as $lang) {
                if (!isset($fileData[$lang]) || !in_array($key, $fileData[$lang])) {
                    $priority = determinePriority($file, count($missingLangs ?? []));
                    $csvData[] = [
                        $file,
                        $key,
                        'Missing in other languages',
                        $lang,
                        $priority
                    ];
                }
            }
        }
    }
    
    // Keys in other languages but missing in AR
    foreach (['en', 'es', 'fr'] as $lang) {
        if (isset($fileData[$lang])) {
            foreach ($fileData[$lang] as $key) {
                if (!isset($fileData['ar']) || !in_array($key, $fileData['ar'])) {
                    $priority = determinePriority($file, 1, 'missing_from_ar');
                    $csvData[] = [
                        $file,
                        $key,
                        'Missing in AR',
                        $lang,
                        $priority
                    ];
                }
            }
        }
    }
}

$csvFile = __DIR__ . '/translation_issues.csv';

$fp = fopen($csvFile, 'w');
foreach ($csvData as $row) {
    fputcsv($fp, $row);
}
fclose($fp);

echo "✅ CSV Report generated successfully!\n";
echo "📄 Path: " . $csvFile . "\n";
echo "📊 Total issues: " . (count($csvData) - 1) . "\n";

function determinePriority($file, $langCount = 1, $type = 'missing_from_ar') {
    if ($file == 'validation.php') return 'CRITICAL';
    if ($file == 'payroll.php' || $file == 'deductions.php') return 'HIGH';
    if ($file == 'settings.php') return 'MEDIUM';
    return 'LOW';
}

function extractKeys($array, $prefix = '') {
    $keys = [];
    foreach ($array as $key => $value) {
        $fullKey = $prefix ? $prefix . '.' . $key : $key;
        if (is_array($value)) {
            $keys = array_merge($keys, extractKeys($value, $fullKey));
        } else {
            $keys[] = $fullKey;
        }
    }
    return $keys;
}
?>
