دليل استخدام أمر `payroll:recalculate`

تحذير مهم: قبل تشغيل أي أمرٍ يقوم بتعديل قاعدة البيانات، اصنع نسخة احتياطية كاملة من قاعدة البيانات.

1) نسخة احتياطية (PowerShell، على Windows):

```powershell
# أنشئ مجلداً للنسخ الاحتياطية إن لم يكن موجوداً
New-Item -ItemType Directory -Path C:\backups -Force

# خزن نسخة من قاعدة البيانات (سيطلب منك كلمة المرور)
mysqldump -u root -p hr11 > C:\backups\hr11_backup_$(Get-Date -Format yyyyMMdd_HHmm).sql
```

2) فحص جاف (dry-run):

```powershell
# فحص لجميع الرواتب (لن يُطبّق تغييرات)
php artisan payroll:recalculate

# فحص لرواتب موظف محدد (ID مفرد أو قائمة مفصولة بفواصل)
php artisan payroll:recalculate --employee=123
php artisan payroll:recalculate --employee=123,456

# فحص للرواتب المنشأة من تاريخ معين (YYYY-MM-DD)
php artisan payroll:recalculate --since=2025-01-01

# مزج المرشحات
php artisan payroll:recalculate --employee=123 --since=2025-01-01
```

3) تطبيق التعديلات (بعد التأكد من النتائج والنسخة الاحتياطية):

```powershell
# تطبيق على جميع الرواتب
php artisan payroll:recalculate --apply

# تطبيق على نطاق محدود
php artisan payroll:recalculate --employee=123 --since=2025-01-01 --apply
```

ملاحظة مهمة عن التعديل البنيوي لقاعدة البيانات:
- أضفت Migration جديدًا يجعل حقل `salary_component_id` في جدول `payroll_salary_components` قابلًا لأن يكون `NULL` (للسماح بمكونات ذات أسماء مخصصة بدون مرجع في جدول `salary_components`).
- قبل تشغيل الميجريشن تحتاج مكتبة `doctrine/dbal` لأنّنا نغير عمودًا موجودًا:

```powershell
# تثبيت مكتبة تغيير الأعمدة (إذا لم تكن مثبتة)
composer require doctrine/dbal

# ثم شغّل الميجريشن لتطبيق التغييرات على قاعدة البيانات
php artisan migrate
```

بعد تشغيل الميجريشن، ستتمكن الدوال من حفظ مكونات الراتب حتى لو لم يكن لها `salary_component_id` مربوطًا.

4) أمور الاختبار بعد التطبيق:
- افتح واجهة إنشاء راتب، أضف مكونات، ثم أنشئ الراتب.
- تحقق من وجود صفوف في جدول `payroll_salary_components` و أن حقل `payrolls.total_salary` يساوي "الأساسي + الحوافز + مجموع المكونات".
- اضغط "دفع" وتحقق أن الحالة تحولت إلى `paid` والقيم المحفوظة لم تتغير.

5) إذا ظهرت مشاكل في الاتصال بقاعدة البيانات:
- تحقق أن MySQL يعمل على جهازك (PowerShell):

```powershell
Get-Service -Name MySQL* | Select-Object Status, Name
```

- إذا احتجت لمسح كاش إعدادات لارافيل بعد تعديل `.env`:

```powershell
php artisan config:clear
php artisan cache:clear
```

6) خيارات إضافية ممكن تنفيذها إذا رغبت:
- إضافة خيار `--month` و`--year` للأمر لتضيّق نطاق الرواتب لشهر وسنة محدّدين.
- إضافة اختبار تلقائي (PHPUnit) يغطي إنشاء `Payroll` مع مكونات والتحقق من حساب القيم.

إذا تريد، أطبّق الآن تغييرات على قاعدة البيانات (`--apply`) وفق فلتر محدد تزوّدني به (مثلاً: `--employee=123 --since=2025-01-01`).

إذا تفضّل أن أضيف خيار `--month`/`--year` أو `--employee-name` للأمر، أخبرني وسأنفّذها.